/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.kafka;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.kafka.KafkaSourceRequest;

public class KafkaSourceDTO {
    @ApiModelProperty(value="Kafka topic")
    private String topic;
    @ApiModelProperty(value="Kafka consumer group")
    private String groupId;
    @ApiModelProperty(value="Kafka servers address, such as: 127.0.0.1:9092")
    private String bootstrapServers;
    @ApiModelProperty(value="Limit the amount of data read per second", notes="Greater than or equal to 0, equal to zero means no limit")
    private String recordSpeedLimit;
    @ApiModelProperty(value="Limit the number of bytes read per second", notes="Greater than or equal to 0, equal to zero means no limit")
    private String byteSpeedLimit;
    @ApiModelProperty(value="Topic partition offset", notes="For example,'partition:0,offset:42;partition:1,offset:300' indicates offset 42 for partition 0 and offset 300 for partition 1.")
    private String partitionOffsets;
    @ApiModelProperty(value="timestamp is millis")
    private String timestampMillis;
    @ApiModelProperty(value="The strategy of auto offset reset", notes="including earliest, latest (the default), none")
    private String autoOffsetReset;
    @ApiModelProperty(value="Data Serialization, support: json, canal, avro, etc")
    private String serializationType;
    @ApiModelProperty(value="database pattern used for filter in canal format")
    private String databasePattern;
    @ApiModelProperty(value="table pattern used for filter in canal format")
    private String tablePattern;
    @ApiModelProperty(value="ignore parse errors, true: ignore parse error; false: not ignore parse error; default true")
    private boolean ignoreParseErrors;
    @ApiModelProperty(value="Timestamp standard for binlog: SQL, ISO_8601")
    private String timestampFormatStandard;
    @ApiModelProperty(value="Field needed when serializationType is csv,json,avro")
    private String primaryKey;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="Data field escape symbol")
    private String dataEscapeChar;
    @ApiModelProperty(value="Properties for Kafka")
    private Map<String, Object> properties;

    public static KafkaSourceDTO getFromRequest(KafkaSourceRequest request) {
        return KafkaSourceDTO.builder().topic(request.getTopic()).groupId(request.getGroupId()).bootstrapServers(request.getBootstrapServers()).recordSpeedLimit(request.getRecordSpeedLimit()).byteSpeedLimit(request.getByteSpeedLimit()).partitionOffsets(request.getPartitionOffsets()).timestampMillis(request.getTimestampMillis()).autoOffsetReset(request.getAutoOffsetReset()).serializationType(request.getSerializationType()).databasePattern(request.getDatabasePattern()).tablePattern(request.getTablePattern()).ignoreParseErrors(request.isIgnoreParseErrors()).timestampFormatStandard(request.getTimestampFormatStandard()).primaryKey(request.getPrimaryKey()).properties(request.getProperties()).build();
    }

    public static KafkaSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (KafkaSourceDTO)JsonUtils.parseObject((String)extParams, KafkaSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of KafkaSource failure: %s", e.getMessage()));
        }
    }

    public static KafkaSourceDTOBuilder builder() {
        return new KafkaSourceDTOBuilder();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getRecordSpeedLimit() {
        return this.recordSpeedLimit;
    }

    public String getByteSpeedLimit() {
        return this.byteSpeedLimit;
    }

    public String getPartitionOffsets() {
        return this.partitionOffsets;
    }

    public String getTimestampMillis() {
        return this.timestampMillis;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public boolean isIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setRecordSpeedLimit(String recordSpeedLimit) {
        this.recordSpeedLimit = recordSpeedLimit;
    }

    public void setByteSpeedLimit(String byteSpeedLimit) {
        this.byteSpeedLimit = byteSpeedLimit;
    }

    public void setPartitionOffsets(String partitionOffsets) {
        this.partitionOffsets = partitionOffsets;
    }

    public void setTimestampMillis(String timestampMillis) {
        this.timestampMillis = timestampMillis;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setIgnoreParseErrors(boolean ignoreParseErrors) {
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSourceDTO)) {
            return false;
        }
        KafkaSourceDTO other = (KafkaSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIgnoreParseErrors() != other.isIgnoreParseErrors()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$recordSpeedLimit = this.getRecordSpeedLimit();
        String other$recordSpeedLimit = other.getRecordSpeedLimit();
        if (this$recordSpeedLimit == null ? other$recordSpeedLimit != null : !this$recordSpeedLimit.equals(other$recordSpeedLimit)) {
            return false;
        }
        String this$byteSpeedLimit = this.getByteSpeedLimit();
        String other$byteSpeedLimit = other.getByteSpeedLimit();
        if (this$byteSpeedLimit == null ? other$byteSpeedLimit != null : !this$byteSpeedLimit.equals(other$byteSpeedLimit)) {
            return false;
        }
        String this$partitionOffsets = this.getPartitionOffsets();
        String other$partitionOffsets = other.getPartitionOffsets();
        if (this$partitionOffsets == null ? other$partitionOffsets != null : !this$partitionOffsets.equals(other$partitionOffsets)) {
            return false;
        }
        String this$timestampMillis = this.getTimestampMillis();
        String other$timestampMillis = other.getTimestampMillis();
        if (this$timestampMillis == null ? other$timestampMillis != null : !this$timestampMillis.equals(other$timestampMillis)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        String this$serializationType = this.getSerializationType();
        String other$serializationType = other.getSerializationType();
        if (this$serializationType == null ? other$serializationType != null : !this$serializationType.equals(other$serializationType)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        if (this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        if (this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreParseErrors() ? 79 : 97);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $recordSpeedLimit = this.getRecordSpeedLimit();
        result = result * 59 + ($recordSpeedLimit == null ? 43 : $recordSpeedLimit.hashCode());
        String $byteSpeedLimit = this.getByteSpeedLimit();
        result = result * 59 + ($byteSpeedLimit == null ? 43 : $byteSpeedLimit.hashCode());
        String $partitionOffsets = this.getPartitionOffsets();
        result = result * 59 + ($partitionOffsets == null ? 43 : $partitionOffsets.hashCode());
        String $timestampMillis = this.getTimestampMillis();
        result = result * 59 + ($timestampMillis == null ? 43 : $timestampMillis.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        String $serializationType = this.getSerializationType();
        result = result * 59 + ($serializationType == null ? 43 : $serializationType.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaSourceDTO(topic=" + this.getTopic() + ", groupId=" + this.getGroupId() + ", bootstrapServers=" + this.getBootstrapServers() + ", recordSpeedLimit=" + this.getRecordSpeedLimit() + ", byteSpeedLimit=" + this.getByteSpeedLimit() + ", partitionOffsets=" + this.getPartitionOffsets() + ", timestampMillis=" + this.getTimestampMillis() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", serializationType=" + this.getSerializationType() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", ignoreParseErrors=" + this.isIgnoreParseErrors() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", primaryKey=" + this.getPrimaryKey() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ", properties=" + this.getProperties() + ")";
    }

    public KafkaSourceDTO(String topic, String groupId, String bootstrapServers, String recordSpeedLimit, String byteSpeedLimit, String partitionOffsets, String timestampMillis, String autoOffsetReset, String serializationType, String databasePattern, String tablePattern, boolean ignoreParseErrors, String timestampFormatStandard, String primaryKey, String dataEncoding, String dataSeparator, String dataEscapeChar, Map<String, Object> properties) {
        this.topic = topic;
        this.groupId = groupId;
        this.bootstrapServers = bootstrapServers;
        this.recordSpeedLimit = recordSpeedLimit;
        this.byteSpeedLimit = byteSpeedLimit;
        this.partitionOffsets = partitionOffsets;
        this.timestampMillis = timestampMillis;
        this.autoOffsetReset = autoOffsetReset;
        this.serializationType = serializationType;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormatStandard = timestampFormatStandard;
        this.primaryKey = primaryKey;
        this.dataEncoding = dataEncoding;
        this.dataSeparator = dataSeparator;
        this.dataEscapeChar = dataEscapeChar;
        this.properties = properties;
    }

    public KafkaSourceDTO() {
    }

    public static class KafkaSourceDTOBuilder {
        private String topic;
        private String groupId;
        private String bootstrapServers;
        private String recordSpeedLimit;
        private String byteSpeedLimit;
        private String partitionOffsets;
        private String timestampMillis;
        private String autoOffsetReset;
        private String serializationType;
        private String databasePattern;
        private String tablePattern;
        private boolean ignoreParseErrors;
        private String timestampFormatStandard;
        private String primaryKey;
        private String dataEncoding;
        private String dataSeparator;
        private String dataEscapeChar;
        private Map<String, Object> properties;

        KafkaSourceDTOBuilder() {
        }

        public KafkaSourceDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public KafkaSourceDTOBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public KafkaSourceDTOBuilder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public KafkaSourceDTOBuilder recordSpeedLimit(String recordSpeedLimit) {
            this.recordSpeedLimit = recordSpeedLimit;
            return this;
        }

        public KafkaSourceDTOBuilder byteSpeedLimit(String byteSpeedLimit) {
            this.byteSpeedLimit = byteSpeedLimit;
            return this;
        }

        public KafkaSourceDTOBuilder partitionOffsets(String partitionOffsets) {
            this.partitionOffsets = partitionOffsets;
            return this;
        }

        public KafkaSourceDTOBuilder timestampMillis(String timestampMillis) {
            this.timestampMillis = timestampMillis;
            return this;
        }

        public KafkaSourceDTOBuilder autoOffsetReset(String autoOffsetReset) {
            this.autoOffsetReset = autoOffsetReset;
            return this;
        }

        public KafkaSourceDTOBuilder serializationType(String serializationType) {
            this.serializationType = serializationType;
            return this;
        }

        public KafkaSourceDTOBuilder databasePattern(String databasePattern) {
            this.databasePattern = databasePattern;
            return this;
        }

        public KafkaSourceDTOBuilder tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return this;
        }

        public KafkaSourceDTOBuilder ignoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public KafkaSourceDTOBuilder timestampFormatStandard(String timestampFormatStandard) {
            this.timestampFormatStandard = timestampFormatStandard;
            return this;
        }

        public KafkaSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public KafkaSourceDTOBuilder dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return this;
        }

        public KafkaSourceDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public KafkaSourceDTOBuilder dataEscapeChar(String dataEscapeChar) {
            this.dataEscapeChar = dataEscapeChar;
            return this;
        }

        public KafkaSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public KafkaSourceDTO build() {
            return new KafkaSourceDTO(this.topic, this.groupId, this.bootstrapServers, this.recordSpeedLimit, this.byteSpeedLimit, this.partitionOffsets, this.timestampMillis, this.autoOffsetReset, this.serializationType, this.databasePattern, this.tablePattern, this.ignoreParseErrors, this.timestampFormatStandard, this.primaryKey, this.dataEncoding, this.dataSeparator, this.dataEscapeChar, this.properties);
        }

        public String toString() {
            return "KafkaSourceDTO.KafkaSourceDTOBuilder(topic=" + this.topic + ", groupId=" + this.groupId + ", bootstrapServers=" + this.bootstrapServers + ", recordSpeedLimit=" + this.recordSpeedLimit + ", byteSpeedLimit=" + this.byteSpeedLimit + ", partitionOffsets=" + this.partitionOffsets + ", timestampMillis=" + this.timestampMillis + ", autoOffsetReset=" + this.autoOffsetReset + ", serializationType=" + this.serializationType + ", databasePattern=" + this.databasePattern + ", tablePattern=" + this.tablePattern + ", ignoreParseErrors=" + this.ignoreParseErrors + ", timestampFormatStandard=" + this.timestampFormatStandard + ", primaryKey=" + this.primaryKey + ", dataEncoding=" + this.dataEncoding + ", dataSeparator=" + this.dataSeparator + ", dataEscapeChar=" + this.dataEscapeChar + ", properties=" + this.properties + ")";
        }
    }
}

