/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.pulsar;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.pulsar.PulsarSourceRequest;

public class PulsarSourceDTO {
    @ApiModelProperty(value="Pulsar tenant")
    private String tenant;
    @ApiModelProperty(value="Pulsar namespace")
    private String namespace;
    @ApiModelProperty(value="Pulsar topic")
    private String topic;
    @ApiModelProperty(value="Pulsar adminUrl")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar serviceUrl")
    private String serviceUrl;
    @ApiModelProperty(value="Primary key, needed when serialization type is csv, json, avro")
    private String primaryKey;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="Data field escape symbol")
    private String dataEscapeChar;
    @ApiModelProperty(value="Configure the Source's startup mode. Available options are earliest, latest, external-subscription, and specific-offsets.")
    private String scanStartupMode;
    @ApiModelProperty(value="Properties for Pulsar")
    private Map<String, Object> properties;

    public static PulsarSourceDTO getFromRequest(PulsarSourceRequest request) {
        return PulsarSourceDTO.builder().adminUrl(request.getAdminUrl()).serviceUrl(request.getServiceUrl()).tenant(request.getTenant()).namespace(request.getNamespace()).topic(request.getTopic()).primaryKey(request.getPrimaryKey()).scanStartupMode(request.getScanStartupMode()).properties(request.getProperties()).build();
    }

    public static PulsarSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (PulsarSourceDTO)JsonUtils.parseObject((String)extParams, PulsarSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of PulsarSource failure: %s", e.getMessage()));
        }
    }

    private static String $default$scanStartupMode() {
        return "earliest";
    }

    public static PulsarSourceDTOBuilder builder() {
        return new PulsarSourceDTOBuilder();
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarSourceDTO)) {
            return false;
        }
        PulsarSourceDTO other = (PulsarSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        if (this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        if (this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "PulsarSourceDTO(tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", topic=" + this.getTopic() + ", adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", primaryKey=" + this.getPrimaryKey() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ", scanStartupMode=" + this.getScanStartupMode() + ", properties=" + this.getProperties() + ")";
    }

    public PulsarSourceDTO(String tenant, String namespace, String topic, String adminUrl, String serviceUrl, String primaryKey, String dataEncoding, String dataSeparator, String dataEscapeChar, String scanStartupMode, Map<String, Object> properties) {
        this.tenant = tenant;
        this.namespace = namespace;
        this.topic = topic;
        this.adminUrl = adminUrl;
        this.serviceUrl = serviceUrl;
        this.primaryKey = primaryKey;
        this.dataEncoding = dataEncoding;
        this.dataSeparator = dataSeparator;
        this.dataEscapeChar = dataEscapeChar;
        this.scanStartupMode = scanStartupMode;
        this.properties = properties;
    }

    public PulsarSourceDTO() {
        this.scanStartupMode = PulsarSourceDTO.$default$scanStartupMode();
    }

    public static class PulsarSourceDTOBuilder {
        private String tenant;
        private String namespace;
        private String topic;
        private String adminUrl;
        private String serviceUrl;
        private String primaryKey;
        private String dataEncoding;
        private String dataSeparator;
        private String dataEscapeChar;
        private boolean scanStartupMode$set;
        private String scanStartupMode$value;
        private Map<String, Object> properties;

        PulsarSourceDTOBuilder() {
        }

        public PulsarSourceDTOBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public PulsarSourceDTOBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PulsarSourceDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public PulsarSourceDTOBuilder adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return this;
        }

        public PulsarSourceDTOBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public PulsarSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public PulsarSourceDTOBuilder dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return this;
        }

        public PulsarSourceDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public PulsarSourceDTOBuilder dataEscapeChar(String dataEscapeChar) {
            this.dataEscapeChar = dataEscapeChar;
            return this;
        }

        public PulsarSourceDTOBuilder scanStartupMode(String scanStartupMode) {
            this.scanStartupMode$value = scanStartupMode;
            this.scanStartupMode$set = true;
            return this;
        }

        public PulsarSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public PulsarSourceDTO build() {
            String scanStartupMode$value = this.scanStartupMode$value;
            if (!this.scanStartupMode$set) {
                scanStartupMode$value = PulsarSourceDTO.$default$scanStartupMode();
            }
            return new PulsarSourceDTO(this.tenant, this.namespace, this.topic, this.adminUrl, this.serviceUrl, this.primaryKey, this.dataEncoding, this.dataSeparator, this.dataEscapeChar, scanStartupMode$value, this.properties);
        }

        public String toString() {
            return "PulsarSourceDTO.PulsarSourceDTOBuilder(tenant=" + this.tenant + ", namespace=" + this.namespace + ", topic=" + this.topic + ", adminUrl=" + this.adminUrl + ", serviceUrl=" + this.serviceUrl + ", primaryKey=" + this.primaryKey + ", dataEncoding=" + this.dataEncoding + ", dataSeparator=" + this.dataSeparator + ", dataEscapeChar=" + this.dataEscapeChar + ", scanStartupMode$value=" + this.scanStartupMode$value + ", properties=" + this.properties + ")";
        }
    }
}

