/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.nio.charset.StandardCharsets;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;

@ApiModel(value="Pulsar source request")
@JsonTypeDefine(value="PULSAR")
public class PulsarSourceRequest
extends SourceRequest {
    @ApiModelProperty(value="Pulsar tenant")
    private String tenant = "default";
    @ApiModelProperty(value="Pulsar namespace")
    private String namespace;
    @ApiModelProperty(value="Pulsar topic")
    private String topic;
    @ApiModelProperty(value="Pulsar adminUrl")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar serviceUrl")
    private String serviceUrl;
    @ApiModelProperty(value="Primary key, needed when serialization type is csv, json, avro")
    private String primaryKey;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding = StandardCharsets.UTF_8.toString();
    @ApiModelProperty(value="Data separator")
    private String dataSeparator = String.valueOf(124);
    @ApiModelProperty(value="Data field escape symbol")
    private String dataEscapeChar;
    @ApiModelProperty(value="Configure the Source's startup mode. Available options are earliest, latest, external-subscription, and specific-offsets.")
    private String scanStartupMode = "earliest";

    public PulsarSourceRequest() {
        this.setSourceType("PULSAR");
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    @Override
    public String toString() {
        return "PulsarSourceRequest(super=" + super.toString() + ", tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", topic=" + this.getTopic() + ", adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", primaryKey=" + this.getPrimaryKey() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ", scanStartupMode=" + this.getScanStartupMode() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarSourceRequest)) {
            return false;
        }
        PulsarSourceRequest other = (PulsarSourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        if (this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        return !(this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarSourceRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        return result;
    }
}

