/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.sqlserver;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;

@ApiModel(value="SQLServer source request")
@JsonTypeDefine(value="SQLSERVER")
public class SQLServerSourceRequest
extends SourceRequest {
    @ApiModelProperty(value="Username of the SQLServer server")
    private String username;
    @ApiModelProperty(value="Password of the SQLServer server")
    private String password;
    @ApiModelProperty(value="Hostname of the SQLServer server")
    private String hostname;
    @ApiModelProperty(value="Port of the SQLServer server")
    private Integer port = 1433;
    @ApiModelProperty(value="Database name")
    private String database;
    @ApiModelProperty(value="Schema name")
    private String schemaName;
    @ApiModelProperty(value="Table name")
    private String tableName;
    @ApiModelProperty(value="Database time zone, default is UTC")
    private String serverTimezone;
    @ApiModelProperty(value="Whether to migrate all databases")
    private boolean allMigration;
    @ApiModelProperty(value="Primary key must be shared by all tables")
    private String primaryKey;

    public SQLServerSourceRequest() {
        this.setSourceType("SQLSERVER");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getServerTimezone() {
        return this.serverTimezone;
    }

    public boolean isAllMigration() {
        return this.allMigration;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setServerTimezone(String serverTimezone) {
        this.serverTimezone = serverTimezone;
    }

    public void setAllMigration(boolean allMigration) {
        this.allMigration = allMigration;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "SQLServerSourceRequest(super=" + super.toString() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", serverTimezone=" + this.getServerTimezone() + ", allMigration=" + this.isAllMigration() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLServerSourceRequest)) {
            return false;
        }
        SQLServerSourceRequest other = (SQLServerSourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAllMigration() != other.isAllMigration()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$serverTimezone = this.getServerTimezone();
        String other$serverTimezone = other.getServerTimezone();
        if (this$serverTimezone == null ? other$serverTimezone != null : !this$serverTimezone.equals(other$serverTimezone)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SQLServerSourceRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAllMigration() ? 79 : 97);
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $serverTimezone = this.getServerTimezone();
        result = result * 59 + ($serverTimezone == null ? 43 : $serverTimezone.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }
}

