/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.workflow;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.pojo.common.PageRequest;

@ApiModel(value="Workflow approver query request")
public class ApproverPageRequest
extends PageRequest {
    @ApiModelProperty(value="Keywords, can be process name, task name, approver name, etc.")
    private String keyword;
    @ApiModelProperty(value="Workflow process name")
    private String processName;
    @ApiModelProperty(value="Workflow task name")
    private String taskName;
    @ApiModelProperty(value="Specified workflow approver")
    private String approver;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;
    @ApiModelProperty(value="Whether the current user is in the administrator role", hidden=true)
    private Boolean isAdminRole;

    public static ApproverPageRequestBuilder builder() {
        return new ApproverPageRequestBuilder();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getApprover() {
        return this.approver;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public Boolean getIsAdminRole() {
        return this.isAdminRole;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setApprover(String approver) {
        this.approver = approver;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setIsAdminRole(Boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public String toString() {
        return "ApproverPageRequest(keyword=" + this.getKeyword() + ", processName=" + this.getProcessName() + ", taskName=" + this.getTaskName() + ", approver=" + this.getApprover() + ", currentUser=" + this.getCurrentUser() + ", isAdminRole=" + this.getIsAdminRole() + ")";
    }

    public ApproverPageRequest() {
    }

    public ApproverPageRequest(String keyword, String processName, String taskName, String approver, String currentUser, Boolean isAdminRole) {
        this.keyword = keyword;
        this.processName = processName;
        this.taskName = taskName;
        this.approver = approver;
        this.currentUser = currentUser;
        this.isAdminRole = isAdminRole;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApproverPageRequest)) {
            return false;
        }
        ApproverPageRequest other = (ApproverPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isAdminRole = this.getIsAdminRole();
        Boolean other$isAdminRole = other.getIsAdminRole();
        if (this$isAdminRole == null ? other$isAdminRole != null : !((Object)this$isAdminRole).equals(other$isAdminRole)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$processName = this.getProcessName();
        String other$processName = other.getProcessName();
        if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$approver = this.getApprover();
        String other$approver = other.getApprover();
        if (this$approver == null ? other$approver != null : !this$approver.equals(other$approver)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        return !(this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApproverPageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isAdminRole = this.getIsAdminRole();
        result = result * 59 + ($isAdminRole == null ? 43 : ((Object)$isAdminRole).hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $processName = this.getProcessName();
        result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $approver = this.getApprover();
        result = result * 59 + ($approver == null ? 43 : $approver.hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        return result;
    }

    public static class ApproverPageRequestBuilder {
        private String keyword;
        private String processName;
        private String taskName;
        private String approver;
        private String currentUser;
        private Boolean isAdminRole;

        ApproverPageRequestBuilder() {
        }

        public ApproverPageRequestBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public ApproverPageRequestBuilder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public ApproverPageRequestBuilder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public ApproverPageRequestBuilder approver(String approver) {
            this.approver = approver;
            return this;
        }

        public ApproverPageRequestBuilder currentUser(String currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public ApproverPageRequestBuilder isAdminRole(Boolean isAdminRole) {
            this.isAdminRole = isAdminRole;
            return this;
        }

        public ApproverPageRequest build() {
            return new ApproverPageRequest(this.keyword, this.processName, this.taskName, this.approver, this.currentUser, this.isAdminRole);
        }

        public String toString() {
            return "ApproverPageRequest.ApproverPageRequestBuilder(keyword=" + this.keyword + ", processName=" + this.processName + ", taskName=" + this.taskName + ", approver=" + this.approver + ", currentUser=" + this.currentUser + ", isAdminRole=" + this.isAdminRole + ")";
        }
    }
}

