/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Cluster bind and unbind tag request")
public class BindTagRequest {
    @ApiModelProperty(value="Cluster tag")
    @NotBlank(message="clusterTag cannot be blank")
    @Length(min=1, max=128, message="length must be between 1 and 128")
    @Pattern(regexp="^[a-z0-9_-]{1,128}$", message="only supports lowercase letters, numbers, '-', or '_'")
    private @NotBlank(message="clusterTag cannot be blank") @Length(min=1, max=128, message="length must be between 1 and 128") @Pattern(regexp="^[a-z0-9_-]{1,128}$", message="only supports lowercase letters, numbers, '-', or '_'") String clusterTag;
    @ApiModelProperty(value="Cluster-ID list which needs to bind tag")
    private List<Integer> bindClusters;
    @ApiModelProperty(value="Cluster-ID list which needs to unbind tag")
    private List<Integer> unbindClusters;

    public String getClusterTag() {
        return this.clusterTag;
    }

    public List<Integer> getBindClusters() {
        return this.bindClusters;
    }

    public List<Integer> getUnbindClusters() {
        return this.unbindClusters;
    }

    public void setClusterTag(String clusterTag) {
        this.clusterTag = clusterTag;
    }

    public void setBindClusters(List<Integer> bindClusters) {
        this.bindClusters = bindClusters;
    }

    public void setUnbindClusters(List<Integer> unbindClusters) {
        this.unbindClusters = unbindClusters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindTagRequest)) {
            return false;
        }
        BindTagRequest other = (BindTagRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clusterTag = this.getClusterTag();
        String other$clusterTag = other.getClusterTag();
        if (this$clusterTag == null ? other$clusterTag != null : !this$clusterTag.equals(other$clusterTag)) {
            return false;
        }
        List<Integer> this$bindClusters = this.getBindClusters();
        List<Integer> other$bindClusters = other.getBindClusters();
        if (this$bindClusters == null ? other$bindClusters != null : !((Object)this$bindClusters).equals(other$bindClusters)) {
            return false;
        }
        List<Integer> this$unbindClusters = this.getUnbindClusters();
        List<Integer> other$unbindClusters = other.getUnbindClusters();
        return !(this$unbindClusters == null ? other$unbindClusters != null : !((Object)this$unbindClusters).equals(other$unbindClusters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BindTagRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clusterTag = this.getClusterTag();
        result = result * 59 + ($clusterTag == null ? 43 : $clusterTag.hashCode());
        List<Integer> $bindClusters = this.getBindClusters();
        result = result * 59 + ($bindClusters == null ? 43 : ((Object)$bindClusters).hashCode());
        List<Integer> $unbindClusters = this.getUnbindClusters();
        result = result * 59 + ($unbindClusters == null ? 43 : ((Object)$unbindClusters).hashCode());
        return result;
    }

    public String toString() {
        return "BindTagRequest(clusterTag=" + this.getClusterTag() + ", bindClusters=" + this.getBindClusters() + ", unbindClusters=" + this.getUnbindClusters() + ")";
    }
}

