/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterRequest;

@ApiModel(value="Kafka cluster info")
public class KafkaClusterDTO {
    @JsonProperty(value="bootstrap.servers")
    @ApiModelProperty(value="Kafka bootstrap servers' URL, is the 'url' field of the cluster")
    private String bootstrapServers;
    private String messageQueueHandler;

    public static KafkaClusterDTO getFromRequest(KafkaClusterRequest request) {
        return KafkaClusterDTO.builder().bootstrapServers(request.getUrl()).build();
    }

    public static KafkaClusterDTO getFromJson(@NotNull String extParams) {
        try {
            return (KafkaClusterDTO)JsonUtils.parseObject((String)extParams, KafkaClusterDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("parse extParams of Kafka Cluster failure: %s", e.getMessage()));
        }
    }

    private static String $default$messageQueueHandler() {
        return "org.apache.inlong.dataproxy.sink.mq.kafka.KafkaHandler";
    }

    public static KafkaClusterDTOBuilder builder() {
        return new KafkaClusterDTOBuilder();
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getMessageQueueHandler() {
        return this.messageQueueHandler;
    }

    @JsonProperty(value="bootstrap.servers")
    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setMessageQueueHandler(String messageQueueHandler) {
        this.messageQueueHandler = messageQueueHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClusterDTO)) {
            return false;
        }
        KafkaClusterDTO other = (KafkaClusterDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$messageQueueHandler = this.getMessageQueueHandler();
        String other$messageQueueHandler = other.getMessageQueueHandler();
        return !(this$messageQueueHandler == null ? other$messageQueueHandler != null : !this$messageQueueHandler.equals(other$messageQueueHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaClusterDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $messageQueueHandler = this.getMessageQueueHandler();
        result = result * 59 + ($messageQueueHandler == null ? 43 : $messageQueueHandler.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaClusterDTO(bootstrapServers=" + this.getBootstrapServers() + ", messageQueueHandler=" + this.getMessageQueueHandler() + ")";
    }

    public KafkaClusterDTO() {
        this.messageQueueHandler = KafkaClusterDTO.$default$messageQueueHandler();
    }

    public KafkaClusterDTO(String bootstrapServers, String messageQueueHandler) {
        this.bootstrapServers = bootstrapServers;
        this.messageQueueHandler = messageQueueHandler;
    }

    public static class KafkaClusterDTOBuilder {
        private String bootstrapServers;
        private boolean messageQueueHandler$set;
        private String messageQueueHandler$value;

        KafkaClusterDTOBuilder() {
        }

        @JsonProperty(value="bootstrap.servers")
        public KafkaClusterDTOBuilder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public KafkaClusterDTOBuilder messageQueueHandler(String messageQueueHandler) {
            this.messageQueueHandler$value = messageQueueHandler;
            this.messageQueueHandler$set = true;
            return this;
        }

        public KafkaClusterDTO build() {
            String messageQueueHandler$value = this.messageQueueHandler$value;
            if (!this.messageQueueHandler$set) {
                messageQueueHandler$value = KafkaClusterDTO.$default$messageQueueHandler();
            }
            return new KafkaClusterDTO(this.bootstrapServers, messageQueueHandler$value);
        }

        public String toString() {
            return "KafkaClusterDTO.KafkaClusterDTOBuilder(bootstrapServers=" + this.bootstrapServers + ", messageQueueHandler$value=" + this.messageQueueHandler$value + ")";
        }
    }
}

