/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.consume;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.consume.BaseInlongConsume;

@ApiModel(value="Base inlong consume request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="mqType")
public abstract class InlongConsumeRequest
extends BaseInlongConsume {
    @NotNull(groups={UpdateValidation.class})
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @NotBlank(message="consumerGroup cannot be null")
    @ApiModelProperty(value="Consumer group, only support [a-zA-Z0-9_]")
    private @NotBlank(message="consumerGroup cannot be null") String consumerGroup;
    @ApiModelProperty(value="MQ type, high throughput: TUBEMQ, high consistency: PULSAR")
    private String mqType;
    @ApiModelProperty(value="The target topic of this consume")
    private String topic;
    @NotBlank(message="inlong group id cannot be null")
    @ApiModelProperty(value="The target inlong group id of this consume")
    private @NotBlank(message="inlong group id cannot be null") String inlongGroupId;
    @ApiModelProperty(value="Whether to filter consumption, 0-not filter, 1-filter")
    private Integer filterEnabled = 0;
    @ApiModelProperty(value="The target inlong stream id of this consume, needed if the filterEnabled=1")
    private String inlongStreamId;
    @NotBlank(message="inCharges cannot be null")
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    private @NotBlank(message="inCharges cannot be null") String inCharges;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public Integer getFilterEnabled() {
        return this.filterEnabled;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setFilterEnabled(Integer filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "InlongConsumeRequest(id=" + this.getId() + ", consumerGroup=" + this.getConsumerGroup() + ", mqType=" + this.getMqType() + ", topic=" + this.getTopic() + ", inlongGroupId=" + this.getInlongGroupId() + ", filterEnabled=" + this.getFilterEnabled() + ", inlongStreamId=" + this.getInlongStreamId() + ", inCharges=" + this.getInCharges() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongConsumeRequest)) {
            return false;
        }
        InlongConsumeRequest other = (InlongConsumeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$filterEnabled = this.getFilterEnabled();
        Integer other$filterEnabled = other.getFilterEnabled();
        if (this$filterEnabled == null ? other$filterEnabled != null : !((Object)this$filterEnabled).equals(other$filterEnabled)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$consumerGroup = this.getConsumerGroup();
        String other$consumerGroup = other.getConsumerGroup();
        if (this$consumerGroup == null ? other$consumerGroup != null : !this$consumerGroup.equals(other$consumerGroup)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        return !(this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongConsumeRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $filterEnabled = this.getFilterEnabled();
        result = result * 59 + ($filterEnabled == null ? 43 : ((Object)$filterEnabled).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $consumerGroup = this.getConsumerGroup();
        result = result * 59 + ($consumerGroup == null ? 43 : $consumerGroup.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        return result;
    }

    public InlongConsumeRequest() {
    }

    public InlongConsumeRequest(Integer id, String consumerGroup, String mqType, String topic, String inlongGroupId, Integer filterEnabled, String inlongStreamId, String inCharges, Integer version) {
        this.id = id;
        this.consumerGroup = consumerGroup;
        this.mqType = mqType;
        this.topic = topic;
        this.inlongGroupId = inlongGroupId;
        this.filterEnabled = filterEnabled;
        this.inlongStreamId = inlongStreamId;
        this.inCharges = inCharges;
        this.version = version;
    }
}

