/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.consume.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.consume.BaseInlongConsume;
import org.apache.inlong.manager.pojo.consume.pulsar.ConsumePulsarRequest;

@ApiModel(value="Inlong group dto of Pulsar")
public class ConsumePulsarDTO
extends BaseInlongConsume {
    @ApiModelProperty(value="Whether to configure the dead letter queue, 0: not configure, 1: configure")
    private Integer isDlq;
    @ApiModelProperty(value="The name of the dead letter queue Topic")
    private String deadLetterTopic;
    @ApiModelProperty(value="Whether to configure the retry letter queue, 0: not configure, 1: configure")
    private Integer isRlq;
    @ApiModelProperty(value="The name of the retry letter queue topic")
    private String retryLetterTopic;

    public static ConsumePulsarDTO getFromRequest(ConsumePulsarRequest request) {
        return (ConsumePulsarDTO)CommonBeanUtils.copyProperties((Object)request, ConsumePulsarDTO::new, (boolean)true);
    }

    public static ConsumePulsarDTO getFromJson(@NotNull String extParams) {
        try {
            return (ConsumePulsarDTO)JsonUtils.parseObject((String)extParams, ConsumePulsarDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CONSUMER_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static ConsumePulsarDTOBuilder builder() {
        return new ConsumePulsarDTOBuilder();
    }

    public Integer getIsDlq() {
        return this.isDlq;
    }

    public String getDeadLetterTopic() {
        return this.deadLetterTopic;
    }

    public Integer getIsRlq() {
        return this.isRlq;
    }

    public String getRetryLetterTopic() {
        return this.retryLetterTopic;
    }

    public void setIsDlq(Integer isDlq) {
        this.isDlq = isDlq;
    }

    public void setDeadLetterTopic(String deadLetterTopic) {
        this.deadLetterTopic = deadLetterTopic;
    }

    public void setIsRlq(Integer isRlq) {
        this.isRlq = isRlq;
    }

    public void setRetryLetterTopic(String retryLetterTopic) {
        this.retryLetterTopic = retryLetterTopic;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumePulsarDTO)) {
            return false;
        }
        ConsumePulsarDTO other = (ConsumePulsarDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$isDlq = this.getIsDlq();
        Integer other$isDlq = other.getIsDlq();
        if (this$isDlq == null ? other$isDlq != null : !((Object)this$isDlq).equals(other$isDlq)) {
            return false;
        }
        Integer this$isRlq = this.getIsRlq();
        Integer other$isRlq = other.getIsRlq();
        if (this$isRlq == null ? other$isRlq != null : !((Object)this$isRlq).equals(other$isRlq)) {
            return false;
        }
        String this$deadLetterTopic = this.getDeadLetterTopic();
        String other$deadLetterTopic = other.getDeadLetterTopic();
        if (this$deadLetterTopic == null ? other$deadLetterTopic != null : !this$deadLetterTopic.equals(other$deadLetterTopic)) {
            return false;
        }
        String this$retryLetterTopic = this.getRetryLetterTopic();
        String other$retryLetterTopic = other.getRetryLetterTopic();
        return !(this$retryLetterTopic == null ? other$retryLetterTopic != null : !this$retryLetterTopic.equals(other$retryLetterTopic));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConsumePulsarDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $isDlq = this.getIsDlq();
        result = result * 59 + ($isDlq == null ? 43 : ((Object)$isDlq).hashCode());
        Integer $isRlq = this.getIsRlq();
        result = result * 59 + ($isRlq == null ? 43 : ((Object)$isRlq).hashCode());
        String $deadLetterTopic = this.getDeadLetterTopic();
        result = result * 59 + ($deadLetterTopic == null ? 43 : $deadLetterTopic.hashCode());
        String $retryLetterTopic = this.getRetryLetterTopic();
        result = result * 59 + ($retryLetterTopic == null ? 43 : $retryLetterTopic.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ConsumePulsarDTO(isDlq=" + this.getIsDlq() + ", deadLetterTopic=" + this.getDeadLetterTopic() + ", isRlq=" + this.getIsRlq() + ", retryLetterTopic=" + this.getRetryLetterTopic() + ")";
    }

    public ConsumePulsarDTO() {
    }

    public ConsumePulsarDTO(Integer isDlq, String deadLetterTopic, Integer isRlq, String retryLetterTopic) {
        this.isDlq = isDlq;
        this.deadLetterTopic = deadLetterTopic;
        this.isRlq = isRlq;
        this.retryLetterTopic = retryLetterTopic;
    }

    public static class ConsumePulsarDTOBuilder {
        private Integer isDlq;
        private String deadLetterTopic;
        private Integer isRlq;
        private String retryLetterTopic;

        ConsumePulsarDTOBuilder() {
        }

        public ConsumePulsarDTOBuilder isDlq(Integer isDlq) {
            this.isDlq = isDlq;
            return this;
        }

        public ConsumePulsarDTOBuilder deadLetterTopic(String deadLetterTopic) {
            this.deadLetterTopic = deadLetterTopic;
            return this;
        }

        public ConsumePulsarDTOBuilder isRlq(Integer isRlq) {
            this.isRlq = isRlq;
            return this;
        }

        public ConsumePulsarDTOBuilder retryLetterTopic(String retryLetterTopic) {
            this.retryLetterTopic = retryLetterTopic;
            return this;
        }

        public ConsumePulsarDTO build() {
            return new ConsumePulsarDTO(this.isDlq, this.deadLetterTopic, this.isRlq, this.retryLetterTopic);
        }

        public String toString() {
            return "ConsumePulsarDTO.ConsumePulsarDTOBuilder(isDlq=" + this.isDlq + ", deadLetterTopic=" + this.deadLetterTopic + ", isRlq=" + this.isRlq + ", retryLetterTopic=" + this.retryLetterTopic + ")";
        }
    }
}

