/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.group.BaseInlongGroup;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarRequest;

@ApiModel(value="Inlong group info for Pulsar")
public class InlongPulsarDTO
extends BaseInlongGroup {
    @ApiModelProperty(value="Pulsar tenant")
    private String tenant;
    @ApiModelProperty(value="Queue model, parallel: multiple partitions, high throughput, out-of-order messages;serial: single partition, low throughput, and orderly messages")
    private String queueModule;
    @ApiModelProperty(value="Number of partitions of Topic, 1-20")
    private Integer partitionNum;
    @ApiModelProperty(value="Ledger's number of writable nodes")
    private Integer ensemble;
    @ApiModelProperty(value="Ledger's number of copies")
    private Integer writeQuorum;
    @ApiModelProperty(value="Number of responses requested")
    private Integer ackQuorum;
    @ApiModelProperty(value="Message time-to-live duration")
    private Integer ttl;
    @ApiModelProperty(value="The unit of message's time-to-live duration")
    private String ttlUnit;
    @ApiModelProperty(value="Message storage time")
    private Integer retentionTime;
    @ApiModelProperty(value="The unit of the message storage time")
    private String retentionTimeUnit;
    @ApiModelProperty(value="Message size")
    private Integer retentionSize;
    @ApiModelProperty(value="The unit of message size")
    private String retentionSizeUnit;

    public static InlongPulsarDTO getFromRequest(InlongPulsarRequest request) {
        return (InlongPulsarDTO)CommonBeanUtils.copyProperties((Object)request, InlongPulsarDTO::new, (boolean)true);
    }

    public static InlongPulsarDTO getFromJson(@NotNull String extParams) {
        try {
            return (InlongPulsarDTO)JsonUtils.parseObject((String)extParams, InlongPulsarDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("parse extParams of Pulsar failure: %s", e.getMessage()));
        }
    }

    public static InlongPulsarDTOBuilder builder() {
        return new InlongPulsarDTOBuilder();
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getQueueModule() {
        return this.queueModule;
    }

    public Integer getPartitionNum() {
        return this.partitionNum;
    }

    public Integer getEnsemble() {
        return this.ensemble;
    }

    public Integer getWriteQuorum() {
        return this.writeQuorum;
    }

    public Integer getAckQuorum() {
        return this.ackQuorum;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public String getTtlUnit() {
        return this.ttlUnit;
    }

    public Integer getRetentionTime() {
        return this.retentionTime;
    }

    public String getRetentionTimeUnit() {
        return this.retentionTimeUnit;
    }

    public Integer getRetentionSize() {
        return this.retentionSize;
    }

    public String getRetentionSizeUnit() {
        return this.retentionSizeUnit;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setQueueModule(String queueModule) {
        this.queueModule = queueModule;
    }

    public void setPartitionNum(Integer partitionNum) {
        this.partitionNum = partitionNum;
    }

    public void setEnsemble(Integer ensemble) {
        this.ensemble = ensemble;
    }

    public void setWriteQuorum(Integer writeQuorum) {
        this.writeQuorum = writeQuorum;
    }

    public void setAckQuorum(Integer ackQuorum) {
        this.ackQuorum = ackQuorum;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void setTtlUnit(String ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public void setRetentionTime(Integer retentionTime) {
        this.retentionTime = retentionTime;
    }

    public void setRetentionTimeUnit(String retentionTimeUnit) {
        this.retentionTimeUnit = retentionTimeUnit;
    }

    public void setRetentionSize(Integer retentionSize) {
        this.retentionSize = retentionSize;
    }

    public void setRetentionSizeUnit(String retentionSizeUnit) {
        this.retentionSizeUnit = retentionSizeUnit;
    }

    @Override
    public String toString() {
        return "InlongPulsarDTO(tenant=" + this.getTenant() + ", queueModule=" + this.getQueueModule() + ", partitionNum=" + this.getPartitionNum() + ", ensemble=" + this.getEnsemble() + ", writeQuorum=" + this.getWriteQuorum() + ", ackQuorum=" + this.getAckQuorum() + ", ttl=" + this.getTtl() + ", ttlUnit=" + this.getTtlUnit() + ", retentionTime=" + this.getRetentionTime() + ", retentionTimeUnit=" + this.getRetentionTimeUnit() + ", retentionSize=" + this.getRetentionSize() + ", retentionSizeUnit=" + this.getRetentionSizeUnit() + ")";
    }

    public InlongPulsarDTO() {
    }

    public InlongPulsarDTO(String tenant, String queueModule, Integer partitionNum, Integer ensemble, Integer writeQuorum, Integer ackQuorum, Integer ttl, String ttlUnit, Integer retentionTime, String retentionTimeUnit, Integer retentionSize, String retentionSizeUnit) {
        this.tenant = tenant;
        this.queueModule = queueModule;
        this.partitionNum = partitionNum;
        this.ensemble = ensemble;
        this.writeQuorum = writeQuorum;
        this.ackQuorum = ackQuorum;
        this.ttl = ttl;
        this.ttlUnit = ttlUnit;
        this.retentionTime = retentionTime;
        this.retentionTimeUnit = retentionTimeUnit;
        this.retentionSize = retentionSize;
        this.retentionSizeUnit = retentionSizeUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongPulsarDTO)) {
            return false;
        }
        InlongPulsarDTO other = (InlongPulsarDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitionNum = this.getPartitionNum();
        Integer other$partitionNum = other.getPartitionNum();
        if (this$partitionNum == null ? other$partitionNum != null : !((Object)this$partitionNum).equals(other$partitionNum)) {
            return false;
        }
        Integer this$ensemble = this.getEnsemble();
        Integer other$ensemble = other.getEnsemble();
        if (this$ensemble == null ? other$ensemble != null : !((Object)this$ensemble).equals(other$ensemble)) {
            return false;
        }
        Integer this$writeQuorum = this.getWriteQuorum();
        Integer other$writeQuorum = other.getWriteQuorum();
        if (this$writeQuorum == null ? other$writeQuorum != null : !((Object)this$writeQuorum).equals(other$writeQuorum)) {
            return false;
        }
        Integer this$ackQuorum = this.getAckQuorum();
        Integer other$ackQuorum = other.getAckQuorum();
        if (this$ackQuorum == null ? other$ackQuorum != null : !((Object)this$ackQuorum).equals(other$ackQuorum)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Integer this$retentionTime = this.getRetentionTime();
        Integer other$retentionTime = other.getRetentionTime();
        if (this$retentionTime == null ? other$retentionTime != null : !((Object)this$retentionTime).equals(other$retentionTime)) {
            return false;
        }
        Integer this$retentionSize = this.getRetentionSize();
        Integer other$retentionSize = other.getRetentionSize();
        if (this$retentionSize == null ? other$retentionSize != null : !((Object)this$retentionSize).equals(other$retentionSize)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$queueModule = this.getQueueModule();
        String other$queueModule = other.getQueueModule();
        if (this$queueModule == null ? other$queueModule != null : !this$queueModule.equals(other$queueModule)) {
            return false;
        }
        String this$ttlUnit = this.getTtlUnit();
        String other$ttlUnit = other.getTtlUnit();
        if (this$ttlUnit == null ? other$ttlUnit != null : !this$ttlUnit.equals(other$ttlUnit)) {
            return false;
        }
        String this$retentionTimeUnit = this.getRetentionTimeUnit();
        String other$retentionTimeUnit = other.getRetentionTimeUnit();
        if (this$retentionTimeUnit == null ? other$retentionTimeUnit != null : !this$retentionTimeUnit.equals(other$retentionTimeUnit)) {
            return false;
        }
        String this$retentionSizeUnit = this.getRetentionSizeUnit();
        String other$retentionSizeUnit = other.getRetentionSizeUnit();
        return !(this$retentionSizeUnit == null ? other$retentionSizeUnit != null : !this$retentionSizeUnit.equals(other$retentionSizeUnit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongPulsarDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitionNum = this.getPartitionNum();
        result = result * 59 + ($partitionNum == null ? 43 : ((Object)$partitionNum).hashCode());
        Integer $ensemble = this.getEnsemble();
        result = result * 59 + ($ensemble == null ? 43 : ((Object)$ensemble).hashCode());
        Integer $writeQuorum = this.getWriteQuorum();
        result = result * 59 + ($writeQuorum == null ? 43 : ((Object)$writeQuorum).hashCode());
        Integer $ackQuorum = this.getAckQuorum();
        result = result * 59 + ($ackQuorum == null ? 43 : ((Object)$ackQuorum).hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Integer $retentionTime = this.getRetentionTime();
        result = result * 59 + ($retentionTime == null ? 43 : ((Object)$retentionTime).hashCode());
        Integer $retentionSize = this.getRetentionSize();
        result = result * 59 + ($retentionSize == null ? 43 : ((Object)$retentionSize).hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $queueModule = this.getQueueModule();
        result = result * 59 + ($queueModule == null ? 43 : $queueModule.hashCode());
        String $ttlUnit = this.getTtlUnit();
        result = result * 59 + ($ttlUnit == null ? 43 : $ttlUnit.hashCode());
        String $retentionTimeUnit = this.getRetentionTimeUnit();
        result = result * 59 + ($retentionTimeUnit == null ? 43 : $retentionTimeUnit.hashCode());
        String $retentionSizeUnit = this.getRetentionSizeUnit();
        result = result * 59 + ($retentionSizeUnit == null ? 43 : $retentionSizeUnit.hashCode());
        return result;
    }

    public static class InlongPulsarDTOBuilder {
        private String tenant;
        private String queueModule;
        private Integer partitionNum;
        private Integer ensemble;
        private Integer writeQuorum;
        private Integer ackQuorum;
        private Integer ttl;
        private String ttlUnit;
        private Integer retentionTime;
        private String retentionTimeUnit;
        private Integer retentionSize;
        private String retentionSizeUnit;

        InlongPulsarDTOBuilder() {
        }

        public InlongPulsarDTOBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public InlongPulsarDTOBuilder queueModule(String queueModule) {
            this.queueModule = queueModule;
            return this;
        }

        public InlongPulsarDTOBuilder partitionNum(Integer partitionNum) {
            this.partitionNum = partitionNum;
            return this;
        }

        public InlongPulsarDTOBuilder ensemble(Integer ensemble) {
            this.ensemble = ensemble;
            return this;
        }

        public InlongPulsarDTOBuilder writeQuorum(Integer writeQuorum) {
            this.writeQuorum = writeQuorum;
            return this;
        }

        public InlongPulsarDTOBuilder ackQuorum(Integer ackQuorum) {
            this.ackQuorum = ackQuorum;
            return this;
        }

        public InlongPulsarDTOBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public InlongPulsarDTOBuilder ttlUnit(String ttlUnit) {
            this.ttlUnit = ttlUnit;
            return this;
        }

        public InlongPulsarDTOBuilder retentionTime(Integer retentionTime) {
            this.retentionTime = retentionTime;
            return this;
        }

        public InlongPulsarDTOBuilder retentionTimeUnit(String retentionTimeUnit) {
            this.retentionTimeUnit = retentionTimeUnit;
            return this;
        }

        public InlongPulsarDTOBuilder retentionSize(Integer retentionSize) {
            this.retentionSize = retentionSize;
            return this;
        }

        public InlongPulsarDTOBuilder retentionSizeUnit(String retentionSizeUnit) {
            this.retentionSizeUnit = retentionSizeUnit;
            return this;
        }

        public InlongPulsarDTO build() {
            return new InlongPulsarDTO(this.tenant, this.queueModule, this.partitionNum, this.ensemble, this.writeQuorum, this.ackQuorum, this.ttl, this.ttlUnit, this.retentionTime, this.retentionTimeUnit, this.retentionSize, this.retentionSizeUnit);
        }

        public String toString() {
            return "InlongPulsarDTO.InlongPulsarDTOBuilder(tenant=" + this.tenant + ", queueModule=" + this.queueModule + ", partitionNum=" + this.partitionNum + ", ensemble=" + this.ensemble + ", writeQuorum=" + this.writeQuorum + ", ackQuorum=" + this.ackQuorum + ", ttl=" + this.ttl + ", ttlUnit=" + this.ttlUnit + ", retentionTime=" + this.retentionTime + ", retentionTimeUnit=" + this.retentionTimeUnit + ", retentionSize=" + this.retentionSize + ", retentionSizeUnit=" + this.retentionSizeUnit + ")";
        }
    }
}

