/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.hive;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.hive.HiveDataNodeRequest;

@JsonTypeDefine(value="HIVE")
@ApiModel(value="Hive data node info")
public class HiveDataNodeInfo
extends DataNodeInfo {
    @ApiModelProperty(value="Version for Hive, such as: 3.2.1")
    private String hiveVersion;
    @ApiModelProperty(value="Config directory of Hive on HDFS, needed by sort in light mode, must include hive-site.xml")
    private String hiveConfDir;
    @ApiModelProperty(value="HDFS default FS, such as: hdfs://127.0.0.1:9000")
    private String dataPath;
    @ApiModelProperty(value="Hive warehouse path, such as: /user/hive/warehouse/")
    private String warehouse;
    @ApiModelProperty(value="User and group information for writing data to HDFS")
    private String hdfsUgi;

    public HiveDataNodeInfo() {
        this.setType("HIVE");
    }

    @Override
    public HiveDataNodeRequest genRequest() {
        return (HiveDataNodeRequest)CommonBeanUtils.copyProperties((Object)this, HiveDataNodeRequest::new);
    }

    protected HiveDataNodeInfo(HiveDataNodeInfoBuilder<?, ?> b) {
        super(b);
        this.hiveVersion = ((HiveDataNodeInfoBuilder)b).hiveVersion;
        this.hiveConfDir = ((HiveDataNodeInfoBuilder)b).hiveConfDir;
        this.dataPath = ((HiveDataNodeInfoBuilder)b).dataPath;
        this.warehouse = ((HiveDataNodeInfoBuilder)b).warehouse;
        this.hdfsUgi = ((HiveDataNodeInfoBuilder)b).hdfsUgi;
    }

    public static HiveDataNodeInfoBuilder<?, ?> builder() {
        return new HiveDataNodeInfoBuilderImpl();
    }

    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public String getHiveConfDir() {
        return this.hiveConfDir;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getHdfsUgi() {
        return this.hdfsUgi;
    }

    public void setHiveVersion(String hiveVersion) {
        this.hiveVersion = hiveVersion;
    }

    public void setHiveConfDir(String hiveConfDir) {
        this.hiveConfDir = hiveConfDir;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setHdfsUgi(String hdfsUgi) {
        this.hdfsUgi = hdfsUgi;
    }

    public HiveDataNodeInfo(String hiveVersion, String hiveConfDir, String dataPath, String warehouse, String hdfsUgi) {
        this.hiveVersion = hiveVersion;
        this.hiveConfDir = hiveConfDir;
        this.dataPath = dataPath;
        this.warehouse = warehouse;
        this.hdfsUgi = hdfsUgi;
    }

    @Override
    public String toString() {
        return "HiveDataNodeInfo(super=" + super.toString() + ", hiveVersion=" + this.getHiveVersion() + ", hiveConfDir=" + this.getHiveConfDir() + ", dataPath=" + this.getDataPath() + ", warehouse=" + this.getWarehouse() + ", hdfsUgi=" + this.getHdfsUgi() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveDataNodeInfo)) {
            return false;
        }
        HiveDataNodeInfo other = (HiveDataNodeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$hiveVersion = this.getHiveVersion();
        String other$hiveVersion = other.getHiveVersion();
        if (this$hiveVersion == null ? other$hiveVersion != null : !this$hiveVersion.equals(other$hiveVersion)) {
            return false;
        }
        String this$hiveConfDir = this.getHiveConfDir();
        String other$hiveConfDir = other.getHiveConfDir();
        if (this$hiveConfDir == null ? other$hiveConfDir != null : !this$hiveConfDir.equals(other$hiveConfDir)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$hdfsUgi = this.getHdfsUgi();
        String other$hdfsUgi = other.getHdfsUgi();
        return !(this$hdfsUgi == null ? other$hdfsUgi != null : !this$hdfsUgi.equals(other$hdfsUgi));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HiveDataNodeInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $hiveVersion = this.getHiveVersion();
        result = result * 59 + ($hiveVersion == null ? 43 : $hiveVersion.hashCode());
        String $hiveConfDir = this.getHiveConfDir();
        result = result * 59 + ($hiveConfDir == null ? 43 : $hiveConfDir.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $hdfsUgi = this.getHdfsUgi();
        result = result * 59 + ($hdfsUgi == null ? 43 : $hdfsUgi.hashCode());
        return result;
    }

    public static abstract class HiveDataNodeInfoBuilder<C extends HiveDataNodeInfo, B extends HiveDataNodeInfoBuilder<C, B>>
    extends DataNodeInfo.DataNodeInfoBuilder<C, B> {
        private String hiveVersion;
        private String hiveConfDir;
        private String dataPath;
        private String warehouse;
        private String hdfsUgi;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B hiveVersion(String hiveVersion) {
            this.hiveVersion = hiveVersion;
            return (B)this.self();
        }

        public B hiveConfDir(String hiveConfDir) {
            this.hiveConfDir = hiveConfDir;
            return (B)this.self();
        }

        public B dataPath(String dataPath) {
            this.dataPath = dataPath;
            return (B)this.self();
        }

        public B warehouse(String warehouse) {
            this.warehouse = warehouse;
            return (B)this.self();
        }

        public B hdfsUgi(String hdfsUgi) {
            this.hdfsUgi = hdfsUgi;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HiveDataNodeInfo.HiveDataNodeInfoBuilder(super=" + super.toString() + ", hiveVersion=" + this.hiveVersion + ", hiveConfDir=" + this.hiveConfDir + ", dataPath=" + this.dataPath + ", warehouse=" + this.warehouse + ", hdfsUgi=" + this.hdfsUgi + ")";
        }
    }

    private static final class HiveDataNodeInfoBuilderImpl
    extends HiveDataNodeInfoBuilder<HiveDataNodeInfo, HiveDataNodeInfoBuilderImpl> {
        private HiveDataNodeInfoBuilderImpl() {
        }

        @Override
        protected HiveDataNodeInfoBuilderImpl self() {
            return this;
        }

        @Override
        public HiveDataNodeInfo build() {
            return new HiveDataNodeInfo(this);
        }
    }
}

