/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.mysql;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeRequest;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLSinkDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="MySQL data node info")
public class MySQLDataNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLDataNodeDTO.class);
    private static final String MYSQL_JDBC_PREFIX = "jdbc:mysql://";
    @ApiModelProperty(value="URL of backup DB server")
    private String backupUrl;

    public static MySQLDataNodeDTO getFromRequest(MySQLDataNodeRequest request) throws Exception {
        return MySQLDataNodeDTO.builder().backupUrl(request.getBackupUrl()).build();
    }

    public static MySQLDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (MySQLDataNodeDTO)JsonUtils.parseObject((String)extParams, MySQLDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("Failed to parse extParams for MySQL node: %s", e.getMessage()));
        }
    }

    public static String convertToJdbcurl(String url) {
        String jdbcUrl = url;
        if (StringUtils.isNotBlank((CharSequence)jdbcUrl) && !jdbcUrl.startsWith(MYSQL_JDBC_PREFIX)) {
            jdbcUrl = MYSQL_JDBC_PREFIX + jdbcUrl;
        }
        return MySQLSinkDTO.filterSensitive(jdbcUrl);
    }

    public static MySQLDataNodeDTOBuilder builder() {
        return new MySQLDataNodeDTOBuilder();
    }

    public String getBackupUrl() {
        return this.backupUrl;
    }

    public void setBackupUrl(String backupUrl) {
        this.backupUrl = backupUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MySQLDataNodeDTO)) {
            return false;
        }
        MySQLDataNodeDTO other = (MySQLDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$backupUrl = this.getBackupUrl();
        String other$backupUrl = other.getBackupUrl();
        return !(this$backupUrl == null ? other$backupUrl != null : !this$backupUrl.equals(other$backupUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MySQLDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $backupUrl = this.getBackupUrl();
        result = result * 59 + ($backupUrl == null ? 43 : $backupUrl.hashCode());
        return result;
    }

    public String toString() {
        return "MySQLDataNodeDTO(backupUrl=" + this.getBackupUrl() + ")";
    }

    public MySQLDataNodeDTO() {
    }

    public MySQLDataNodeDTO(String backupUrl) {
        this.backupUrl = backupUrl;
    }

    public static class MySQLDataNodeDTOBuilder {
        private String backupUrl;

        MySQLDataNodeDTOBuilder() {
        }

        public MySQLDataNodeDTOBuilder backupUrl(String backupUrl) {
            this.backupUrl = backupUrl;
            return this;
        }

        public MySQLDataNodeDTO build() {
            return new MySQLDataNodeDTO(this.backupUrl);
        }

        public String toString() {
            return "MySQLDataNodeDTO.MySQLDataNodeDTOBuilder(backupUrl=" + this.backupUrl + ")";
        }
    }
}

