/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hudi;

import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.hudi.HudiColumnInfo;
import org.apache.inlong.manager.pojo.sink.hudi.HudiSinkRequest;
import org.apache.inlong.manager.pojo.sink.hudi.HudiTableInfo;

public class HudiSinkDTO {
    @ApiModelProperty(value="Catalog type, like: HIVE, HADOOP, default is HIVE")
    private String catalogType;
    @ApiModelProperty(value="Catalog uri, such as hive metastore thrift://ip:port")
    private String catalogUri;
    @ApiModelProperty(value="Hudi data warehouse dir")
    private String warehouse;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="File format, support: Parquet, Orc, Avro")
    private String fileFormat;
    @ApiModelProperty(value="Partition type, like: H-hour, D-day, W-week, M-month, O-once, R-regulation")
    private String partitionType;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Properties for Hudi")
    private Map<String, Object> properties;
    @ApiModelProperty(value="Extended properties")
    private List<HashMap<String, String>> extList;
    @ApiModelProperty(value="Partition field list")
    private String partitionKey;

    public static HudiSinkDTO getFromRequest(HudiSinkRequest request) {
        return HudiSinkDTO.builder().catalogUri(request.getCatalogUri()).warehouse(request.getWarehouse()).dbName(request.getDbName()).tableName(request.getTableName()).dataPath(request.getDataPath()).partitionKey(request.getPartitionKey()).fileFormat(request.getFileFormat()).catalogType(request.getCatalogType()).properties(request.getProperties()).extList(request.getExtList()).primaryKey(request.getPrimaryKey()).build();
    }

    public static HudiSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (HudiSinkDTO)JsonUtils.parseObject((String)extParams, HudiSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of Hudi SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static HudiTableInfo getHudiTableInfo(HudiSinkDTO hudiInfo, List<HudiColumnInfo> columnList) {
        HudiTableInfo tableInfo = new HudiTableInfo();
        tableInfo.setDbName(hudiInfo.getDbName());
        tableInfo.setTableName(hudiInfo.getTableName());
        tableInfo.setPartitionKey(hudiInfo.getPartitionKey());
        tableInfo.setColumns(columnList);
        tableInfo.setPrimaryKey(hudiInfo.getPrimaryKey());
        tableInfo.setFileFormat(hudiInfo.getFileFormat());
        tableInfo.setTblProperties(hudiInfo.getProperties());
        return tableInfo;
    }

    private static String $default$catalogType() {
        return "HIVE";
    }

    public static HudiSinkDTOBuilder builder() {
        return new HudiSinkDTOBuilder();
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<HashMap<String, String>> getExtList() {
        return this.extList;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setExtList(List<HashMap<String, String>> extList) {
        this.extList = extList;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiSinkDTO)) {
            return false;
        }
        HudiSinkDTO other = (HudiSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catalogType = this.getCatalogType();
        String other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !this$catalogType.equals(other$catalogType)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$partitionType = this.getPartitionType();
        String other$partitionType = other.getPartitionType();
        if (this$partitionType == null ? other$partitionType != null : !this$partitionType.equals(other$partitionType)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<HashMap<String, String>> this$extList = this.getExtList();
        List<HashMap<String, String>> other$extList = other.getExtList();
        if (this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList)) {
            return false;
        }
        String this$partitionKey = this.getPartitionKey();
        String other$partitionKey = other.getPartitionKey();
        return !(this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HudiSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : $catalogType.hashCode());
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $partitionType = this.getPartitionType();
        result = result * 59 + ($partitionType == null ? 43 : $partitionType.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<HashMap<String, String>> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        String $partitionKey = this.getPartitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
        return result;
    }

    public String toString() {
        return "HudiSinkDTO(catalogType=" + this.getCatalogType() + ", catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", fileFormat=" + this.getFileFormat() + ", partitionType=" + this.getPartitionType() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ", extList=" + this.getExtList() + ", partitionKey=" + this.getPartitionKey() + ")";
    }

    public HudiSinkDTO() {
        this.catalogType = HudiSinkDTO.$default$catalogType();
    }

    public HudiSinkDTO(String catalogType, String catalogUri, String warehouse, String dbName, String tableName, String dataPath, String fileFormat, String partitionType, String primaryKey, Map<String, Object> properties, List<HashMap<String, String>> extList, String partitionKey) {
        this.catalogType = catalogType;
        this.catalogUri = catalogUri;
        this.warehouse = warehouse;
        this.dbName = dbName;
        this.tableName = tableName;
        this.dataPath = dataPath;
        this.fileFormat = fileFormat;
        this.partitionType = partitionType;
        this.primaryKey = primaryKey;
        this.properties = properties;
        this.extList = extList;
        this.partitionKey = partitionKey;
    }

    public static class HudiSinkDTOBuilder {
        private boolean catalogType$set;
        private String catalogType$value;
        private String catalogUri;
        private String warehouse;
        private String dbName;
        private String tableName;
        private String dataPath;
        private String fileFormat;
        private String partitionType;
        private String primaryKey;
        private Map<String, Object> properties;
        private List<HashMap<String, String>> extList;
        private String partitionKey;

        HudiSinkDTOBuilder() {
        }

        public HudiSinkDTOBuilder catalogType(String catalogType) {
            this.catalogType$value = catalogType;
            this.catalogType$set = true;
            return this;
        }

        public HudiSinkDTOBuilder catalogUri(String catalogUri) {
            this.catalogUri = catalogUri;
            return this;
        }

        public HudiSinkDTOBuilder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public HudiSinkDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public HudiSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public HudiSinkDTOBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public HudiSinkDTOBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public HudiSinkDTOBuilder partitionType(String partitionType) {
            this.partitionType = partitionType;
            return this;
        }

        public HudiSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public HudiSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public HudiSinkDTOBuilder extList(List<HashMap<String, String>> extList) {
            this.extList = extList;
            return this;
        }

        public HudiSinkDTOBuilder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public HudiSinkDTO build() {
            String catalogType$value = this.catalogType$value;
            if (!this.catalogType$set) {
                catalogType$value = HudiSinkDTO.$default$catalogType();
            }
            return new HudiSinkDTO(catalogType$value, this.catalogUri, this.warehouse, this.dbName, this.tableName, this.dataPath, this.fileFormat, this.partitionType, this.primaryKey, this.properties, this.extList, this.partitionKey);
        }

        public String toString() {
            return "HudiSinkDTO.HudiSinkDTOBuilder(catalogType$value=" + this.catalogType$value + ", catalogUri=" + this.catalogUri + ", warehouse=" + this.warehouse + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", dataPath=" + this.dataPath + ", fileFormat=" + this.fileFormat + ", partitionType=" + this.partitionType + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ", extList=" + this.extList + ", partitionKey=" + this.partitionKey + ")";
        }
    }
}

