/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseSink;
import org.apache.inlong.manager.pojo.sink.doris.DorisSink;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchSink;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumSink;
import org.apache.inlong.manager.pojo.sink.hbase.HBaseSink;
import org.apache.inlong.manager.pojo.sink.hdfs.HDFSSink;
import org.apache.inlong.manager.pojo.sink.hive.HivePartitionField;
import org.apache.inlong.manager.pojo.sink.hive.HiveSink;
import org.apache.inlong.manager.pojo.sink.hudi.HudiSink;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergSink;
import org.apache.inlong.manager.pojo.sink.kafka.KafkaSink;
import org.apache.inlong.manager.pojo.sink.kudu.KuduSink;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLSink;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLSinkDTO;
import org.apache.inlong.manager.pojo.sink.oracle.OracleSink;
import org.apache.inlong.manager.pojo.sink.postgresql.PostgreSQLSink;
import org.apache.inlong.manager.pojo.sink.redis.RedisSink;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerSink;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksSink;
import org.apache.inlong.manager.pojo.sink.tdsqlpostgresql.TDSQLPostgreSQLSink;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.sort.formats.common.StringTypeInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.constant.HudiConstant;
import org.apache.inlong.sort.protocol.constant.IcebergConstant;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.AvroFormat;
import org.apache.inlong.sort.protocol.node.format.CanalJsonFormat;
import org.apache.inlong.sort.protocol.node.format.CsvFormat;
import org.apache.inlong.sort.protocol.node.format.DebeziumJsonFormat;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.format.InLongMsgFormat;
import org.apache.inlong.sort.protocol.node.format.JsonFormat;
import org.apache.inlong.sort.protocol.node.format.RawFormat;
import org.apache.inlong.sort.protocol.node.load.ClickHouseLoadNode;
import org.apache.inlong.sort.protocol.node.load.DorisLoadNode;
import org.apache.inlong.sort.protocol.node.load.ElasticsearchLoadNode;
import org.apache.inlong.sort.protocol.node.load.FileSystemLoadNode;
import org.apache.inlong.sort.protocol.node.load.GreenplumLoadNode;
import org.apache.inlong.sort.protocol.node.load.HbaseLoadNode;
import org.apache.inlong.sort.protocol.node.load.HiveLoadNode;
import org.apache.inlong.sort.protocol.node.load.HudiLoadNode;
import org.apache.inlong.sort.protocol.node.load.IcebergLoadNode;
import org.apache.inlong.sort.protocol.node.load.KafkaLoadNode;
import org.apache.inlong.sort.protocol.node.load.KuduLoadNode;
import org.apache.inlong.sort.protocol.node.load.MySqlLoadNode;
import org.apache.inlong.sort.protocol.node.load.OracleLoadNode;
import org.apache.inlong.sort.protocol.node.load.PostgresLoadNode;
import org.apache.inlong.sort.protocol.node.load.RedisLoadNode;
import org.apache.inlong.sort.protocol.node.load.SqlServerLoadNode;
import org.apache.inlong.sort.protocol.node.load.StarRocksLoadNode;
import org.apache.inlong.sort.protocol.node.load.TDSQLPostgresLoadNode;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;
import org.apache.inlong.sort.protocol.transformation.function.CustomFunction;

public class LoadNodeUtils {
    public static List<LoadNode> createLoadNodes(List<StreamSink> streamSinks, Map<String, StreamField> fieldMap) {
        if (CollectionUtils.isEmpty(streamSinks)) {
            return Lists.newArrayList();
        }
        return streamSinks.stream().map(sink -> LoadNodeUtils.createLoadNode(sink, fieldMap)).collect(Collectors.toList());
    }

    public static LoadNode createLoadNode(StreamSink streamSink, Map<String, StreamField> constantFieldMap) {
        String sinkType;
        List<FieldInfo> fieldInfos = streamSink.getSinkFieldList().stream().map(field -> FieldInfoUtils.parseSinkFieldInfo(field, streamSink.getSinkName())).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(streamSink.getSinkFieldList(), constantFieldMap);
        Map<String, String> properties = streamSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        switch (sinkType = streamSink.getSinkType()) {
            case "KAFKA": {
                return LoadNodeUtils.createLoadNode((KafkaSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "HIVE": {
                return LoadNodeUtils.createLoadNode((HiveSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "HBASE": {
                return LoadNodeUtils.createLoadNode((HBaseSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "POSTGRESQL": {
                return LoadNodeUtils.createLoadNode((PostgreSQLSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "CLICKHOUSE": {
                return LoadNodeUtils.createLoadNode((ClickHouseSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "ICEBERG": {
                return LoadNodeUtils.createLoadNode((IcebergSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "HUDI": {
                return LoadNodeUtils.createLoadNode((HudiSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "SQLSERVER": {
                return LoadNodeUtils.createLoadNode((SQLServerSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "ELASTICSEARCH": {
                return LoadNodeUtils.createLoadNode((ElasticsearchSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "HDFS": {
                return LoadNodeUtils.createLoadNode((HDFSSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "GREENPLUM": {
                return LoadNodeUtils.createLoadNode((GreenplumSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "MYSQL": {
                return LoadNodeUtils.createLoadNode((MySQLSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "ORACLE": {
                return LoadNodeUtils.createLoadNode((OracleSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "TDSQLPOSTGRESQL": {
                return LoadNodeUtils.createLoadNode((TDSQLPostgreSQLSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "DORIS": {
                return LoadNodeUtils.createLoadNode((DorisSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "STARROCKS": {
                return LoadNodeUtils.createLoadNode((StarRocksSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "KUDU": {
                return LoadNodeUtils.createLoadNode((KuduSink)streamSink, fieldInfos, fieldRelations, properties);
            }
            case "REDIS": {
                return LoadNodeUtils.createLoadNode((RedisSink)streamSink, fieldInfos, fieldRelations, properties);
            }
        }
        throw new BusinessException(String.format("Unsupported sinkType=%s to create load node", sinkType));
    }

    public static KafkaLoadNode createLoadNode(KafkaSink kafkaSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        CsvFormat format;
        Integer sinkParallelism = null;
        if (StringUtils.isNotEmpty((CharSequence)kafkaSink.getPartitionNum())) {
            sinkParallelism = Integer.parseInt(kafkaSink.getPartitionNum());
        }
        DataTypeEnum dataType = DataTypeEnum.forType((String)kafkaSink.getSerializationType());
        switch (dataType) {
            case CSV: {
                format = new CsvFormat();
                break;
            }
            case AVRO: {
                format = new AvroFormat();
                break;
            }
            case JSON: {
                format = new JsonFormat();
                break;
            }
            case CANAL: {
                format = new CanalJsonFormat();
                break;
            }
            case DEBEZIUM_JSON: {
                format = new DebeziumJsonFormat();
                break;
            }
            case RAW: {
                format = new RawFormat();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported dataType=%s for Kafka", dataType));
            }
        }
        return new KafkaLoadNode(kafkaSink.getSinkName(), kafkaSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, kafkaSink.getTopicName(), kafkaSink.getBootstrapServers(), (Format)format, sinkParallelism, properties, kafkaSink.getPrimaryKey());
    }

    public static HiveLoadNode createLoadNode(HiveSink hiveSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        List<Object> partitionFields = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(hiveSink.getPartitionFieldList())) {
            partitionFields = hiveSink.getPartitionFieldList().stream().map(partitionField -> new FieldInfo(partitionField.getFieldName(), hiveSink.getSinkName(), FieldInfoUtils.convertFieldFormat(partitionField.getFieldType(), partitionField.getFieldFormat()))).collect(Collectors.toList());
        }
        return new HiveLoadNode(hiveSink.getSinkName(), hiveSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, null, properties, null, hiveSink.getDbName(), hiveSink.getTableName(), hiveSink.getHiveConfDir(), hiveSink.getHiveVersion(), null, (List)partitionFields);
    }

    public static HbaseLoadNode createLoadNode(HBaseSink hbaseSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new HbaseLoadNode(hbaseSink.getSinkName(), hbaseSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, null, properties, hbaseSink.getTableName(), hbaseSink.getNamespace(), hbaseSink.getZkQuorum(), hbaseSink.getRowKey(), hbaseSink.getBufferFlushMaxSize(), hbaseSink.getZkNodeParent(), hbaseSink.getBufferFlushMaxRows(), hbaseSink.getBufferFlushInterval());
    }

    public static PostgresLoadNode createLoadNode(PostgreSQLSink postgreSQLSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new PostgresLoadNode(postgreSQLSink.getSinkName(), postgreSQLSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, postgreSQLSink.getJdbcUrl(), postgreSQLSink.getUsername(), postgreSQLSink.getPassword(), postgreSQLSink.getDbName() + "." + postgreSQLSink.getTableName(), postgreSQLSink.getPrimaryKey());
    }

    public static ClickHouseLoadNode createLoadNode(ClickHouseSink ckSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new ClickHouseLoadNode(ckSink.getSinkName(), ckSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, ckSink.getDbName() + "." + ckSink.getTableName(), ckSink.getJdbcUrl() + "/" + ckSink.getDbName(), ckSink.getUsername(), ckSink.getPassword(), ckSink.getPrimaryKey());
    }

    public static DorisLoadNode createLoadNode(DorisSink dorisSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        CanalJsonFormat format = null;
        if (dorisSink.getSinkMultipleEnable() != null && dorisSink.getSinkMultipleEnable().booleanValue() && StringUtils.isNotBlank((CharSequence)dorisSink.getSinkMultipleFormat())) {
            DataTypeEnum dataType = DataTypeEnum.forType((String)dorisSink.getSinkMultipleFormat());
            switch (dataType) {
                case CANAL: {
                    format = new CanalJsonFormat();
                    break;
                }
                case DEBEZIUM_JSON: {
                    format = new DebeziumJsonFormat();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported dataType=%s for doris", dataType));
                }
            }
        }
        return new DorisLoadNode(dorisSink.getSinkName(), dorisSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, dorisSink.getFeNodes(), dorisSink.getUsername(), dorisSink.getPassword(), dorisSink.getTableIdentifier(), null, dorisSink.getSinkMultipleEnable(), (Format)format, dorisSink.getDatabasePattern(), dorisSink.getTablePattern());
    }

    public static StarRocksLoadNode createLoadNode(StarRocksSink starRocksSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        CanalJsonFormat format = null;
        if (starRocksSink.getSinkMultipleEnable() != null && starRocksSink.getSinkMultipleEnable().booleanValue() && StringUtils.isNotBlank((CharSequence)starRocksSink.getSinkMultipleFormat())) {
            DataTypeEnum dataType = DataTypeEnum.forType((String)starRocksSink.getSinkMultipleFormat());
            switch (dataType) {
                case CANAL: {
                    format = new CanalJsonFormat();
                    break;
                }
                case DEBEZIUM_JSON: {
                    format = new DebeziumJsonFormat();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported dataType=%s for StarRocks", dataType));
                }
            }
        }
        return new StarRocksLoadNode(starRocksSink.getSinkName(), starRocksSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, starRocksSink.getJdbcUrl(), starRocksSink.getLoadUrl(), starRocksSink.getUsername(), starRocksSink.getPassword(), starRocksSink.getDatabaseName(), starRocksSink.getTableName(), starRocksSink.getPrimaryKey(), starRocksSink.getSinkMultipleEnable(), (Format)format, starRocksSink.getDatabasePattern(), starRocksSink.getTablePattern());
    }

    public static KuduLoadNode createLoadNode(KuduSink kuduSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new KuduLoadNode(kuduSink.getSinkName(), kuduSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, kuduSink.getMasters(), kuduSink.getTableName(), kuduSink.getPartitionKey());
    }

    private static LoadNode createLoadNode(RedisSink redisSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        String clusterMode = redisSink.getClusterMode();
        String dataType = redisSink.getDataType();
        String schemaMapMode = redisSink.getSchemaMapMode();
        String host = redisSink.getHost();
        Integer port = redisSink.getPort();
        String clusterNodes = redisSink.getClusterNodes();
        String sentinelMasterName = redisSink.getSentinelMasterName();
        String sentinelsInfo = redisSink.getSentinelsInfo();
        Integer database = redisSink.getDatabase();
        String password = redisSink.getPassword();
        Integer ttl = redisSink.getTtl();
        Integer timeout = redisSink.getTimeout();
        Integer soTimeout = redisSink.getSoTimeout();
        Integer maxTotal = redisSink.getMaxTotal();
        Integer maxIdle = redisSink.getMaxIdle();
        Integer minIdle = redisSink.getMinIdle();
        Integer maxRetries = redisSink.getMaxRetries();
        Format format = LoadNodeUtils.parsingFormat(redisSink.getFormatDataType(), false, redisSink.getFormatDataSeparator(), false);
        return new RedisLoadNode(redisSink.getSinkName(), redisSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, clusterMode, dataType, schemaMapMode, host, port, clusterNodes, sentinelMasterName, sentinelsInfo, database, password, ttl, format, timeout, soTimeout, maxTotal, maxIdle, minIdle, maxRetries);
    }

    public static IcebergLoadNode createLoadNode(IcebergSink icebergSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        IcebergConstant.CatalogType catalogType = IcebergConstant.CatalogType.forName((String)icebergSink.getCatalogType());
        return new IcebergLoadNode(icebergSink.getSinkName(), icebergSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, icebergSink.getDbName(), icebergSink.getTableName(), icebergSink.getPrimaryKey(), catalogType, icebergSink.getCatalogUri(), icebergSink.getWarehouse());
    }

    public static HudiLoadNode createLoadNode(HudiSink hudiSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        HudiConstant.CatalogType catalogType = HudiConstant.CatalogType.forName((String)hudiSink.getCatalogType());
        return new HudiLoadNode(hudiSink.getSinkName(), hudiSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, hudiSink.getDbName(), hudiSink.getTableName(), hudiSink.getPrimaryKey(), catalogType, hudiSink.getCatalogUri(), hudiSink.getWarehouse(), hudiSink.getExtList(), hudiSink.getPartitionKey());
    }

    public static SqlServerLoadNode createLoadNode(SQLServerSink sqlServerSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new SqlServerLoadNode(sqlServerSink.getSinkName(), sqlServerSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, sqlServerSink.getJdbcUrl(), sqlServerSink.getUsername(), sqlServerSink.getPassword(), sqlServerSink.getSchemaName(), sqlServerSink.getTableName(), sqlServerSink.getPrimaryKey());
    }

    public static ElasticsearchLoadNode createLoadNode(ElasticsearchSink elasticsearchSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new ElasticsearchLoadNode(elasticsearchSink.getSinkName(), elasticsearchSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, elasticsearchSink.getIndexName(), elasticsearchSink.getHosts(), elasticsearchSink.getUsername(), elasticsearchSink.getPassword(), elasticsearchSink.getDocumentType(), elasticsearchSink.getPrimaryKey(), elasticsearchSink.getEsVersion().intValue());
    }

    public static FileSystemLoadNode createLoadNode(HDFSSink hdfsSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        List<Object> partitionFields = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(hdfsSink.getPartitionFieldList())) {
            partitionFields = hdfsSink.getPartitionFieldList().stream().map(partitionField -> new FieldInfo(partitionField.getFieldName(), hdfsSink.getSinkName(), FieldInfoUtils.convertFieldFormat(partitionField.getFieldType(), partitionField.getFieldFormat()))).collect(Collectors.toList());
        }
        return new FileSystemLoadNode(hdfsSink.getSinkName(), hdfsSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), hdfsSink.getDataPath(), hdfsSink.getFileFormat(), null, properties, (List)partitionFields, hdfsSink.getServerTimeZone());
    }

    public static GreenplumLoadNode createLoadNode(GreenplumSink greenplumSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new GreenplumLoadNode(greenplumSink.getSinkName(), greenplumSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, greenplumSink.getJdbcUrl(), greenplumSink.getUsername(), greenplumSink.getPassword(), greenplumSink.getTableName(), greenplumSink.getPrimaryKey());
    }

    public static MySqlLoadNode createLoadNode(MySQLSink mysqlSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new MySqlLoadNode(mysqlSink.getSinkName(), mysqlSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, null, properties, MySQLSinkDTO.setDbNameToUrl(mysqlSink.getJdbcUrl(), mysqlSink.getDatabaseName()), mysqlSink.getUsername(), mysqlSink.getPassword(), mysqlSink.getTableName(), mysqlSink.getPrimaryKey());
    }

    public static OracleLoadNode createLoadNode(OracleSink oracleSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new OracleLoadNode(oracleSink.getSinkName(), oracleSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, oracleSink.getJdbcUrl(), oracleSink.getUsername(), oracleSink.getPassword(), oracleSink.getTableName(), oracleSink.getPrimaryKey());
    }

    public static TDSQLPostgresLoadNode createLoadNode(TDSQLPostgreSQLSink tdsqlPostgreSQLSink, List<FieldInfo> fieldInfos, List<FieldRelation> fieldRelations, Map<String, String> properties) {
        return new TDSQLPostgresLoadNode(tdsqlPostgreSQLSink.getSinkName(), tdsqlPostgreSQLSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, tdsqlPostgreSQLSink.getJdbcUrl(), tdsqlPostgreSQLSink.getUsername(), tdsqlPostgreSQLSink.getPassword(), tdsqlPostgreSQLSink.getSchemaName() + "." + tdsqlPostgreSQLSink.getTableName(), tdsqlPostgreSQLSink.getPrimaryKey());
    }

    public static List<FieldRelation> parseSinkFields(List<SinkField> fieldList, Map<String, StreamField> constantFieldMap) {
        if (CollectionUtils.isEmpty(fieldList)) {
            return Lists.newArrayList();
        }
        return fieldList.stream().filter(sinkField -> StringUtils.isNotEmpty((CharSequence)sinkField.getSourceFieldName())).map(field -> {
            FieldInfo outputField = new FieldInfo(field.getFieldName(), FieldInfoUtils.convertFieldFormat(field.getFieldType(), field.getFieldFormat()));
            String fieldKey = String.format("%s-%s", field.getOriginNodeName(), field.getSourceFieldName());
            StreamField constantField = (StreamField)constantFieldMap.get(fieldKey);
            Object inputField = constantField != null ? (outputField.getFormatInfo() != null && outputField.getFormatInfo().getTypeInfo() == StringTypeInfo.INSTANCE ? new StringConstantParam(constantField.getFieldValue()) : new ConstantParam((Object)constantField.getFieldValue())) : (FieldType.FUNCTION.name().equalsIgnoreCase(field.getSourceFieldType()) ? new CustomFunction(field.getSourceFieldName()) : new FieldInfo(field.getSourceFieldName(), field.getOriginNodeName(), FieldInfoUtils.convertFieldFormat(field.getSourceFieldType())));
            return new FieldRelation((FunctionParam)inputField, outputField);
        }).collect(Collectors.toList());
    }

    public static void checkPartitionField(List<SinkField> fieldList, List<HivePartitionField> partitionList) {
        if (CollectionUtils.isEmpty(partitionList)) {
            return;
        }
        if (CollectionUtils.isEmpty(fieldList)) {
            throw new BusinessException(ErrorCodeEnum.SINK_FIELD_LIST_IS_EMPTY);
        }
        HashMap sinkFieldMap = new HashMap(fieldList.size());
        fieldList.forEach(field -> sinkFieldMap.put(field.getFieldName(), field));
        for (HivePartitionField partitionField : partitionList) {
            String fieldName = partitionField.getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                throw new BusinessException(ErrorCodeEnum.PARTITION_FIELD_NAME_IS_EMPTY);
            }
            SinkField sinkField = (SinkField)sinkFieldMap.get(fieldName);
            if (sinkField == null) {
                throw new BusinessException(String.format(ErrorCodeEnum.PARTITION_FIELD_NOT_FOUND.getMessage(), fieldName));
            }
            if (!StringUtils.isBlank((CharSequence)sinkField.getSourceFieldName())) continue;
            throw new BusinessException(String.format(ErrorCodeEnum.PARTITION_FIELD_NO_SOURCE_FIELD.getMessage(), fieldName));
        }
    }

    private static Format parsingFormat(String formatName, boolean wrapWithInlongMsg, String separatorStr, boolean ignoreParseErrors) {
        AvroFormat format;
        DataTypeEnum dataType = DataTypeEnum.forType((String)formatName);
        switch (dataType) {
            case CSV: {
                if (StringUtils.isNumeric((CharSequence)separatorStr)) {
                    char dataSeparator = (char)Integer.parseInt(separatorStr);
                    separatorStr = Character.toString(dataSeparator);
                }
                CsvFormat csvFormat = new CsvFormat(separatorStr);
                csvFormat.setIgnoreParseErrors(Boolean.valueOf(ignoreParseErrors));
                format = csvFormat;
                break;
            }
            case AVRO: {
                format = new AvroFormat();
                break;
            }
            case JSON: {
                JsonFormat jsonFormat = new JsonFormat();
                jsonFormat.setIgnoreParseErrors(Boolean.valueOf(ignoreParseErrors));
                format = jsonFormat;
                break;
            }
            case CANAL: {
                format = new CanalJsonFormat();
                break;
            }
            case DEBEZIUM_JSON: {
                DebeziumJsonFormat debeziumJsonFormat = new DebeziumJsonFormat();
                debeziumJsonFormat.setIgnoreParseErrors(Boolean.valueOf(ignoreParseErrors));
                format = debeziumJsonFormat;
                break;
            }
            case RAW: {
                format = new RawFormat();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported dataType=%s", dataType));
            }
        }
        if (wrapWithInlongMsg) {
            AvroFormat innerFormat = format;
            format = new InLongMsgFormat((Format)innerFormat, Boolean.valueOf(false));
        }
        return format;
    }
}

