/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.tubemq;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.TreeSet;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.tubemq.TubeMQSourceRequest;

public class TubeMQSourceDTO {
    @ApiModelProperty(value="Master RPC of the TubeMQ,127.0.0.1:8715")
    private String masterRpc;
    @ApiModelProperty(value="Topic of the TubeMQ")
    private String topic;
    @ApiModelProperty(value="Format of the TubeMQ")
    private String format;
    @ApiModelProperty(value="Group of the TubeMQ")
    private String groupId;
    @ApiModelProperty(value="Session key of the TubeMQ")
    private String sessionKey;
    @ApiModelProperty(value="Tid of the TubeMQ")
    private TreeSet<String> tid;
    @ApiModelProperty(value="Properties for TubeMQ")
    private Map<String, Object> properties;

    public static TubeMQSourceDTO getFromRequest(TubeMQSourceRequest request) {
        return TubeMQSourceDTO.builder().masterRpc(request.getMasterRpc()).topic(request.getTopic()).format(request.getSerializationType()).groupId(request.getGroupId()).sessionKey(request.getSessionKey()).tid(request.getTid()).properties(request.getProperties()).build();
    }

    public static TubeMQSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (TubeMQSourceDTO)JsonUtils.parseObject((String)extParams, TubeMQSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of TubeMQSource failure: %s", e.getMessage()));
        }
    }

    public static TubeMQSourceDTOBuilder builder() {
        return new TubeMQSourceDTOBuilder();
    }

    public String getMasterRpc() {
        return this.masterRpc;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getFormat() {
        return this.format;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public TreeSet<String> getTid() {
        return this.tid;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setMasterRpc(String masterRpc) {
        this.masterRpc = masterRpc;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setTid(TreeSet<String> tid) {
        this.tid = tid;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeMQSourceDTO)) {
            return false;
        }
        TubeMQSourceDTO other = (TubeMQSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$masterRpc = this.getMasterRpc();
        String other$masterRpc = other.getMasterRpc();
        if (this$masterRpc == null ? other$masterRpc != null : !this$masterRpc.equals(other$masterRpc)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$sessionKey = this.getSessionKey();
        String other$sessionKey = other.getSessionKey();
        if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
            return false;
        }
        TreeSet<String> this$tid = this.getTid();
        TreeSet<String> other$tid = other.getTid();
        if (this$tid == null ? other$tid != null : !((Object)this$tid).equals(other$tid)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TubeMQSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $masterRpc = this.getMasterRpc();
        result = result * 59 + ($masterRpc == null ? 43 : $masterRpc.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $sessionKey = this.getSessionKey();
        result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
        TreeSet<String> $tid = this.getTid();
        result = result * 59 + ($tid == null ? 43 : ((Object)$tid).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "TubeMQSourceDTO(masterRpc=" + this.getMasterRpc() + ", topic=" + this.getTopic() + ", format=" + this.getFormat() + ", groupId=" + this.getGroupId() + ", sessionKey=" + this.getSessionKey() + ", tid=" + this.getTid() + ", properties=" + this.getProperties() + ")";
    }

    public TubeMQSourceDTO() {
    }

    public TubeMQSourceDTO(String masterRpc, String topic, String format, String groupId, String sessionKey, TreeSet<String> tid, Map<String, Object> properties) {
        this.masterRpc = masterRpc;
        this.topic = topic;
        this.format = format;
        this.groupId = groupId;
        this.sessionKey = sessionKey;
        this.tid = tid;
        this.properties = properties;
    }

    public static class TubeMQSourceDTOBuilder {
        private String masterRpc;
        private String topic;
        private String format;
        private String groupId;
        private String sessionKey;
        private TreeSet<String> tid;
        private Map<String, Object> properties;

        TubeMQSourceDTOBuilder() {
        }

        public TubeMQSourceDTOBuilder masterRpc(String masterRpc) {
            this.masterRpc = masterRpc;
            return this;
        }

        public TubeMQSourceDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public TubeMQSourceDTOBuilder format(String format) {
            this.format = format;
            return this;
        }

        public TubeMQSourceDTOBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public TubeMQSourceDTOBuilder sessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
            return this;
        }

        public TubeMQSourceDTOBuilder tid(TreeSet<String> tid) {
            this.tid = tid;
            return this;
        }

        public TubeMQSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public TubeMQSourceDTO build() {
            return new TubeMQSourceDTO(this.masterRpc, this.topic, this.format, this.groupId, this.sessionKey, this.tid, this.properties);
        }

        public String toString() {
            return "TubeMQSourceDTO.TubeMQSourceDTOBuilder(masterRpc=" + this.masterRpc + ", topic=" + this.topic + ", format=" + this.format + ", groupId=" + this.groupId + ", sessionKey=" + this.sessionKey + ", tid=" + this.tid + ", properties=" + this.properties + ")";
        }
    }
}

