/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Cluster tag request")
public class ClusterTagRequest {
    @ApiModelProperty(value="Primary key")
    @NotNull(groups={UpdateValidation.class}, message="id cannot be null")
    private @NotNull(groups={UpdateValidation.class}, message="id cannot be null") Integer id;
    @ApiModelProperty(value="Cluster tag")
    @NotBlank(groups={SaveValidation.class}, message="clusterTag cannot be blank")
    @Length(min=1, max=128, message="length must be between 1 and 128")
    @Pattern(regexp="^[a-z0-9_.-]{1,128}$", message="only supports lowercase letters, numbers, '-', or '_'")
    private @NotBlank(groups={SaveValidation.class}, message="clusterTag cannot be blank") @Length(min=1, max=128, message="length must be between 1 and 128") @Pattern(regexp="^[a-z0-9_.-]{1,128}$", message="only supports lowercase letters, numbers, '-', or '_'") String clusterTag;
    @ApiModelProperty(value="Extended params")
    @Length(min=1, max=163840, message="length must be between 1 and 163840")
    private @Length(min=1, max=163840, message="length must be between 1 and 163840") String extParams;
    @ApiModelProperty(value="Description of the cluster tag")
    @Length(max=256, message="length must be less than or equal to 256")
    private @Length(max=256, message="length must be less than or equal to 256") String description;
    @ApiModelProperty(value="Name of in charges, separated by commas")
    @Length(max=512, message="length must be less than or equal to 512")
    private @Length(max=512, message="length must be less than or equal to 512") String inCharges;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateValidation.class}, message="version cannot be null") Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setClusterTag(String clusterTag) {
        this.clusterTag = clusterTag;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterTagRequest)) {
            return false;
        }
        ClusterTagRequest other = (ClusterTagRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$clusterTag = this.getClusterTag();
        String other$clusterTag = other.getClusterTag();
        if (this$clusterTag == null ? other$clusterTag != null : !this$clusterTag.equals(other$clusterTag)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        return !(this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterTagRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $clusterTag = this.getClusterTag();
        result = result * 59 + ($clusterTag == null ? 43 : $clusterTag.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        return result;
    }

    public String toString() {
        return "ClusterTagRequest(id=" + this.getId() + ", clusterTag=" + this.getClusterTag() + ", extParams=" + this.getExtParams() + ", description=" + this.getDescription() + ", inCharges=" + this.getInCharges() + ", version=" + this.getVersion() + ")";
    }
}

