/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;

@ApiModel(value="Inlong group approval request")
public class InlongGroupApproveRequest {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @NotBlank(message="inlongGroupId cannot be blank")
    @ApiModelProperty(value="Inlong group id", required=true)
    private @NotBlank(message="inlongGroupId cannot be blank") String inlongGroupId;
    @NotBlank(message="mqType cannot be blank")
    @ApiModelProperty(value="MQ Type")
    private @NotBlank(message="mqType cannot be blank") String mqType;
    @ApiModelProperty(value="MQ resource, for TubeMQ, it is Topic, for Pulsar, it is Namespace")
    private String mqResource;
    @ApiModelProperty(value="Inlong cluster tag, inlong group will be associated with the cluster")
    private String inlongClusterTag;
    @ApiModelProperty(value="The partition num of Pulsar topic, between 1-20")
    private Integer topicPartitionNum;
    @ApiModelProperty(value="Ledger's number of writable nodes")
    private Integer ensemble;
    @ApiModelProperty(value="Ledger's number of copies")
    private Integer writeQuorum;
    @ApiModelProperty(value="Number of responses requested")
    private Integer ackQuorum;
    @ApiModelProperty(value="Message storage time")
    private Integer retentionTime;
    @ApiModelProperty(value="The unit of the message storage time")
    private String retentionTimeUnit;
    @ApiModelProperty(value="Message time-to-live duration")
    private Integer ttl;
    @ApiModelProperty(value="The unit of message's time-to-live duration")
    private String ttlUnit;
    @ApiModelProperty(value="Message size")
    private Integer retentionSize;
    @ApiModelProperty(value="The unit of message size")
    private String retentionSizeUnit;
    @ApiModelProperty(value="The limit rate of the mark-delete operation")
    private Double maxMarkDeleteRate;
    @ApiModelProperty(value="Data report type, default is 0.\n 0: report to DataProxy and respond when the DataProxy received data.\n 1: report to DataProxy and respond after DataProxy sends data.\n 2: report to MQ and respond when the MQ received data.", notes="Current constraint is that all InLong Agents under one InlongGroup use the same type")
    private Integer dataReportType = 0;

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getMqResource() {
        return this.mqResource;
    }

    public String getInlongClusterTag() {
        return this.inlongClusterTag;
    }

    public Integer getTopicPartitionNum() {
        return this.topicPartitionNum;
    }

    public Integer getEnsemble() {
        return this.ensemble;
    }

    public Integer getWriteQuorum() {
        return this.writeQuorum;
    }

    public Integer getAckQuorum() {
        return this.ackQuorum;
    }

    public Integer getRetentionTime() {
        return this.retentionTime;
    }

    public String getRetentionTimeUnit() {
        return this.retentionTimeUnit;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public String getTtlUnit() {
        return this.ttlUnit;
    }

    public Integer getRetentionSize() {
        return this.retentionSize;
    }

    public String getRetentionSizeUnit() {
        return this.retentionSizeUnit;
    }

    public Double getMaxMarkDeleteRate() {
        return this.maxMarkDeleteRate;
    }

    public Integer getDataReportType() {
        return this.dataReportType;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setMqResource(String mqResource) {
        this.mqResource = mqResource;
    }

    public void setInlongClusterTag(String inlongClusterTag) {
        this.inlongClusterTag = inlongClusterTag;
    }

    public void setTopicPartitionNum(Integer topicPartitionNum) {
        this.topicPartitionNum = topicPartitionNum;
    }

    public void setEnsemble(Integer ensemble) {
        this.ensemble = ensemble;
    }

    public void setWriteQuorum(Integer writeQuorum) {
        this.writeQuorum = writeQuorum;
    }

    public void setAckQuorum(Integer ackQuorum) {
        this.ackQuorum = ackQuorum;
    }

    public void setRetentionTime(Integer retentionTime) {
        this.retentionTime = retentionTime;
    }

    public void setRetentionTimeUnit(String retentionTimeUnit) {
        this.retentionTimeUnit = retentionTimeUnit;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void setTtlUnit(String ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public void setRetentionSize(Integer retentionSize) {
        this.retentionSize = retentionSize;
    }

    public void setRetentionSizeUnit(String retentionSizeUnit) {
        this.retentionSizeUnit = retentionSizeUnit;
    }

    public void setMaxMarkDeleteRate(Double maxMarkDeleteRate) {
        this.maxMarkDeleteRate = maxMarkDeleteRate;
    }

    public void setDataReportType(Integer dataReportType) {
        this.dataReportType = dataReportType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupApproveRequest)) {
            return false;
        }
        InlongGroupApproveRequest other = (InlongGroupApproveRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$topicPartitionNum = this.getTopicPartitionNum();
        Integer other$topicPartitionNum = other.getTopicPartitionNum();
        if (this$topicPartitionNum == null ? other$topicPartitionNum != null : !((Object)this$topicPartitionNum).equals(other$topicPartitionNum)) {
            return false;
        }
        Integer this$ensemble = this.getEnsemble();
        Integer other$ensemble = other.getEnsemble();
        if (this$ensemble == null ? other$ensemble != null : !((Object)this$ensemble).equals(other$ensemble)) {
            return false;
        }
        Integer this$writeQuorum = this.getWriteQuorum();
        Integer other$writeQuorum = other.getWriteQuorum();
        if (this$writeQuorum == null ? other$writeQuorum != null : !((Object)this$writeQuorum).equals(other$writeQuorum)) {
            return false;
        }
        Integer this$ackQuorum = this.getAckQuorum();
        Integer other$ackQuorum = other.getAckQuorum();
        if (this$ackQuorum == null ? other$ackQuorum != null : !((Object)this$ackQuorum).equals(other$ackQuorum)) {
            return false;
        }
        Integer this$retentionTime = this.getRetentionTime();
        Integer other$retentionTime = other.getRetentionTime();
        if (this$retentionTime == null ? other$retentionTime != null : !((Object)this$retentionTime).equals(other$retentionTime)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Integer this$retentionSize = this.getRetentionSize();
        Integer other$retentionSize = other.getRetentionSize();
        if (this$retentionSize == null ? other$retentionSize != null : !((Object)this$retentionSize).equals(other$retentionSize)) {
            return false;
        }
        Double this$maxMarkDeleteRate = this.getMaxMarkDeleteRate();
        Double other$maxMarkDeleteRate = other.getMaxMarkDeleteRate();
        if (this$maxMarkDeleteRate == null ? other$maxMarkDeleteRate != null : !((Object)this$maxMarkDeleteRate).equals(other$maxMarkDeleteRate)) {
            return false;
        }
        Integer this$dataReportType = this.getDataReportType();
        Integer other$dataReportType = other.getDataReportType();
        if (this$dataReportType == null ? other$dataReportType != null : !((Object)this$dataReportType).equals(other$dataReportType)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$mqResource = this.getMqResource();
        String other$mqResource = other.getMqResource();
        if (this$mqResource == null ? other$mqResource != null : !this$mqResource.equals(other$mqResource)) {
            return false;
        }
        String this$inlongClusterTag = this.getInlongClusterTag();
        String other$inlongClusterTag = other.getInlongClusterTag();
        if (this$inlongClusterTag == null ? other$inlongClusterTag != null : !this$inlongClusterTag.equals(other$inlongClusterTag)) {
            return false;
        }
        String this$retentionTimeUnit = this.getRetentionTimeUnit();
        String other$retentionTimeUnit = other.getRetentionTimeUnit();
        if (this$retentionTimeUnit == null ? other$retentionTimeUnit != null : !this$retentionTimeUnit.equals(other$retentionTimeUnit)) {
            return false;
        }
        String this$ttlUnit = this.getTtlUnit();
        String other$ttlUnit = other.getTtlUnit();
        if (this$ttlUnit == null ? other$ttlUnit != null : !this$ttlUnit.equals(other$ttlUnit)) {
            return false;
        }
        String this$retentionSizeUnit = this.getRetentionSizeUnit();
        String other$retentionSizeUnit = other.getRetentionSizeUnit();
        return !(this$retentionSizeUnit == null ? other$retentionSizeUnit != null : !this$retentionSizeUnit.equals(other$retentionSizeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupApproveRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $topicPartitionNum = this.getTopicPartitionNum();
        result = result * 59 + ($topicPartitionNum == null ? 43 : ((Object)$topicPartitionNum).hashCode());
        Integer $ensemble = this.getEnsemble();
        result = result * 59 + ($ensemble == null ? 43 : ((Object)$ensemble).hashCode());
        Integer $writeQuorum = this.getWriteQuorum();
        result = result * 59 + ($writeQuorum == null ? 43 : ((Object)$writeQuorum).hashCode());
        Integer $ackQuorum = this.getAckQuorum();
        result = result * 59 + ($ackQuorum == null ? 43 : ((Object)$ackQuorum).hashCode());
        Integer $retentionTime = this.getRetentionTime();
        result = result * 59 + ($retentionTime == null ? 43 : ((Object)$retentionTime).hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Integer $retentionSize = this.getRetentionSize();
        result = result * 59 + ($retentionSize == null ? 43 : ((Object)$retentionSize).hashCode());
        Double $maxMarkDeleteRate = this.getMaxMarkDeleteRate();
        result = result * 59 + ($maxMarkDeleteRate == null ? 43 : ((Object)$maxMarkDeleteRate).hashCode());
        Integer $dataReportType = this.getDataReportType();
        result = result * 59 + ($dataReportType == null ? 43 : ((Object)$dataReportType).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $mqResource = this.getMqResource();
        result = result * 59 + ($mqResource == null ? 43 : $mqResource.hashCode());
        String $inlongClusterTag = this.getInlongClusterTag();
        result = result * 59 + ($inlongClusterTag == null ? 43 : $inlongClusterTag.hashCode());
        String $retentionTimeUnit = this.getRetentionTimeUnit();
        result = result * 59 + ($retentionTimeUnit == null ? 43 : $retentionTimeUnit.hashCode());
        String $ttlUnit = this.getTtlUnit();
        result = result * 59 + ($ttlUnit == null ? 43 : $ttlUnit.hashCode());
        String $retentionSizeUnit = this.getRetentionSizeUnit();
        result = result * 59 + ($retentionSizeUnit == null ? 43 : $retentionSizeUnit.hashCode());
        return result;
    }

    public String toString() {
        return "InlongGroupApproveRequest(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", mqType=" + this.getMqType() + ", mqResource=" + this.getMqResource() + ", inlongClusterTag=" + this.getInlongClusterTag() + ", topicPartitionNum=" + this.getTopicPartitionNum() + ", ensemble=" + this.getEnsemble() + ", writeQuorum=" + this.getWriteQuorum() + ", ackQuorum=" + this.getAckQuorum() + ", retentionTime=" + this.getRetentionTime() + ", retentionTimeUnit=" + this.getRetentionTimeUnit() + ", ttl=" + this.getTtl() + ", ttlUnit=" + this.getTtlUnit() + ", retentionSize=" + this.getRetentionSize() + ", retentionSizeUnit=" + this.getRetentionSizeUnit() + ", maxMarkDeleteRate=" + this.getMaxMarkDeleteRate() + ", dataReportType=" + this.getDataReportType() + ")";
    }
}

