/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Inlong group reset request")
public class InlongGroupResetRequest {
    @ApiModelProperty(value="Inlong group id", required=true)
    @Length(min=4, max=100, message="length must be between 4 and 100")
    @Pattern(regexp="^[a-z0-9_-]{4,100}$", message="only supports lowercase letters, numbers, '-', or '_'")
    private @Length(min=4, max=100, message="length must be between 4 and 100") @Pattern(regexp="^[a-z0-9_-]{4,100}$", message="only supports lowercase letters, numbers, '-', or '_'") String inlongGroupId;
    @ApiModelProperty(value="If rerun process when group is in operating, 0: false 1: true")
    private Integer rerunProcess;
    @ApiModelProperty(value="This params will work when rerunProcess = 0, 0: reset to fail, 1: reset to success")
    private Integer resetFinalStatus;

    private static Integer $default$rerunProcess() {
        return 0;
    }

    private static Integer $default$resetFinalStatus() {
        return 1;
    }

    public static InlongGroupResetRequestBuilder builder() {
        return new InlongGroupResetRequestBuilder();
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public Integer getRerunProcess() {
        return this.rerunProcess;
    }

    public Integer getResetFinalStatus() {
        return this.resetFinalStatus;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setRerunProcess(Integer rerunProcess) {
        this.rerunProcess = rerunProcess;
    }

    public void setResetFinalStatus(Integer resetFinalStatus) {
        this.resetFinalStatus = resetFinalStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupResetRequest)) {
            return false;
        }
        InlongGroupResetRequest other = (InlongGroupResetRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$rerunProcess = this.getRerunProcess();
        Integer other$rerunProcess = other.getRerunProcess();
        if (this$rerunProcess == null ? other$rerunProcess != null : !((Object)this$rerunProcess).equals(other$rerunProcess)) {
            return false;
        }
        Integer this$resetFinalStatus = this.getResetFinalStatus();
        Integer other$resetFinalStatus = other.getResetFinalStatus();
        if (this$resetFinalStatus == null ? other$resetFinalStatus != null : !((Object)this$resetFinalStatus).equals(other$resetFinalStatus)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        return !(this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupResetRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $rerunProcess = this.getRerunProcess();
        result = result * 59 + ($rerunProcess == null ? 43 : ((Object)$rerunProcess).hashCode());
        Integer $resetFinalStatus = this.getResetFinalStatus();
        result = result * 59 + ($resetFinalStatus == null ? 43 : ((Object)$resetFinalStatus).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        return result;
    }

    public String toString() {
        return "InlongGroupResetRequest(inlongGroupId=" + this.getInlongGroupId() + ", rerunProcess=" + this.getRerunProcess() + ", resetFinalStatus=" + this.getResetFinalStatus() + ")";
    }

    public InlongGroupResetRequest() {
        this.rerunProcess = InlongGroupResetRequest.$default$rerunProcess();
        this.resetFinalStatus = InlongGroupResetRequest.$default$resetFinalStatus();
    }

    public InlongGroupResetRequest(String inlongGroupId, Integer rerunProcess, Integer resetFinalStatus) {
        this.inlongGroupId = inlongGroupId;
        this.rerunProcess = rerunProcess;
        this.resetFinalStatus = resetFinalStatus;
    }

    public static class InlongGroupResetRequestBuilder {
        private String inlongGroupId;
        private boolean rerunProcess$set;
        private Integer rerunProcess$value;
        private boolean resetFinalStatus$set;
        private Integer resetFinalStatus$value;

        InlongGroupResetRequestBuilder() {
        }

        public InlongGroupResetRequestBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public InlongGroupResetRequestBuilder rerunProcess(Integer rerunProcess) {
            this.rerunProcess$value = rerunProcess;
            this.rerunProcess$set = true;
            return this;
        }

        public InlongGroupResetRequestBuilder resetFinalStatus(Integer resetFinalStatus) {
            this.resetFinalStatus$value = resetFinalStatus;
            this.resetFinalStatus$set = true;
            return this;
        }

        public InlongGroupResetRequest build() {
            Integer rerunProcess$value = this.rerunProcess$value;
            if (!this.rerunProcess$set) {
                rerunProcess$value = InlongGroupResetRequest.$default$rerunProcess();
            }
            Integer resetFinalStatus$value = this.resetFinalStatus$value;
            if (!this.resetFinalStatus$set) {
                resetFinalStatus$value = InlongGroupResetRequest.$default$resetFinalStatus();
            }
            return new InlongGroupResetRequest(this.inlongGroupId, rerunProcess$value, resetFinalStatus$value);
        }

        public String toString() {
            return "InlongGroupResetRequest.InlongGroupResetRequestBuilder(inlongGroupId=" + this.inlongGroupId + ", rerunProcess$value=" + this.rerunProcess$value + ", resetFinalStatus$value=" + this.resetFinalStatus$value + ")";
        }
    }
}

