/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.es;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.es.ElasticsearchDataNodeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="Elasticsearch data node info")
public class ElasticsearchDataNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchDataNodeDTO.class);
    @ApiModelProperty(value="Bulk action, default is 4000")
    private Integer bulkAction;
    @ApiModelProperty(value="Bulk size in MB, default is 4000")
    private Integer bulkSizeMb;
    @ApiModelProperty(value="Flush interval, default is 60")
    private Integer flushInterval;
    @ApiModelProperty(value="Concurrent requests, default is 60")
    private Integer concurrentRequests;
    @ApiModelProperty(value="Max connection, default is 10")
    private Integer maxConnect;
    @ApiModelProperty(value="Max keyword length, default is 32767")
    private Integer keywordMaxLength;
    @ApiModelProperty(value="Is use index id, default is false")
    private Boolean isUseIndexId;
    @ApiModelProperty(value="Max threads, default is 2")
    private Integer maxThreads;
    @ApiModelProperty(value="audit set name")
    private String auditSetName;

    public static ElasticsearchDataNodeDTO getFromRequest(ElasticsearchDataNodeRequest request) {
        return (ElasticsearchDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, ElasticsearchDataNodeDTO::new, (boolean)true);
    }

    public static ElasticsearchDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (ElasticsearchDataNodeDTO)JsonUtils.parseObject((String)extParams, ElasticsearchDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("Failed to parse extParams for Elasticsearch node: %s", e.getMessage()));
        }
    }

    public static ElasticsearchDataNodeDTOBuilder builder() {
        return new ElasticsearchDataNodeDTOBuilder();
    }

    public Integer getBulkAction() {
        return this.bulkAction;
    }

    public Integer getBulkSizeMb() {
        return this.bulkSizeMb;
    }

    public Integer getFlushInterval() {
        return this.flushInterval;
    }

    public Integer getConcurrentRequests() {
        return this.concurrentRequests;
    }

    public Integer getMaxConnect() {
        return this.maxConnect;
    }

    public Integer getKeywordMaxLength() {
        return this.keywordMaxLength;
    }

    public Boolean getIsUseIndexId() {
        return this.isUseIndexId;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public String getAuditSetName() {
        return this.auditSetName;
    }

    public void setBulkAction(Integer bulkAction) {
        this.bulkAction = bulkAction;
    }

    public void setBulkSizeMb(Integer bulkSizeMb) {
        this.bulkSizeMb = bulkSizeMb;
    }

    public void setFlushInterval(Integer flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setConcurrentRequests(Integer concurrentRequests) {
        this.concurrentRequests = concurrentRequests;
    }

    public void setMaxConnect(Integer maxConnect) {
        this.maxConnect = maxConnect;
    }

    public void setKeywordMaxLength(Integer keywordMaxLength) {
        this.keywordMaxLength = keywordMaxLength;
    }

    public void setIsUseIndexId(Boolean isUseIndexId) {
        this.isUseIndexId = isUseIndexId;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setAuditSetName(String auditSetName) {
        this.auditSetName = auditSetName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchDataNodeDTO)) {
            return false;
        }
        ElasticsearchDataNodeDTO other = (ElasticsearchDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$bulkAction = this.getBulkAction();
        Integer other$bulkAction = other.getBulkAction();
        if (this$bulkAction == null ? other$bulkAction != null : !((Object)this$bulkAction).equals(other$bulkAction)) {
            return false;
        }
        Integer this$bulkSizeMb = this.getBulkSizeMb();
        Integer other$bulkSizeMb = other.getBulkSizeMb();
        if (this$bulkSizeMb == null ? other$bulkSizeMb != null : !((Object)this$bulkSizeMb).equals(other$bulkSizeMb)) {
            return false;
        }
        Integer this$flushInterval = this.getFlushInterval();
        Integer other$flushInterval = other.getFlushInterval();
        if (this$flushInterval == null ? other$flushInterval != null : !((Object)this$flushInterval).equals(other$flushInterval)) {
            return false;
        }
        Integer this$concurrentRequests = this.getConcurrentRequests();
        Integer other$concurrentRequests = other.getConcurrentRequests();
        if (this$concurrentRequests == null ? other$concurrentRequests != null : !((Object)this$concurrentRequests).equals(other$concurrentRequests)) {
            return false;
        }
        Integer this$maxConnect = this.getMaxConnect();
        Integer other$maxConnect = other.getMaxConnect();
        if (this$maxConnect == null ? other$maxConnect != null : !((Object)this$maxConnect).equals(other$maxConnect)) {
            return false;
        }
        Integer this$keywordMaxLength = this.getKeywordMaxLength();
        Integer other$keywordMaxLength = other.getKeywordMaxLength();
        if (this$keywordMaxLength == null ? other$keywordMaxLength != null : !((Object)this$keywordMaxLength).equals(other$keywordMaxLength)) {
            return false;
        }
        Boolean this$isUseIndexId = this.getIsUseIndexId();
        Boolean other$isUseIndexId = other.getIsUseIndexId();
        if (this$isUseIndexId == null ? other$isUseIndexId != null : !((Object)this$isUseIndexId).equals(other$isUseIndexId)) {
            return false;
        }
        Integer this$maxThreads = this.getMaxThreads();
        Integer other$maxThreads = other.getMaxThreads();
        if (this$maxThreads == null ? other$maxThreads != null : !((Object)this$maxThreads).equals(other$maxThreads)) {
            return false;
        }
        String this$auditSetName = this.getAuditSetName();
        String other$auditSetName = other.getAuditSetName();
        return !(this$auditSetName == null ? other$auditSetName != null : !this$auditSetName.equals(other$auditSetName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $bulkAction = this.getBulkAction();
        result = result * 59 + ($bulkAction == null ? 43 : ((Object)$bulkAction).hashCode());
        Integer $bulkSizeMb = this.getBulkSizeMb();
        result = result * 59 + ($bulkSizeMb == null ? 43 : ((Object)$bulkSizeMb).hashCode());
        Integer $flushInterval = this.getFlushInterval();
        result = result * 59 + ($flushInterval == null ? 43 : ((Object)$flushInterval).hashCode());
        Integer $concurrentRequests = this.getConcurrentRequests();
        result = result * 59 + ($concurrentRequests == null ? 43 : ((Object)$concurrentRequests).hashCode());
        Integer $maxConnect = this.getMaxConnect();
        result = result * 59 + ($maxConnect == null ? 43 : ((Object)$maxConnect).hashCode());
        Integer $keywordMaxLength = this.getKeywordMaxLength();
        result = result * 59 + ($keywordMaxLength == null ? 43 : ((Object)$keywordMaxLength).hashCode());
        Boolean $isUseIndexId = this.getIsUseIndexId();
        result = result * 59 + ($isUseIndexId == null ? 43 : ((Object)$isUseIndexId).hashCode());
        Integer $maxThreads = this.getMaxThreads();
        result = result * 59 + ($maxThreads == null ? 43 : ((Object)$maxThreads).hashCode());
        String $auditSetName = this.getAuditSetName();
        result = result * 59 + ($auditSetName == null ? 43 : $auditSetName.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticsearchDataNodeDTO(bulkAction=" + this.getBulkAction() + ", bulkSizeMb=" + this.getBulkSizeMb() + ", flushInterval=" + this.getFlushInterval() + ", concurrentRequests=" + this.getConcurrentRequests() + ", maxConnect=" + this.getMaxConnect() + ", keywordMaxLength=" + this.getKeywordMaxLength() + ", isUseIndexId=" + this.getIsUseIndexId() + ", maxThreads=" + this.getMaxThreads() + ", auditSetName=" + this.getAuditSetName() + ")";
    }

    public ElasticsearchDataNodeDTO() {
    }

    public ElasticsearchDataNodeDTO(Integer bulkAction, Integer bulkSizeMb, Integer flushInterval, Integer concurrentRequests, Integer maxConnect, Integer keywordMaxLength, Boolean isUseIndexId, Integer maxThreads, String auditSetName) {
        this.bulkAction = bulkAction;
        this.bulkSizeMb = bulkSizeMb;
        this.flushInterval = flushInterval;
        this.concurrentRequests = concurrentRequests;
        this.maxConnect = maxConnect;
        this.keywordMaxLength = keywordMaxLength;
        this.isUseIndexId = isUseIndexId;
        this.maxThreads = maxThreads;
        this.auditSetName = auditSetName;
    }

    public static class ElasticsearchDataNodeDTOBuilder {
        private Integer bulkAction;
        private Integer bulkSizeMb;
        private Integer flushInterval;
        private Integer concurrentRequests;
        private Integer maxConnect;
        private Integer keywordMaxLength;
        private Boolean isUseIndexId;
        private Integer maxThreads;
        private String auditSetName;

        ElasticsearchDataNodeDTOBuilder() {
        }

        public ElasticsearchDataNodeDTOBuilder bulkAction(Integer bulkAction) {
            this.bulkAction = bulkAction;
            return this;
        }

        public ElasticsearchDataNodeDTOBuilder bulkSizeMb(Integer bulkSizeMb) {
            this.bulkSizeMb = bulkSizeMb;
            return this;
        }

        public ElasticsearchDataNodeDTOBuilder flushInterval(Integer flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public ElasticsearchDataNodeDTOBuilder concurrentRequests(Integer concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            return this;
        }

        public ElasticsearchDataNodeDTOBuilder maxConnect(Integer maxConnect) {
            this.maxConnect = maxConnect;
            return this;
        }

        public ElasticsearchDataNodeDTOBuilder keywordMaxLength(Integer keywordMaxLength) {
            this.keywordMaxLength = keywordMaxLength;
            return this;
        }

        public ElasticsearchDataNodeDTOBuilder isUseIndexId(Boolean isUseIndexId) {
            this.isUseIndexId = isUseIndexId;
            return this;
        }

        public ElasticsearchDataNodeDTOBuilder maxThreads(Integer maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public ElasticsearchDataNodeDTOBuilder auditSetName(String auditSetName) {
            this.auditSetName = auditSetName;
            return this;
        }

        public ElasticsearchDataNodeDTO build() {
            return new ElasticsearchDataNodeDTO(this.bulkAction, this.bulkSizeMb, this.flushInterval, this.concurrentRequests, this.maxConnect, this.keywordMaxLength, this.isUseIndexId, this.maxThreads, this.auditSetName);
        }

        public String toString() {
            return "ElasticsearchDataNodeDTO.ElasticsearchDataNodeDTOBuilder(bulkAction=" + this.bulkAction + ", bulkSizeMb=" + this.bulkSizeMb + ", flushInterval=" + this.flushInterval + ", concurrentRequests=" + this.concurrentRequests + ", maxConnect=" + this.maxConnect + ", keywordMaxLength=" + this.keywordMaxLength + ", isUseIndexId=" + this.isUseIndexId + ", maxThreads=" + this.maxThreads + ", auditSetName=" + this.auditSetName + ")";
        }
    }
}

