/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.kudu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;

@JsonTypeDefine(value="KUDU")
@ApiModel(value="Kudu data node request")
public class KuduDataNodeRequest
extends DataNodeRequest {
    @ApiModelProperty(value="Kudu masters, a comma separated list of 'host:port' pairs")
    private String masters;
    @ApiModelProperty(value="Sets the default timeout used for user operations (using sessions and scanners). Optional. If not provided, defaults to 30s. A value of 0 disables the timeout")
    private Integer defaultAdminOperationTimeoutMs = 30000;
    @ApiModelProperty(value="Sets the default timeout used for user operations (using sessions and scanners). Optional. If not provided, defaults to 30s. A value of 0 disables the timeout")
    private Integer defaultOperationTimeoutMs = 30000;
    @ApiModelProperty(value="Default socket read timeout in ms, default is 10000")
    private Integer defaultSocketReadTimeoutMs = 10000;
    @ApiModelProperty(value="Disable this client's collection of statistics. Statistics are enabled by default")
    private Boolean statisticsDisabled = false;

    public KuduDataNodeRequest() {
        this.setType("KUDU");
    }

    public String getMasters() {
        return this.masters;
    }

    public Integer getDefaultAdminOperationTimeoutMs() {
        return this.defaultAdminOperationTimeoutMs;
    }

    public Integer getDefaultOperationTimeoutMs() {
        return this.defaultOperationTimeoutMs;
    }

    public Integer getDefaultSocketReadTimeoutMs() {
        return this.defaultSocketReadTimeoutMs;
    }

    public Boolean getStatisticsDisabled() {
        return this.statisticsDisabled;
    }

    public void setMasters(String masters) {
        this.masters = masters;
    }

    public void setDefaultAdminOperationTimeoutMs(Integer defaultAdminOperationTimeoutMs) {
        this.defaultAdminOperationTimeoutMs = defaultAdminOperationTimeoutMs;
    }

    public void setDefaultOperationTimeoutMs(Integer defaultOperationTimeoutMs) {
        this.defaultOperationTimeoutMs = defaultOperationTimeoutMs;
    }

    public void setDefaultSocketReadTimeoutMs(Integer defaultSocketReadTimeoutMs) {
        this.defaultSocketReadTimeoutMs = defaultSocketReadTimeoutMs;
    }

    public void setStatisticsDisabled(Boolean statisticsDisabled) {
        this.statisticsDisabled = statisticsDisabled;
    }

    @Override
    public String toString() {
        return "KuduDataNodeRequest(super=" + super.toString() + ", masters=" + this.getMasters() + ", defaultAdminOperationTimeoutMs=" + this.getDefaultAdminOperationTimeoutMs() + ", defaultOperationTimeoutMs=" + this.getDefaultOperationTimeoutMs() + ", defaultSocketReadTimeoutMs=" + this.getDefaultSocketReadTimeoutMs() + ", statisticsDisabled=" + this.getStatisticsDisabled() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KuduDataNodeRequest)) {
            return false;
        }
        KuduDataNodeRequest other = (KuduDataNodeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$defaultAdminOperationTimeoutMs = this.getDefaultAdminOperationTimeoutMs();
        Integer other$defaultAdminOperationTimeoutMs = other.getDefaultAdminOperationTimeoutMs();
        if (this$defaultAdminOperationTimeoutMs == null ? other$defaultAdminOperationTimeoutMs != null : !((Object)this$defaultAdminOperationTimeoutMs).equals(other$defaultAdminOperationTimeoutMs)) {
            return false;
        }
        Integer this$defaultOperationTimeoutMs = this.getDefaultOperationTimeoutMs();
        Integer other$defaultOperationTimeoutMs = other.getDefaultOperationTimeoutMs();
        if (this$defaultOperationTimeoutMs == null ? other$defaultOperationTimeoutMs != null : !((Object)this$defaultOperationTimeoutMs).equals(other$defaultOperationTimeoutMs)) {
            return false;
        }
        Integer this$defaultSocketReadTimeoutMs = this.getDefaultSocketReadTimeoutMs();
        Integer other$defaultSocketReadTimeoutMs = other.getDefaultSocketReadTimeoutMs();
        if (this$defaultSocketReadTimeoutMs == null ? other$defaultSocketReadTimeoutMs != null : !((Object)this$defaultSocketReadTimeoutMs).equals(other$defaultSocketReadTimeoutMs)) {
            return false;
        }
        Boolean this$statisticsDisabled = this.getStatisticsDisabled();
        Boolean other$statisticsDisabled = other.getStatisticsDisabled();
        if (this$statisticsDisabled == null ? other$statisticsDisabled != null : !((Object)this$statisticsDisabled).equals(other$statisticsDisabled)) {
            return false;
        }
        String this$masters = this.getMasters();
        String other$masters = other.getMasters();
        return !(this$masters == null ? other$masters != null : !this$masters.equals(other$masters));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KuduDataNodeRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $defaultAdminOperationTimeoutMs = this.getDefaultAdminOperationTimeoutMs();
        result = result * 59 + ($defaultAdminOperationTimeoutMs == null ? 43 : ((Object)$defaultAdminOperationTimeoutMs).hashCode());
        Integer $defaultOperationTimeoutMs = this.getDefaultOperationTimeoutMs();
        result = result * 59 + ($defaultOperationTimeoutMs == null ? 43 : ((Object)$defaultOperationTimeoutMs).hashCode());
        Integer $defaultSocketReadTimeoutMs = this.getDefaultSocketReadTimeoutMs();
        result = result * 59 + ($defaultSocketReadTimeoutMs == null ? 43 : ((Object)$defaultSocketReadTimeoutMs).hashCode());
        Boolean $statisticsDisabled = this.getStatisticsDisabled();
        result = result * 59 + ($statisticsDisabled == null ? 43 : ((Object)$statisticsDisabled).hashCode());
        String $masters = this.getMasters();
        result = result * 59 + ($masters == null ? 43 : $masters.hashCode());
        return result;
    }
}

