/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.redis;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.redis.RedisDataNodeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="Redis data node info")
public class RedisDataNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisDataNodeDTO.class);
    @ApiModelProperty(value="Redis cluster mode")
    private String clusterMode;
    @ApiModelProperty(value="Redis host")
    private String host;
    @ApiModelProperty(value="Redis port")
    private Integer port;
    @ApiModelProperty(value="Redis sentinel master name")
    private String masterName;
    @ApiModelProperty(value="Redis sentinel info")
    private String sentinelsInfo;
    @ApiModelProperty(value="Redis cluster nodes")
    private String clusterNodes;

    public static RedisDataNodeDTO getFromRequest(RedisDataNodeRequest request) throws Exception {
        return RedisDataNodeDTO.builder().clusterMode(request.getClusterMode()).host(request.getHost()).port(request.getPort()).masterName(request.getMasterName()).sentinelsInfo(request.getSentinelsInfo()).clusterNodes(request.getClusterNodes()).build();
    }

    public static RedisDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (RedisDataNodeDTO)JsonUtils.parseObject((String)extParams, RedisDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("Failed to parse extParams for Redis node: %s", e.getMessage()));
        }
    }

    public static RedisDataNodeDTOBuilder builder() {
        return new RedisDataNodeDTOBuilder();
    }

    public String getClusterMode() {
        return this.clusterMode;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getSentinelsInfo() {
        return this.sentinelsInfo;
    }

    public String getClusterNodes() {
        return this.clusterNodes;
    }

    public void setClusterMode(String clusterMode) {
        this.clusterMode = clusterMode;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setSentinelsInfo(String sentinelsInfo) {
        this.sentinelsInfo = sentinelsInfo;
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisDataNodeDTO)) {
            return false;
        }
        RedisDataNodeDTO other = (RedisDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$clusterMode = this.getClusterMode();
        String other$clusterMode = other.getClusterMode();
        if (this$clusterMode == null ? other$clusterMode != null : !this$clusterMode.equals(other$clusterMode)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$masterName = this.getMasterName();
        String other$masterName = other.getMasterName();
        if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
            return false;
        }
        String this$sentinelsInfo = this.getSentinelsInfo();
        String other$sentinelsInfo = other.getSentinelsInfo();
        if (this$sentinelsInfo == null ? other$sentinelsInfo != null : !this$sentinelsInfo.equals(other$sentinelsInfo)) {
            return false;
        }
        String this$clusterNodes = this.getClusterNodes();
        String other$clusterNodes = other.getClusterNodes();
        return !(this$clusterNodes == null ? other$clusterNodes != null : !this$clusterNodes.equals(other$clusterNodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $clusterMode = this.getClusterMode();
        result = result * 59 + ($clusterMode == null ? 43 : $clusterMode.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $masterName = this.getMasterName();
        result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
        String $sentinelsInfo = this.getSentinelsInfo();
        result = result * 59 + ($sentinelsInfo == null ? 43 : $sentinelsInfo.hashCode());
        String $clusterNodes = this.getClusterNodes();
        result = result * 59 + ($clusterNodes == null ? 43 : $clusterNodes.hashCode());
        return result;
    }

    public String toString() {
        return "RedisDataNodeDTO(clusterMode=" + this.getClusterMode() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", masterName=" + this.getMasterName() + ", sentinelsInfo=" + this.getSentinelsInfo() + ", clusterNodes=" + this.getClusterNodes() + ")";
    }

    public RedisDataNodeDTO() {
    }

    public RedisDataNodeDTO(String clusterMode, String host, Integer port, String masterName, String sentinelsInfo, String clusterNodes) {
        this.clusterMode = clusterMode;
        this.host = host;
        this.port = port;
        this.masterName = masterName;
        this.sentinelsInfo = sentinelsInfo;
        this.clusterNodes = clusterNodes;
    }

    public static class RedisDataNodeDTOBuilder {
        private String clusterMode;
        private String host;
        private Integer port;
        private String masterName;
        private String sentinelsInfo;
        private String clusterNodes;

        RedisDataNodeDTOBuilder() {
        }

        public RedisDataNodeDTOBuilder clusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
            return this;
        }

        public RedisDataNodeDTOBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RedisDataNodeDTOBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public RedisDataNodeDTOBuilder masterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public RedisDataNodeDTOBuilder sentinelsInfo(String sentinelsInfo) {
            this.sentinelsInfo = sentinelsInfo;
            return this;
        }

        public RedisDataNodeDTOBuilder clusterNodes(String clusterNodes) {
            this.clusterNodes = clusterNodes;
            return this;
        }

        public RedisDataNodeDTO build() {
            return new RedisDataNodeDTO(this.clusterMode, this.host, this.port, this.masterName, this.sentinelsInfo, this.clusterNodes);
        }

        public String toString() {
            return "RedisDataNodeDTO.RedisDataNodeDTOBuilder(clusterMode=" + this.clusterMode + ", host=" + this.host + ", port=" + this.port + ", masterName=" + this.masterName + ", sentinelsInfo=" + this.sentinelsInfo + ", clusterNodes=" + this.clusterNodes + ")";
        }
    }
}

