/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.postgresql;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.postgresql.PostgreSQLSinkRequest;

@ApiModel(value="PostgreSQL sink info")
@JsonTypeDefine(value="POSTGRESQL")
public class PostgreSQLSink
extends StreamSink {
    @ApiModelProperty(value="JDBC URL of the PostgreSQL server")
    private String jdbcUrl;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Primary key is required when serializationType is json, avro")
    private String primaryKey;

    public PostgreSQLSink() {
        this.setSinkType("POSTGRESQL");
    }

    @Override
    public SinkRequest genSinkRequest() {
        return (SinkRequest)CommonBeanUtils.copyProperties((Object)this, PostgreSQLSinkRequest::new);
    }

    protected PostgreSQLSink(PostgreSQLSinkBuilder<?, ?> b) {
        super((StreamSink.StreamSinkBuilder<?, ?>)b);
        this.jdbcUrl = ((PostgreSQLSinkBuilder)b).jdbcUrl;
        this.username = ((PostgreSQLSinkBuilder)b).username;
        this.password = ((PostgreSQLSinkBuilder)b).password;
        this.dbName = ((PostgreSQLSinkBuilder)b).dbName;
        this.tableName = ((PostgreSQLSinkBuilder)b).tableName;
        this.primaryKey = ((PostgreSQLSinkBuilder)b).primaryKey;
    }

    public static PostgreSQLSinkBuilder<?, ?> builder() {
        return new PostgreSQLSinkBuilderImpl();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public PostgreSQLSink(String jdbcUrl, String username, String password, String dbName, String tableName, String primaryKey) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "PostgreSQLSink(super=" + super.toString() + ", jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgreSQLSink)) {
            return false;
        }
        PostgreSQLSink other = (PostgreSQLSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PostgreSQLSink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public static abstract class PostgreSQLSinkBuilder<C extends PostgreSQLSink, B extends PostgreSQLSinkBuilder<C, B>>
    extends StreamSink.StreamSinkBuilder<C, B> {
        private String jdbcUrl;
        private String username;
        private String password;
        private String dbName;
        private String tableName;
        private String primaryKey;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B dbName(String dbName) {
            this.dbName = dbName;
            return (B)this.self();
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PostgreSQLSink.PostgreSQLSinkBuilder(super=" + super.toString() + ", jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ")";
        }
    }

    private static final class PostgreSQLSinkBuilderImpl
    extends PostgreSQLSinkBuilder<PostgreSQLSink, PostgreSQLSinkBuilderImpl> {
        private PostgreSQLSinkBuilderImpl() {
        }

        @Override
        protected PostgreSQLSinkBuilderImpl self() {
            return this;
        }

        @Override
        public PostgreSQLSink build() {
            return new PostgreSQLSink(this);
        }
    }
}

