/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.postgresql;

import io.swagger.annotations.ApiModelProperty;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.postgresql.PostgreSQLColumnInfo;
import org.apache.inlong.manager.pojo.sink.postgresql.PostgreSQLSinkRequest;
import org.apache.inlong.manager.pojo.sink.postgresql.PostgreSQLTableInfo;

public class PostgreSQLSinkDTO {
    @ApiModelProperty(value="JDBC URL of the PostgreSQL server")
    private String jdbcUrl;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Password encrypt version")
    private Integer encryptVersion;
    @ApiModelProperty(value="Properties for PostgreSQL")
    private Map<String, Object> properties;

    public static PostgreSQLSinkDTO getFromRequest(PostgreSQLSinkRequest request) throws Exception {
        Integer encryptVersion = AESUtils.getCurrentVersion(null);
        String passwd = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getPassword())) {
            passwd = AESUtils.encryptToString((byte[])request.getPassword().getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion);
        }
        return PostgreSQLSinkDTO.builder().jdbcUrl(request.getJdbcUrl()).username(request.getUsername()).password(passwd).dbName(request.getDbName()).primaryKey(request.getPrimaryKey()).tableName(request.getTableName()).encryptVersion(encryptVersion).properties(request.getProperties()).build();
    }

    public static PostgreSQLSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return ((PostgreSQLSinkDTO)JsonUtils.parseObject((String)extParams, PostgreSQLSinkDTO.class)).decryptPassword();
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of PostgreSQL SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static PostgreSQLTableInfo getTableInfo(PostgreSQLSinkDTO pgSink, List<PostgreSQLColumnInfo> columnList) {
        PostgreSQLTableInfo tableInfo = new PostgreSQLTableInfo();
        tableInfo.setDbName(pgSink.getDbName());
        tableInfo.setTableName(pgSink.getTableName());
        tableInfo.setPrimaryKey(pgSink.getPrimaryKey());
        tableInfo.setColumns(columnList);
        return tableInfo;
    }

    private PostgreSQLSinkDTO decryptPassword() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            byte[] passwordBytes = AESUtils.decryptAsString((String)this.password, (Integer)this.encryptVersion);
            this.password = new String(passwordBytes, StandardCharsets.UTF_8);
        }
        return this;
    }

    public static PostgreSQLSinkDTOBuilder builder() {
        return new PostgreSQLSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Integer getEncryptVersion() {
        return this.encryptVersion;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setEncryptVersion(Integer encryptVersion) {
        this.encryptVersion = encryptVersion;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgreSQLSinkDTO)) {
            return false;
        }
        PostgreSQLSinkDTO other = (PostgreSQLSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$encryptVersion = this.getEncryptVersion();
        Integer other$encryptVersion = other.getEncryptVersion();
        if (this$encryptVersion == null ? other$encryptVersion != null : !((Object)this$encryptVersion).equals(other$encryptVersion)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostgreSQLSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $encryptVersion = this.getEncryptVersion();
        result = result * 59 + ($encryptVersion == null ? 43 : ((Object)$encryptVersion).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "PostgreSQLSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", encryptVersion=" + this.getEncryptVersion() + ", properties=" + this.getProperties() + ")";
    }

    public PostgreSQLSinkDTO() {
    }

    public PostgreSQLSinkDTO(String jdbcUrl, String username, String password, String dbName, String tableName, String primaryKey, Integer encryptVersion, Map<String, Object> properties) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.encryptVersion = encryptVersion;
        this.properties = properties;
    }

    public static class PostgreSQLSinkDTOBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String dbName;
        private String tableName;
        private String primaryKey;
        private Integer encryptVersion;
        private Map<String, Object> properties;

        PostgreSQLSinkDTOBuilder() {
        }

        public PostgreSQLSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public PostgreSQLSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public PostgreSQLSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PostgreSQLSinkDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public PostgreSQLSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public PostgreSQLSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public PostgreSQLSinkDTOBuilder encryptVersion(Integer encryptVersion) {
            this.encryptVersion = encryptVersion;
            return this;
        }

        public PostgreSQLSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public PostgreSQLSinkDTO build() {
            return new PostgreSQLSinkDTO(this.jdbcUrl, this.username, this.password, this.dbName, this.tableName, this.primaryKey, this.encryptVersion, this.properties);
        }

        public String toString() {
            return "PostgreSQLSinkDTO.PostgreSQLSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ", encryptVersion=" + this.encryptVersion + ", properties=" + this.properties + ")";
        }
    }
}

