/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.redis;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.redis.RedisSinkRequest;

public class RedisSinkDTO {
    @ApiModelProperty(value="Redis cluster mode")
    private String clusterMode;
    @ApiModelProperty(value="Redis database id")
    private Integer database;
    @ApiModelProperty(value="Redis data type")
    private String dataType;
    @ApiModelProperty(value="Redis schema mapping mode")
    private String schemaMapMode;
    @ApiModelProperty(value="Password for Redis accessing")
    private String password;
    @ApiModelProperty(value="Database name")
    private String databaseName;
    @ApiModelProperty(value="Expire time of Redis row")
    private Integer ttl;
    @ApiModelProperty(value="The timeout of Redis client")
    private Integer timeout;
    @ApiModelProperty(value="The socket timeout of redis client")
    private Integer soTimeout;
    @ApiModelProperty(value="The max total of sink client")
    private Integer maxTotal;
    @ApiModelProperty(value="The max idle of sink client")
    private Integer maxIdle;
    @ApiModelProperty(value="The min idle of sink client")
    private Integer minIdle;
    @ApiModelProperty(value="The max retry time")
    private Integer maxRetries;
    @ApiModelProperty(value="The host of Redis server")
    private String host;
    @ApiModelProperty(value="The port of Redis server")
    private Integer port;
    @ApiModelProperty(value="The master name of Redis sentinel cluster")
    private String masterName;
    private String sentinelsInfo;
    @ApiModelProperty(value="The cluster nodes of Redis cluster")
    private String clusterNodes;
    @ApiModelProperty(value="The DataEncoding of Redis STATIC_PREFIX_MATCH data-type")
    private String formatDataEncoding;
    @ApiModelProperty(value="The DataType of Redis STATIC_PREFIX_MATCH data-type")
    private String formatDataType;
    @ApiModelProperty(value="Whether ignore parse error of Redis STATIC_PREFIX_MATCH data-type")
    private Boolean formatIgnoreParseError;
    @ApiModelProperty(value="The data separator of Redis STATIC_PREFIX_MATCH data-type")
    private String formatDataSeparator;
    @ApiModelProperty(value="Properties for Redis")
    private Map<String, Object> properties;

    public static RedisSinkDTO getFromRequest(RedisSinkRequest request) throws Exception {
        return (RedisSinkDTO)CommonBeanUtils.copyProperties((Object)request, RedisSinkDTO::new);
    }

    public static RedisSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (RedisSinkDTO)JsonUtils.parseObject((String)extParams, RedisSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of Redis SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static RedisSinkDTOBuilder builder() {
        return new RedisSinkDTOBuilder();
    }

    public String getClusterMode() {
        return this.clusterMode;
    }

    public Integer getDatabase() {
        return this.database;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getSchemaMapMode() {
        return this.schemaMapMode;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public Integer getMaxTotal() {
        return this.maxTotal;
    }

    public Integer getMaxIdle() {
        return this.maxIdle;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getSentinelsInfo() {
        return this.sentinelsInfo;
    }

    public String getClusterNodes() {
        return this.clusterNodes;
    }

    public String getFormatDataEncoding() {
        return this.formatDataEncoding;
    }

    public String getFormatDataType() {
        return this.formatDataType;
    }

    public Boolean getFormatIgnoreParseError() {
        return this.formatIgnoreParseError;
    }

    public String getFormatDataSeparator() {
        return this.formatDataSeparator;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setClusterMode(String clusterMode) {
        this.clusterMode = clusterMode;
    }

    public void setDatabase(Integer database) {
        this.database = database;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setSchemaMapMode(String schemaMapMode) {
        this.schemaMapMode = schemaMapMode;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setSentinelsInfo(String sentinelsInfo) {
        this.sentinelsInfo = sentinelsInfo;
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setFormatDataEncoding(String formatDataEncoding) {
        this.formatDataEncoding = formatDataEncoding;
    }

    public void setFormatDataType(String formatDataType) {
        this.formatDataType = formatDataType;
    }

    public void setFormatIgnoreParseError(Boolean formatIgnoreParseError) {
        this.formatIgnoreParseError = formatIgnoreParseError;
    }

    public void setFormatDataSeparator(String formatDataSeparator) {
        this.formatDataSeparator = formatDataSeparator;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisSinkDTO)) {
            return false;
        }
        RedisSinkDTO other = (RedisSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$database = this.getDatabase();
        Integer other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Integer this$soTimeout = this.getSoTimeout();
        Integer other$soTimeout = other.getSoTimeout();
        if (this$soTimeout == null ? other$soTimeout != null : !((Object)this$soTimeout).equals(other$soTimeout)) {
            return false;
        }
        Integer this$maxTotal = this.getMaxTotal();
        Integer other$maxTotal = other.getMaxTotal();
        if (this$maxTotal == null ? other$maxTotal != null : !((Object)this$maxTotal).equals(other$maxTotal)) {
            return false;
        }
        Integer this$maxIdle = this.getMaxIdle();
        Integer other$maxIdle = other.getMaxIdle();
        if (this$maxIdle == null ? other$maxIdle != null : !((Object)this$maxIdle).equals(other$maxIdle)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        Integer this$maxRetries = this.getMaxRetries();
        Integer other$maxRetries = other.getMaxRetries();
        if (this$maxRetries == null ? other$maxRetries != null : !((Object)this$maxRetries).equals(other$maxRetries)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$formatIgnoreParseError = this.getFormatIgnoreParseError();
        Boolean other$formatIgnoreParseError = other.getFormatIgnoreParseError();
        if (this$formatIgnoreParseError == null ? other$formatIgnoreParseError != null : !((Object)this$formatIgnoreParseError).equals(other$formatIgnoreParseError)) {
            return false;
        }
        String this$clusterMode = this.getClusterMode();
        String other$clusterMode = other.getClusterMode();
        if (this$clusterMode == null ? other$clusterMode != null : !this$clusterMode.equals(other$clusterMode)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$schemaMapMode = this.getSchemaMapMode();
        String other$schemaMapMode = other.getSchemaMapMode();
        if (this$schemaMapMode == null ? other$schemaMapMode != null : !this$schemaMapMode.equals(other$schemaMapMode)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$masterName = this.getMasterName();
        String other$masterName = other.getMasterName();
        if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
            return false;
        }
        String this$sentinelsInfo = this.getSentinelsInfo();
        String other$sentinelsInfo = other.getSentinelsInfo();
        if (this$sentinelsInfo == null ? other$sentinelsInfo != null : !this$sentinelsInfo.equals(other$sentinelsInfo)) {
            return false;
        }
        String this$clusterNodes = this.getClusterNodes();
        String other$clusterNodes = other.getClusterNodes();
        if (this$clusterNodes == null ? other$clusterNodes != null : !this$clusterNodes.equals(other$clusterNodes)) {
            return false;
        }
        String this$formatDataEncoding = this.getFormatDataEncoding();
        String other$formatDataEncoding = other.getFormatDataEncoding();
        if (this$formatDataEncoding == null ? other$formatDataEncoding != null : !this$formatDataEncoding.equals(other$formatDataEncoding)) {
            return false;
        }
        String this$formatDataType = this.getFormatDataType();
        String other$formatDataType = other.getFormatDataType();
        if (this$formatDataType == null ? other$formatDataType != null : !this$formatDataType.equals(other$formatDataType)) {
            return false;
        }
        String this$formatDataSeparator = this.getFormatDataSeparator();
        String other$formatDataSeparator = other.getFormatDataSeparator();
        if (this$formatDataSeparator == null ? other$formatDataSeparator != null : !this$formatDataSeparator.equals(other$formatDataSeparator)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Integer $soTimeout = this.getSoTimeout();
        result = result * 59 + ($soTimeout == null ? 43 : ((Object)$soTimeout).hashCode());
        Integer $maxTotal = this.getMaxTotal();
        result = result * 59 + ($maxTotal == null ? 43 : ((Object)$maxTotal).hashCode());
        Integer $maxIdle = this.getMaxIdle();
        result = result * 59 + ($maxIdle == null ? 43 : ((Object)$maxIdle).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        Integer $maxRetries = this.getMaxRetries();
        result = result * 59 + ($maxRetries == null ? 43 : ((Object)$maxRetries).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $formatIgnoreParseError = this.getFormatIgnoreParseError();
        result = result * 59 + ($formatIgnoreParseError == null ? 43 : ((Object)$formatIgnoreParseError).hashCode());
        String $clusterMode = this.getClusterMode();
        result = result * 59 + ($clusterMode == null ? 43 : $clusterMode.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $schemaMapMode = this.getSchemaMapMode();
        result = result * 59 + ($schemaMapMode == null ? 43 : $schemaMapMode.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $masterName = this.getMasterName();
        result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
        String $sentinelsInfo = this.getSentinelsInfo();
        result = result * 59 + ($sentinelsInfo == null ? 43 : $sentinelsInfo.hashCode());
        String $clusterNodes = this.getClusterNodes();
        result = result * 59 + ($clusterNodes == null ? 43 : $clusterNodes.hashCode());
        String $formatDataEncoding = this.getFormatDataEncoding();
        result = result * 59 + ($formatDataEncoding == null ? 43 : $formatDataEncoding.hashCode());
        String $formatDataType = this.getFormatDataType();
        result = result * 59 + ($formatDataType == null ? 43 : $formatDataType.hashCode());
        String $formatDataSeparator = this.getFormatDataSeparator();
        result = result * 59 + ($formatDataSeparator == null ? 43 : $formatDataSeparator.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "RedisSinkDTO(clusterMode=" + this.getClusterMode() + ", database=" + this.getDatabase() + ", dataType=" + this.getDataType() + ", schemaMapMode=" + this.getSchemaMapMode() + ", password=" + this.getPassword() + ", databaseName=" + this.getDatabaseName() + ", ttl=" + this.getTtl() + ", timeout=" + this.getTimeout() + ", soTimeout=" + this.getSoTimeout() + ", maxTotal=" + this.getMaxTotal() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", maxRetries=" + this.getMaxRetries() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", masterName=" + this.getMasterName() + ", sentinelsInfo=" + this.getSentinelsInfo() + ", clusterNodes=" + this.getClusterNodes() + ", formatDataEncoding=" + this.getFormatDataEncoding() + ", formatDataType=" + this.getFormatDataType() + ", formatIgnoreParseError=" + this.getFormatIgnoreParseError() + ", formatDataSeparator=" + this.getFormatDataSeparator() + ", properties=" + this.getProperties() + ")";
    }

    public RedisSinkDTO() {
    }

    public RedisSinkDTO(String clusterMode, Integer database, String dataType, String schemaMapMode, String password, String databaseName, Integer ttl, Integer timeout, Integer soTimeout, Integer maxTotal, Integer maxIdle, Integer minIdle, Integer maxRetries, String host, Integer port, String masterName, String sentinelsInfo, String clusterNodes, String formatDataEncoding, String formatDataType, Boolean formatIgnoreParseError, String formatDataSeparator, Map<String, Object> properties) {
        this.clusterMode = clusterMode;
        this.database = database;
        this.dataType = dataType;
        this.schemaMapMode = schemaMapMode;
        this.password = password;
        this.databaseName = databaseName;
        this.ttl = ttl;
        this.timeout = timeout;
        this.soTimeout = soTimeout;
        this.maxTotal = maxTotal;
        this.maxIdle = maxIdle;
        this.minIdle = minIdle;
        this.maxRetries = maxRetries;
        this.host = host;
        this.port = port;
        this.masterName = masterName;
        this.sentinelsInfo = sentinelsInfo;
        this.clusterNodes = clusterNodes;
        this.formatDataEncoding = formatDataEncoding;
        this.formatDataType = formatDataType;
        this.formatIgnoreParseError = formatIgnoreParseError;
        this.formatDataSeparator = formatDataSeparator;
        this.properties = properties;
    }

    public static class RedisSinkDTOBuilder {
        private String clusterMode;
        private Integer database;
        private String dataType;
        private String schemaMapMode;
        private String password;
        private String databaseName;
        private Integer ttl;
        private Integer timeout;
        private Integer soTimeout;
        private Integer maxTotal;
        private Integer maxIdle;
        private Integer minIdle;
        private Integer maxRetries;
        private String host;
        private Integer port;
        private String masterName;
        private String sentinelsInfo;
        private String clusterNodes;
        private String formatDataEncoding;
        private String formatDataType;
        private Boolean formatIgnoreParseError;
        private String formatDataSeparator;
        private Map<String, Object> properties;

        RedisSinkDTOBuilder() {
        }

        public RedisSinkDTOBuilder clusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
            return this;
        }

        public RedisSinkDTOBuilder database(Integer database) {
            this.database = database;
            return this;
        }

        public RedisSinkDTOBuilder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public RedisSinkDTOBuilder schemaMapMode(String schemaMapMode) {
            this.schemaMapMode = schemaMapMode;
            return this;
        }

        public RedisSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RedisSinkDTOBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public RedisSinkDTOBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public RedisSinkDTOBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public RedisSinkDTOBuilder soTimeout(Integer soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public RedisSinkDTOBuilder maxTotal(Integer maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public RedisSinkDTOBuilder maxIdle(Integer maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        public RedisSinkDTOBuilder minIdle(Integer minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public RedisSinkDTOBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public RedisSinkDTOBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RedisSinkDTOBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public RedisSinkDTOBuilder masterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public RedisSinkDTOBuilder sentinelsInfo(String sentinelsInfo) {
            this.sentinelsInfo = sentinelsInfo;
            return this;
        }

        public RedisSinkDTOBuilder clusterNodes(String clusterNodes) {
            this.clusterNodes = clusterNodes;
            return this;
        }

        public RedisSinkDTOBuilder formatDataEncoding(String formatDataEncoding) {
            this.formatDataEncoding = formatDataEncoding;
            return this;
        }

        public RedisSinkDTOBuilder formatDataType(String formatDataType) {
            this.formatDataType = formatDataType;
            return this;
        }

        public RedisSinkDTOBuilder formatIgnoreParseError(Boolean formatIgnoreParseError) {
            this.formatIgnoreParseError = formatIgnoreParseError;
            return this;
        }

        public RedisSinkDTOBuilder formatDataSeparator(String formatDataSeparator) {
            this.formatDataSeparator = formatDataSeparator;
            return this;
        }

        public RedisSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public RedisSinkDTO build() {
            return new RedisSinkDTO(this.clusterMode, this.database, this.dataType, this.schemaMapMode, this.password, this.databaseName, this.ttl, this.timeout, this.soTimeout, this.maxTotal, this.maxIdle, this.minIdle, this.maxRetries, this.host, this.port, this.masterName, this.sentinelsInfo, this.clusterNodes, this.formatDataEncoding, this.formatDataType, this.formatIgnoreParseError, this.formatDataSeparator, this.properties);
        }

        public String toString() {
            return "RedisSinkDTO.RedisSinkDTOBuilder(clusterMode=" + this.clusterMode + ", database=" + this.database + ", dataType=" + this.dataType + ", schemaMapMode=" + this.schemaMapMode + ", password=" + this.password + ", databaseName=" + this.databaseName + ", ttl=" + this.ttl + ", timeout=" + this.timeout + ", soTimeout=" + this.soTimeout + ", maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + ", maxRetries=" + this.maxRetries + ", host=" + this.host + ", port=" + this.port + ", masterName=" + this.masterName + ", sentinelsInfo=" + this.sentinelsInfo + ", clusterNodes=" + this.clusterNodes + ", formatDataEncoding=" + this.formatDataEncoding + ", formatDataType=" + this.formatDataType + ", formatIgnoreParseError=" + this.formatIgnoreParseError + ", formatDataSeparator=" + this.formatDataSeparator + ", properties=" + this.properties + ")";
        }
    }
}

