/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.postgresql;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.postgresql.PostgreSQLSourceRequest;

@ApiModel(value="PostgreSQL source info")
@JsonTypeDefine(value="POSTGRESQL")
public class PostgreSQLSource
extends StreamSource {
    @ApiModelProperty(value="Username of the PostgreSQL server")
    private String username;
    @ApiModelProperty(value="Password of the PostgreSQL server")
    private String password;
    @ApiModelProperty(value="Hostname of the PostgreSQL server")
    private String hostname;
    @ApiModelProperty(value="Port of the PostgreSQL server")
    private Integer port;
    @ApiModelProperty(value="Database name")
    private String database;
    @ApiModelProperty(value="Schema name")
    private String schema;
    @ApiModelProperty(value="Decoding plugin name")
    private String decodingPluginName;
    @ApiModelProperty(value="List of table name")
    private List<String> tableNameList;
    @ApiModelProperty(value="Server time zone")
    private String serverTimeZone;
    @ApiModelProperty(value="Scan startup mode,  either initial or never")
    private String scanStartupMode;
    @ApiModelProperty(value="Primary key must be shared by all tables")
    private String primaryKey;

    public PostgreSQLSource() {
        this.setSourceType("POSTGRESQL");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, PostgreSQLSourceRequest::new);
    }

    private static Integer $default$port() {
        return 5432;
    }

    protected PostgreSQLSource(PostgreSQLSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.username = ((PostgreSQLSourceBuilder)b).username;
        this.password = ((PostgreSQLSourceBuilder)b).password;
        this.hostname = ((PostgreSQLSourceBuilder)b).hostname;
        this.port = ((PostgreSQLSourceBuilder)b).port$set ? ((PostgreSQLSourceBuilder)b).port$value : PostgreSQLSource.$default$port();
        this.database = ((PostgreSQLSourceBuilder)b).database;
        this.schema = ((PostgreSQLSourceBuilder)b).schema;
        this.decodingPluginName = ((PostgreSQLSourceBuilder)b).decodingPluginName;
        this.tableNameList = ((PostgreSQLSourceBuilder)b).tableNameList;
        this.serverTimeZone = ((PostgreSQLSourceBuilder)b).serverTimeZone;
        this.scanStartupMode = ((PostgreSQLSourceBuilder)b).scanStartupMode;
        this.primaryKey = ((PostgreSQLSourceBuilder)b).primaryKey;
    }

    public static PostgreSQLSourceBuilder<?, ?> builder() {
        return new PostgreSQLSourceBuilderImpl();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDecodingPluginName() {
        return this.decodingPluginName;
    }

    public List<String> getTableNameList() {
        return this.tableNameList;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setDecodingPluginName(String decodingPluginName) {
        this.decodingPluginName = decodingPluginName;
    }

    public void setTableNameList(List<String> tableNameList) {
        this.tableNameList = tableNameList;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public PostgreSQLSource(String username, String password, String hostname, Integer port, String database, String schema, String decodingPluginName, List<String> tableNameList, String serverTimeZone, String scanStartupMode, String primaryKey) {
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.schema = schema;
        this.decodingPluginName = decodingPluginName;
        this.tableNameList = tableNameList;
        this.serverTimeZone = serverTimeZone;
        this.scanStartupMode = scanStartupMode;
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "PostgreSQLSource(super=" + super.toString() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", decodingPluginName=" + this.getDecodingPluginName() + ", tableNameList=" + this.getTableNameList() + ", serverTimeZone=" + this.getServerTimeZone() + ", scanStartupMode=" + this.getScanStartupMode() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgreSQLSource)) {
            return false;
        }
        PostgreSQLSource other = (PostgreSQLSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$decodingPluginName = this.getDecodingPluginName();
        String other$decodingPluginName = other.getDecodingPluginName();
        if (this$decodingPluginName == null ? other$decodingPluginName != null : !this$decodingPluginName.equals(other$decodingPluginName)) {
            return false;
        }
        List<String> this$tableNameList = this.getTableNameList();
        List<String> other$tableNameList = other.getTableNameList();
        if (this$tableNameList == null ? other$tableNameList != null : !((Object)this$tableNameList).equals(other$tableNameList)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        if (this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        if (this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PostgreSQLSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $decodingPluginName = this.getDecodingPluginName();
        result = result * 59 + ($decodingPluginName == null ? 43 : $decodingPluginName.hashCode());
        List<String> $tableNameList = this.getTableNameList();
        result = result * 59 + ($tableNameList == null ? 43 : ((Object)$tableNameList).hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public static abstract class PostgreSQLSourceBuilder<C extends PostgreSQLSource, B extends PostgreSQLSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String username;
        private String password;
        private String hostname;
        private boolean port$set;
        private Integer port$value;
        private String database;
        private String schema;
        private String decodingPluginName;
        private List<String> tableNameList;
        private String serverTimeZone;
        private String scanStartupMode;
        private String primaryKey;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B hostname(String hostname) {
            this.hostname = hostname;
            return (B)this.self();
        }

        public B port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return (B)this.self();
        }

        public B database(String database) {
            this.database = database;
            return (B)this.self();
        }

        public B schema(String schema) {
            this.schema = schema;
            return (B)this.self();
        }

        public B decodingPluginName(String decodingPluginName) {
            this.decodingPluginName = decodingPluginName;
            return (B)this.self();
        }

        public B tableNameList(List<String> tableNameList) {
            this.tableNameList = tableNameList;
            return (B)this.self();
        }

        public B serverTimeZone(String serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return (B)this.self();
        }

        public B scanStartupMode(String scanStartupMode) {
            this.scanStartupMode = scanStartupMode;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PostgreSQLSource.PostgreSQLSourceBuilder(super=" + super.toString() + ", username=" + this.username + ", password=" + this.password + ", hostname=" + this.hostname + ", port$value=" + this.port$value + ", database=" + this.database + ", schema=" + this.schema + ", decodingPluginName=" + this.decodingPluginName + ", tableNameList=" + this.tableNameList + ", serverTimeZone=" + this.serverTimeZone + ", scanStartupMode=" + this.scanStartupMode + ", primaryKey=" + this.primaryKey + ")";
        }
    }

    private static final class PostgreSQLSourceBuilderImpl
    extends PostgreSQLSourceBuilder<PostgreSQLSource, PostgreSQLSourceBuilderImpl> {
        private PostgreSQLSourceBuilderImpl() {
        }

        @Override
        protected PostgreSQLSourceBuilderImpl self() {
            return this;
        }

        @Override
        public PostgreSQLSource build() {
            return new PostgreSQLSource(this);
        }
    }
}

