/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.stream;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import org.apache.inlong.manager.common.tool.excel.annotation.ExcelEntity;
import org.apache.inlong.manager.common.tool.excel.annotation.ExcelField;
import org.apache.inlong.manager.common.tool.excel.annotation.Font;
import org.apache.inlong.manager.common.tool.excel.annotation.Style;
import org.apache.inlong.manager.common.tool.excel.validator.NonEmptyCellValidator;
import org.apache.inlong.manager.pojo.stream.StreamFieldTypeCellValidator;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.IndexedColors;

@ApiModel(value="Stream field configuration")
@ExcelEntity(name="InLong-StreamField-Template")
public class StreamField
implements Serializable {
    @ApiModelProperty(value="Field index")
    private Integer id;
    @ApiModelProperty(value="inlong group id", required=true)
    private String inlongGroupId;
    @ApiModelProperty(value="inlong stream id", required=true)
    private String inlongStreamId;
    @ExcelField(name="Field name", validator=NonEmptyCellValidator.class, font=@Font(size=16), style=@Style(bgColor=IndexedColors.LIGHT_TURQUOISE, width=9000, allBorderColor=IndexedColors.BLUE, allBorderStyle=BorderStyle.THIN), headerFont=@Font(size=20, color=IndexedColors.WHITE), headerStyle=@Style(bgColor=IndexedColors.DARK_BLUE, width=9000, allBorderColor=IndexedColors.BLUE, allBorderStyle=BorderStyle.THIN))
    @ApiModelProperty(value="Field name", required=true)
    private String fieldName;
    @ExcelField(name="Field type", validator=StreamFieldTypeCellValidator.class, font=@Font(size=16), style=@Style(bgColor=IndexedColors.LIGHT_TURQUOISE, width=6000, allBorderColor=IndexedColors.BLUE, allBorderStyle=BorderStyle.THIN), headerFont=@Font(size=20, color=IndexedColors.WHITE), headerStyle=@Style(bgColor=IndexedColors.DARK_BLUE, width=9000, allBorderColor=IndexedColors.BLUE, allBorderStyle=BorderStyle.THIN))
    @ApiModelProperty(value="Field type", required=true)
    private String fieldType;
    @ExcelField(name="Field comment", font=@Font(size=16), style=@Style(bgColor=IndexedColors.LIGHT_TURQUOISE, width=10000, allBorderColor=IndexedColors.BLUE, allBorderStyle=BorderStyle.THIN), headerFont=@Font(size=20, color=IndexedColors.WHITE), headerStyle=@Style(bgColor=IndexedColors.DARK_BLUE, width=9000, allBorderColor=IndexedColors.BLUE, allBorderStyle=BorderStyle.THIN))
    @ApiModelProperty(value="Field comment")
    private String fieldComment;
    @ApiModelProperty(value="Is predefined field, 1: yes, 0: no")
    private Integer isPredefinedField;
    @ApiModelProperty(value="Field value for constants")
    private String fieldValue;
    @ApiModelProperty(value="Value expression of predefined field")
    private String preExpression;
    @ApiModelProperty(value="Is this field a meta field, 0: no, 1: yes")
    private Integer isMetaField;
    @ApiModelProperty(value="Meta field name")
    private String metaFieldName;
    @ApiModelProperty(value="Field format, including: MICROSECONDS, MILLISECONDS, SECONDS, SQL, ISO_8601 and custom such as 'yyyy-MM-dd HH:mm:ss'. This is mainly used for time format")
    private String fieldFormat;
    @ApiModelProperty(value="Origin node name which stream fields belong")
    private String originNodeName;
    @ApiModelProperty(value="Origin field name before transform operation")
    private String originFieldName;
    @ApiModelProperty(value="Extra Param in JSON style")
    private String extParams;

    public StreamField(int index, String fieldType, String fieldName, String fieldComment, String fieldValue) {
        this.id = index;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.fieldComment = fieldComment;
        this.fieldValue = fieldValue;
    }

    public StreamField(int index, String fieldType, String fieldName, String fieldComment, String fieldValue, Integer isMetaField, String metaFieldName) {
        this(index, fieldType, fieldName, fieldComment, fieldValue);
        this.isMetaField = isMetaField;
        this.metaFieldName = metaFieldName;
    }

    public StreamField(int index, String fieldType, String fieldName, String fieldComment, String fieldValue, Integer isMetaField, String metaFieldName, String originNodeName) {
        this(index, fieldType, fieldName, fieldComment, fieldValue);
        this.isMetaField = isMetaField;
        this.metaFieldName = metaFieldName;
        this.originNodeName = originNodeName;
    }

    public StreamField(int index, String fieldType, String fieldName, String fieldComment, String fieldValue, Integer isMetaField, String metaFieldName, String originNodeName, String originFieldName) {
        this(index, fieldType, fieldName, fieldComment, fieldValue);
        this.isMetaField = isMetaField;
        this.metaFieldName = metaFieldName;
        this.originNodeName = originNodeName;
        this.originFieldName = originFieldName;
    }

    private static Integer $default$isMetaField() {
        return 0;
    }

    public static StreamFieldBuilder builder() {
        return new StreamFieldBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getFieldComment() {
        return this.fieldComment;
    }

    public Integer getIsPredefinedField() {
        return this.isPredefinedField;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public String getPreExpression() {
        return this.preExpression;
    }

    public Integer getIsMetaField() {
        return this.isMetaField;
    }

    public String getMetaFieldName() {
        return this.metaFieldName;
    }

    public String getFieldFormat() {
        return this.fieldFormat;
    }

    public String getOriginNodeName() {
        return this.originNodeName;
    }

    public String getOriginFieldName() {
        return this.originFieldName;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void setFieldComment(String fieldComment) {
        this.fieldComment = fieldComment;
    }

    public void setIsPredefinedField(Integer isPredefinedField) {
        this.isPredefinedField = isPredefinedField;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public void setPreExpression(String preExpression) {
        this.preExpression = preExpression;
    }

    public void setIsMetaField(Integer isMetaField) {
        this.isMetaField = isMetaField;
    }

    public void setMetaFieldName(String metaFieldName) {
        this.metaFieldName = metaFieldName;
    }

    public void setFieldFormat(String fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public void setOriginNodeName(String originNodeName) {
        this.originNodeName = originNodeName;
    }

    public void setOriginFieldName(String originFieldName) {
        this.originFieldName = originFieldName;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamField)) {
            return false;
        }
        StreamField other = (StreamField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$isPredefinedField = this.getIsPredefinedField();
        Integer other$isPredefinedField = other.getIsPredefinedField();
        if (this$isPredefinedField == null ? other$isPredefinedField != null : !((Object)this$isPredefinedField).equals(other$isPredefinedField)) {
            return false;
        }
        Integer this$isMetaField = this.getIsMetaField();
        Integer other$isMetaField = other.getIsMetaField();
        if (this$isMetaField == null ? other$isMetaField != null : !((Object)this$isMetaField).equals(other$isMetaField)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$fieldType = this.getFieldType();
        String other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        String this$fieldComment = this.getFieldComment();
        String other$fieldComment = other.getFieldComment();
        if (this$fieldComment == null ? other$fieldComment != null : !this$fieldComment.equals(other$fieldComment)) {
            return false;
        }
        String this$fieldValue = this.getFieldValue();
        String other$fieldValue = other.getFieldValue();
        if (this$fieldValue == null ? other$fieldValue != null : !this$fieldValue.equals(other$fieldValue)) {
            return false;
        }
        String this$preExpression = this.getPreExpression();
        String other$preExpression = other.getPreExpression();
        if (this$preExpression == null ? other$preExpression != null : !this$preExpression.equals(other$preExpression)) {
            return false;
        }
        String this$metaFieldName = this.getMetaFieldName();
        String other$metaFieldName = other.getMetaFieldName();
        if (this$metaFieldName == null ? other$metaFieldName != null : !this$metaFieldName.equals(other$metaFieldName)) {
            return false;
        }
        String this$fieldFormat = this.getFieldFormat();
        String other$fieldFormat = other.getFieldFormat();
        if (this$fieldFormat == null ? other$fieldFormat != null : !this$fieldFormat.equals(other$fieldFormat)) {
            return false;
        }
        String this$originNodeName = this.getOriginNodeName();
        String other$originNodeName = other.getOriginNodeName();
        if (this$originNodeName == null ? other$originNodeName != null : !this$originNodeName.equals(other$originNodeName)) {
            return false;
        }
        String this$originFieldName = this.getOriginFieldName();
        String other$originFieldName = other.getOriginFieldName();
        if (this$originFieldName == null ? other$originFieldName != null : !this$originFieldName.equals(other$originFieldName)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        return !(this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $isPredefinedField = this.getIsPredefinedField();
        result = result * 59 + ($isPredefinedField == null ? 43 : ((Object)$isPredefinedField).hashCode());
        Integer $isMetaField = this.getIsMetaField();
        result = result * 59 + ($isMetaField == null ? 43 : ((Object)$isMetaField).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        String $fieldComment = this.getFieldComment();
        result = result * 59 + ($fieldComment == null ? 43 : $fieldComment.hashCode());
        String $fieldValue = this.getFieldValue();
        result = result * 59 + ($fieldValue == null ? 43 : $fieldValue.hashCode());
        String $preExpression = this.getPreExpression();
        result = result * 59 + ($preExpression == null ? 43 : $preExpression.hashCode());
        String $metaFieldName = this.getMetaFieldName();
        result = result * 59 + ($metaFieldName == null ? 43 : $metaFieldName.hashCode());
        String $fieldFormat = this.getFieldFormat();
        result = result * 59 + ($fieldFormat == null ? 43 : $fieldFormat.hashCode());
        String $originNodeName = this.getOriginNodeName();
        result = result * 59 + ($originNodeName == null ? 43 : $originNodeName.hashCode());
        String $originFieldName = this.getOriginFieldName();
        result = result * 59 + ($originFieldName == null ? 43 : $originFieldName.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        return result;
    }

    public String toString() {
        return "StreamField(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", fieldName=" + this.getFieldName() + ", fieldType=" + this.getFieldType() + ", fieldComment=" + this.getFieldComment() + ", isPredefinedField=" + this.getIsPredefinedField() + ", fieldValue=" + this.getFieldValue() + ", preExpression=" + this.getPreExpression() + ", isMetaField=" + this.getIsMetaField() + ", metaFieldName=" + this.getMetaFieldName() + ", fieldFormat=" + this.getFieldFormat() + ", originNodeName=" + this.getOriginNodeName() + ", originFieldName=" + this.getOriginFieldName() + ", extParams=" + this.getExtParams() + ")";
    }

    public StreamField() {
        this.isMetaField = StreamField.$default$isMetaField();
    }

    public StreamField(Integer id, String inlongGroupId, String inlongStreamId, String fieldName, String fieldType, String fieldComment, Integer isPredefinedField, String fieldValue, String preExpression, Integer isMetaField, String metaFieldName, String fieldFormat, String originNodeName, String originFieldName, String extParams) {
        this.id = id;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldComment = fieldComment;
        this.isPredefinedField = isPredefinedField;
        this.fieldValue = fieldValue;
        this.preExpression = preExpression;
        this.isMetaField = isMetaField;
        this.metaFieldName = metaFieldName;
        this.fieldFormat = fieldFormat;
        this.originNodeName = originNodeName;
        this.originFieldName = originFieldName;
        this.extParams = extParams;
    }

    public static class StreamFieldBuilder {
        private Integer id;
        private String inlongGroupId;
        private String inlongStreamId;
        private String fieldName;
        private String fieldType;
        private String fieldComment;
        private Integer isPredefinedField;
        private String fieldValue;
        private String preExpression;
        private boolean isMetaField$set;
        private Integer isMetaField$value;
        private String metaFieldName;
        private String fieldFormat;
        private String originNodeName;
        private String originFieldName;
        private String extParams;

        StreamFieldBuilder() {
        }

        public StreamFieldBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public StreamFieldBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public StreamFieldBuilder inlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
            return this;
        }

        public StreamFieldBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public StreamFieldBuilder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public StreamFieldBuilder fieldComment(String fieldComment) {
            this.fieldComment = fieldComment;
            return this;
        }

        public StreamFieldBuilder isPredefinedField(Integer isPredefinedField) {
            this.isPredefinedField = isPredefinedField;
            return this;
        }

        public StreamFieldBuilder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        public StreamFieldBuilder preExpression(String preExpression) {
            this.preExpression = preExpression;
            return this;
        }

        public StreamFieldBuilder isMetaField(Integer isMetaField) {
            this.isMetaField$value = isMetaField;
            this.isMetaField$set = true;
            return this;
        }

        public StreamFieldBuilder metaFieldName(String metaFieldName) {
            this.metaFieldName = metaFieldName;
            return this;
        }

        public StreamFieldBuilder fieldFormat(String fieldFormat) {
            this.fieldFormat = fieldFormat;
            return this;
        }

        public StreamFieldBuilder originNodeName(String originNodeName) {
            this.originNodeName = originNodeName;
            return this;
        }

        public StreamFieldBuilder originFieldName(String originFieldName) {
            this.originFieldName = originFieldName;
            return this;
        }

        public StreamFieldBuilder extParams(String extParams) {
            this.extParams = extParams;
            return this;
        }

        public StreamField build() {
            Integer isMetaField$value = this.isMetaField$value;
            if (!this.isMetaField$set) {
                isMetaField$value = StreamField.$default$isMetaField();
            }
            return new StreamField(this.id, this.inlongGroupId, this.inlongStreamId, this.fieldName, this.fieldType, this.fieldComment, this.isPredefinedField, this.fieldValue, this.preExpression, isMetaField$value, this.metaFieldName, this.fieldFormat, this.originNodeName, this.originFieldName, this.extParams);
        }

        public String toString() {
            return "StreamField.StreamFieldBuilder(id=" + this.id + ", inlongGroupId=" + this.inlongGroupId + ", inlongStreamId=" + this.inlongStreamId + ", fieldName=" + this.fieldName + ", fieldType=" + this.fieldType + ", fieldComment=" + this.fieldComment + ", isPredefinedField=" + this.isPredefinedField + ", fieldValue=" + this.fieldValue + ", preExpression=" + this.preExpression + ", isMetaField$value=" + this.isMetaField$value + ", metaFieldName=" + this.metaFieldName + ", fieldFormat=" + this.fieldFormat + ", originNodeName=" + this.originNodeName + ", originFieldName=" + this.originFieldName + ", extParams=" + this.extParams + ")";
        }
    }
}

