/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.transform.deduplication;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;

@JsonTypeDefine(value="DE_DUPLICATION")
public class DeDuplicationDefinition
extends TransformDefinition {
    private List<StreamField> dupFields;
    private StreamField timingField;
    private long interval;
    private TimeUnit timeUnit;
    private DeDuplicationStrategy deDuplicationStrategy;

    public DeDuplicationDefinition(List<StreamField> dupFields, StreamField timingField, long interval, TimeUnit timeUnit, DeDuplicationStrategy deDuplicationStrategy) {
        this.transformType = TransformType.DE_DUPLICATION;
        this.dupFields = dupFields;
        this.timingField = timingField;
        this.interval = interval;
        this.timeUnit = timeUnit;
        this.deDuplicationStrategy = deDuplicationStrategy;
    }

    public static DeDuplicationDefinitionBuilder builder() {
        return new DeDuplicationDefinitionBuilder();
    }

    public List<StreamField> getDupFields() {
        return this.dupFields;
    }

    public StreamField getTimingField() {
        return this.timingField;
    }

    public long getInterval() {
        return this.interval;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public DeDuplicationStrategy getDeDuplicationStrategy() {
        return this.deDuplicationStrategy;
    }

    public void setDupFields(List<StreamField> dupFields) {
        this.dupFields = dupFields;
    }

    public void setTimingField(StreamField timingField) {
        this.timingField = timingField;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setDeDuplicationStrategy(DeDuplicationStrategy deDuplicationStrategy) {
        this.deDuplicationStrategy = deDuplicationStrategy;
    }

    @Override
    public String toString() {
        return "DeDuplicationDefinition(dupFields=" + this.getDupFields() + ", timingField=" + this.getTimingField() + ", interval=" + this.getInterval() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", deDuplicationStrategy=" + (Object)((Object)this.getDeDuplicationStrategy()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeDuplicationDefinition)) {
            return false;
        }
        DeDuplicationDefinition other = (DeDuplicationDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getInterval() != other.getInterval()) {
            return false;
        }
        List<StreamField> this$dupFields = this.getDupFields();
        List<StreamField> other$dupFields = other.getDupFields();
        if (this$dupFields == null ? other$dupFields != null : !((Object)this$dupFields).equals(other$dupFields)) {
            return false;
        }
        StreamField this$timingField = this.getTimingField();
        StreamField other$timingField = other.getTimingField();
        if (this$timingField == null ? other$timingField != null : !((Object)this$timingField).equals(other$timingField)) {
            return false;
        }
        TimeUnit this$timeUnit = this.getTimeUnit();
        TimeUnit other$timeUnit = other.getTimeUnit();
        if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
            return false;
        }
        DeDuplicationStrategy this$deDuplicationStrategy = this.getDeDuplicationStrategy();
        DeDuplicationStrategy other$deDuplicationStrategy = other.getDeDuplicationStrategy();
        return !(this$deDuplicationStrategy == null ? other$deDuplicationStrategy != null : !((Object)((Object)this$deDuplicationStrategy)).equals((Object)other$deDuplicationStrategy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeDuplicationDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $interval = this.getInterval();
        result = result * 59 + (int)($interval >>> 32 ^ $interval);
        List<StreamField> $dupFields = this.getDupFields();
        result = result * 59 + ($dupFields == null ? 43 : ((Object)$dupFields).hashCode());
        StreamField $timingField = this.getTimingField();
        result = result * 59 + ($timingField == null ? 43 : ((Object)$timingField).hashCode());
        TimeUnit $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
        DeDuplicationStrategy $deDuplicationStrategy = this.getDeDuplicationStrategy();
        result = result * 59 + ($deDuplicationStrategy == null ? 43 : ((Object)((Object)$deDuplicationStrategy)).hashCode());
        return result;
    }

    public DeDuplicationDefinition() {
    }

    @JsonFormat
    public static enum DeDuplicationStrategy {
        REMOVE_ALL,
        RESERVE_FIRST,
        RESERVE_LAST;

    }

    public static class DeDuplicationDefinitionBuilder {
        private List<StreamField> dupFields;
        private StreamField timingField;
        private long interval;
        private TimeUnit timeUnit;
        private DeDuplicationStrategy deDuplicationStrategy;

        DeDuplicationDefinitionBuilder() {
        }

        public DeDuplicationDefinitionBuilder dupFields(List<StreamField> dupFields) {
            this.dupFields = dupFields;
            return this;
        }

        public DeDuplicationDefinitionBuilder timingField(StreamField timingField) {
            this.timingField = timingField;
            return this;
        }

        public DeDuplicationDefinitionBuilder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public DeDuplicationDefinitionBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public DeDuplicationDefinitionBuilder deDuplicationStrategy(DeDuplicationStrategy deDuplicationStrategy) {
            this.deDuplicationStrategy = deDuplicationStrategy;
            return this;
        }

        public DeDuplicationDefinition build() {
            return new DeDuplicationDefinition(this.dupFields, this.timingField, this.interval, this.timeUnit, this.deDuplicationStrategy);
        }

        public String toString() {
            return "DeDuplicationDefinition.DeDuplicationDefinitionBuilder(dupFields=" + this.dupFields + ", timingField=" + this.timingField + ", interval=" + this.interval + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", deDuplicationStrategy=" + (Object)((Object)this.deDuplicationStrategy) + ")";
        }
    }
}

