/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.transform.filter;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;

@JsonTypeDefine(value="FILTER")
public class FilterDefinition
extends TransformDefinition {
    private FilterStrategy filterStrategy;
    private FilterMode filterMode;
    private List<FilterRule> filterRules;
    private ScriptBase scriptBase;

    public FilterDefinition(FilterStrategy filterStrategy, List<FilterRule> filterRules) {
        this.transformType = TransformType.FILTER;
        this.filterStrategy = filterStrategy;
        this.filterMode = FilterMode.RULE;
        this.filterRules = filterRules;
    }

    public FilterDefinition(FilterStrategy filterStrategy, ScriptBase scriptBase) {
        this.transformType = TransformType.FILTER;
        this.filterStrategy = filterStrategy;
        this.filterMode = FilterMode.SCRIPT;
        this.scriptBase = scriptBase;
    }

    public FilterStrategy getFilterStrategy() {
        return this.filterStrategy;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public List<FilterRule> getFilterRules() {
        return this.filterRules;
    }

    public ScriptBase getScriptBase() {
        return this.scriptBase;
    }

    public void setFilterStrategy(FilterStrategy filterStrategy) {
        this.filterStrategy = filterStrategy;
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    public void setFilterRules(List<FilterRule> filterRules) {
        this.filterRules = filterRules;
    }

    public void setScriptBase(ScriptBase scriptBase) {
        this.scriptBase = scriptBase;
    }

    @Override
    public String toString() {
        return "FilterDefinition(filterStrategy=" + (Object)((Object)this.getFilterStrategy()) + ", filterMode=" + (Object)((Object)this.getFilterMode()) + ", filterRules=" + this.getFilterRules() + ", scriptBase=" + this.getScriptBase() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterDefinition)) {
            return false;
        }
        FilterDefinition other = (FilterDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterStrategy this$filterStrategy = this.getFilterStrategy();
        FilterStrategy other$filterStrategy = other.getFilterStrategy();
        if (this$filterStrategy == null ? other$filterStrategy != null : !((Object)((Object)this$filterStrategy)).equals((Object)other$filterStrategy)) {
            return false;
        }
        FilterMode this$filterMode = this.getFilterMode();
        FilterMode other$filterMode = other.getFilterMode();
        if (this$filterMode == null ? other$filterMode != null : !((Object)((Object)this$filterMode)).equals((Object)other$filterMode)) {
            return false;
        }
        List<FilterRule> this$filterRules = this.getFilterRules();
        List<FilterRule> other$filterRules = other.getFilterRules();
        if (this$filterRules == null ? other$filterRules != null : !((Object)this$filterRules).equals(other$filterRules)) {
            return false;
        }
        ScriptBase this$scriptBase = this.getScriptBase();
        ScriptBase other$scriptBase = other.getScriptBase();
        return !(this$scriptBase == null ? other$scriptBase != null : !((Object)this$scriptBase).equals(other$scriptBase));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FilterDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FilterStrategy $filterStrategy = this.getFilterStrategy();
        result = result * 59 + ($filterStrategy == null ? 43 : ((Object)((Object)$filterStrategy)).hashCode());
        FilterMode $filterMode = this.getFilterMode();
        result = result * 59 + ($filterMode == null ? 43 : ((Object)((Object)$filterMode)).hashCode());
        List<FilterRule> $filterRules = this.getFilterRules();
        result = result * 59 + ($filterRules == null ? 43 : ((Object)$filterRules).hashCode());
        ScriptBase $scriptBase = this.getScriptBase();
        result = result * 59 + ($scriptBase == null ? 43 : ((Object)$scriptBase).hashCode());
        return result;
    }

    public FilterDefinition() {
    }

    @JsonFormat
    public static enum FilterStrategy {
        RETAIN,
        REMOVE;

    }

    @JsonFormat
    public static enum FilterMode {
        RULE,
        SCRIPT;

    }

    public static class ScriptBase {
        private TransformDefinition.ScriptType scriptType;
        private String script;

        public TransformDefinition.ScriptType getScriptType() {
            return this.scriptType;
        }

        public String getScript() {
            return this.script;
        }

        public void setScriptType(TransformDefinition.ScriptType scriptType) {
            this.scriptType = scriptType;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScriptBase)) {
                return false;
            }
            ScriptBase other = (ScriptBase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TransformDefinition.ScriptType this$scriptType = this.getScriptType();
            TransformDefinition.ScriptType other$scriptType = other.getScriptType();
            if (this$scriptType == null ? other$scriptType != null : !((Object)((Object)this$scriptType)).equals((Object)other$scriptType)) {
                return false;
            }
            String this$script = this.getScript();
            String other$script = other.getScript();
            return !(this$script == null ? other$script != null : !this$script.equals(other$script));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScriptBase;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TransformDefinition.ScriptType $scriptType = this.getScriptType();
            result = result * 59 + ($scriptType == null ? 43 : ((Object)((Object)$scriptType)).hashCode());
            String $script = this.getScript();
            result = result * 59 + ($script == null ? 43 : $script.hashCode());
            return result;
        }

        public String toString() {
            return "FilterDefinition.ScriptBase(scriptType=" + (Object)((Object)this.getScriptType()) + ", script=" + this.getScript() + ")";
        }

        public ScriptBase() {
        }

        public ScriptBase(TransformDefinition.ScriptType scriptType, String script) {
            this.scriptType = scriptType;
            this.script = script;
        }
    }

    public static class FilterRule {
        private StreamField sourceField;
        private TransformDefinition.OperationType operationType;
        private TargetValue targetValue;
        private TransformDefinition.RuleRelation relationWithPost;

        public StreamField getSourceField() {
            return this.sourceField;
        }

        public TransformDefinition.OperationType getOperationType() {
            return this.operationType;
        }

        public TargetValue getTargetValue() {
            return this.targetValue;
        }

        public TransformDefinition.RuleRelation getRelationWithPost() {
            return this.relationWithPost;
        }

        public void setSourceField(StreamField sourceField) {
            this.sourceField = sourceField;
        }

        public void setOperationType(TransformDefinition.OperationType operationType) {
            this.operationType = operationType;
        }

        public void setTargetValue(TargetValue targetValue) {
            this.targetValue = targetValue;
        }

        public void setRelationWithPost(TransformDefinition.RuleRelation relationWithPost) {
            this.relationWithPost = relationWithPost;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterRule)) {
                return false;
            }
            FilterRule other = (FilterRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StreamField this$sourceField = this.getSourceField();
            StreamField other$sourceField = other.getSourceField();
            if (this$sourceField == null ? other$sourceField != null : !((Object)this$sourceField).equals(other$sourceField)) {
                return false;
            }
            TransformDefinition.OperationType this$operationType = this.getOperationType();
            TransformDefinition.OperationType other$operationType = other.getOperationType();
            if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
                return false;
            }
            TargetValue this$targetValue = this.getTargetValue();
            TargetValue other$targetValue = other.getTargetValue();
            if (this$targetValue == null ? other$targetValue != null : !((Object)this$targetValue).equals(other$targetValue)) {
                return false;
            }
            TransformDefinition.RuleRelation this$relationWithPost = this.getRelationWithPost();
            TransformDefinition.RuleRelation other$relationWithPost = other.getRelationWithPost();
            return !(this$relationWithPost == null ? other$relationWithPost != null : !((Object)((Object)this$relationWithPost)).equals((Object)other$relationWithPost));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FilterRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StreamField $sourceField = this.getSourceField();
            result = result * 59 + ($sourceField == null ? 43 : ((Object)$sourceField).hashCode());
            TransformDefinition.OperationType $operationType = this.getOperationType();
            result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
            TargetValue $targetValue = this.getTargetValue();
            result = result * 59 + ($targetValue == null ? 43 : ((Object)$targetValue).hashCode());
            TransformDefinition.RuleRelation $relationWithPost = this.getRelationWithPost();
            result = result * 59 + ($relationWithPost == null ? 43 : ((Object)((Object)$relationWithPost)).hashCode());
            return result;
        }

        public String toString() {
            return "FilterDefinition.FilterRule(sourceField=" + this.getSourceField() + ", operationType=" + (Object)((Object)this.getOperationType()) + ", targetValue=" + this.getTargetValue() + ", relationWithPost=" + (Object)((Object)this.getRelationWithPost()) + ")";
        }

        public FilterRule() {
        }

        public FilterRule(StreamField sourceField, TransformDefinition.OperationType operationType, TargetValue targetValue, TransformDefinition.RuleRelation relationWithPost) {
            this.sourceField = sourceField;
            this.operationType = operationType;
            this.targetValue = targetValue;
            this.relationWithPost = relationWithPost;
        }
    }

    public static class TargetValue {
        private boolean constant;
        private StreamField targetField;
        private String targetConstant;

        public boolean isConstant() {
            return this.constant;
        }

        public StreamField getTargetField() {
            return this.targetField;
        }

        public String getTargetConstant() {
            return this.targetConstant;
        }

        public void setConstant(boolean constant) {
            this.constant = constant;
        }

        public void setTargetField(StreamField targetField) {
            this.targetField = targetField;
        }

        public void setTargetConstant(String targetConstant) {
            this.targetConstant = targetConstant;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TargetValue)) {
                return false;
            }
            TargetValue other = (TargetValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isConstant() != other.isConstant()) {
                return false;
            }
            StreamField this$targetField = this.getTargetField();
            StreamField other$targetField = other.getTargetField();
            if (this$targetField == null ? other$targetField != null : !((Object)this$targetField).equals(other$targetField)) {
                return false;
            }
            String this$targetConstant = this.getTargetConstant();
            String other$targetConstant = other.getTargetConstant();
            return !(this$targetConstant == null ? other$targetConstant != null : !this$targetConstant.equals(other$targetConstant));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TargetValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isConstant() ? 79 : 97);
            StreamField $targetField = this.getTargetField();
            result = result * 59 + ($targetField == null ? 43 : ((Object)$targetField).hashCode());
            String $targetConstant = this.getTargetConstant();
            result = result * 59 + ($targetConstant == null ? 43 : $targetConstant.hashCode());
            return result;
        }

        public String toString() {
            return "FilterDefinition.TargetValue(constant=" + this.isConstant() + ", targetField=" + this.getTargetField() + ", targetConstant=" + this.getTargetConstant() + ")";
        }

        public TargetValue(boolean constant, StreamField targetField, String targetConstant) {
            this.constant = constant;
            this.targetField = targetField;
            this.targetConstant = targetConstant;
        }
    }
}

