/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.user;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.UserTypeEnum;
import org.apache.inlong.manager.common.validation.InEnumInt;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

@ApiModel(value="User info request")
public class UserRequest
extends PageRequest {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @NotBlank(message="User name cannot be blank")
    @ApiModelProperty(value="User name", required=true)
    @Length(min=1, max=256, message="length must be between 1 and 256")
    private @NotBlank(message="User name cannot be blank") @Length(min=1, max=256, message="length must be between 1 and 256") String name;
    @ApiModelProperty(value="Keyword, can be user name")
    private String keyword;
    @ApiModelProperty(value="User password")
    @Length(min=6, max=64, message="length must be between 6 and 64")
    private @Length(min=6, max=64, message="length must be between 6 and 64") String password;
    @ApiModelProperty(value="New password, is required if needs updated")
    @Length(groups={UpdateValidation.class}, min=6, max=64, message="length must be between 6 and 64")
    private @Length(groups={UpdateValidation.class}, min=6, max=64, message="length must be between 6 and 64") String newPassword;
    @ApiModelProperty(value="Secret key")
    @Length(groups={UpdateValidation.class}, min=1, max=256, message="length must be between 1 and 256")
    private @Length(groups={UpdateValidation.class}, min=1, max=256, message="length must be between 1 and 256") String secretKey;
    @ApiModelProperty(value="Public key")
    @Length(groups={UpdateValidation.class}, min=1, max=163840, message="length must be between 1 and 163840")
    private @Length(groups={UpdateValidation.class}, min=1, max=163840, message="length must be between 1 and 163840") String publicKey;
    @ApiModelProperty(value="Private key")
    @Length(groups={UpdateValidation.class}, min=1, max=163840, message="length must be between 1 and 163840")
    private @Length(groups={UpdateValidation.class}, min=1, max=163840, message="length must be between 1 and 163840") String privateKey;
    @ApiModelProperty(value="Encryption key version")
    private Integer encryptVersion;
    @NotNull(message="accountType cannot be null")
    @InEnumInt(value=UserTypeEnum.class)
    @ApiModelProperty(value="Account type: 0 - manager, 1 - operator", required=true)
    @Range(min=0L, max=1L, message="only supports [0: manager, 1: operator]")
    private @NotNull(message="accountType cannot be null") @InEnumInt(value=UserTypeEnum.class) @Range(min=0L, max=1L, message="only supports [0: manager, 1: operator]") Integer accountType;
    @Min(value=1L)
    @NotNull(message="validDays cannot be null")
    @ApiModelProperty(value="Valid days", required=true)
    private @Min(value=1L) @NotNull(message="validDays cannot be null") Integer validDays;
    @ApiModelProperty(value="Version number")
    private Integer version;
    @ApiModelProperty(value="Extension json info")
    private String extParams;

    public static UserRequestBuilder builder() {
        return new UserRequestBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Integer getEncryptVersion() {
        return this.encryptVersion;
    }

    public Integer getAccountType() {
        return this.accountType;
    }

    public Integer getValidDays() {
        return this.validDays;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setEncryptVersion(Integer encryptVersion) {
        this.encryptVersion = encryptVersion;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public void setValidDays(Integer validDays) {
        this.validDays = validDays;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public String toString() {
        return "UserRequest(id=" + this.getId() + ", name=" + this.getName() + ", keyword=" + this.getKeyword() + ", password=" + this.getPassword() + ", newPassword=" + this.getNewPassword() + ", secretKey=" + this.getSecretKey() + ", publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ", encryptVersion=" + this.getEncryptVersion() + ", accountType=" + this.getAccountType() + ", validDays=" + this.getValidDays() + ", version=" + this.getVersion() + ", extParams=" + this.getExtParams() + ")";
    }

    public UserRequest() {
    }

    public UserRequest(Integer id, String name, String keyword, String password, String newPassword, String secretKey, String publicKey, String privateKey, Integer encryptVersion, Integer accountType, Integer validDays, Integer version, String extParams) {
        this.id = id;
        this.name = name;
        this.keyword = keyword;
        this.password = password;
        this.newPassword = newPassword;
        this.secretKey = secretKey;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.encryptVersion = encryptVersion;
        this.accountType = accountType;
        this.validDays = validDays;
        this.version = version;
        this.extParams = extParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserRequest)) {
            return false;
        }
        UserRequest other = (UserRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$encryptVersion = this.getEncryptVersion();
        Integer other$encryptVersion = other.getEncryptVersion();
        if (this$encryptVersion == null ? other$encryptVersion != null : !((Object)this$encryptVersion).equals(other$encryptVersion)) {
            return false;
        }
        Integer this$accountType = this.getAccountType();
        Integer other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !((Object)this$accountType).equals(other$accountType)) {
            return false;
        }
        Integer this$validDays = this.getValidDays();
        Integer other$validDays = other.getValidDays();
        if (this$validDays == null ? other$validDays != null : !((Object)this$validDays).equals(other$validDays)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$newPassword = this.getNewPassword();
        String other$newPassword = other.getNewPassword();
        if (this$newPassword == null ? other$newPassword != null : !this$newPassword.equals(other$newPassword)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        return !(this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $encryptVersion = this.getEncryptVersion();
        result = result * 59 + ($encryptVersion == null ? 43 : ((Object)$encryptVersion).hashCode());
        Integer $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : ((Object)$accountType).hashCode());
        Integer $validDays = this.getValidDays();
        result = result * 59 + ($validDays == null ? 43 : ((Object)$validDays).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $newPassword = this.getNewPassword();
        result = result * 59 + ($newPassword == null ? 43 : $newPassword.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        return result;
    }

    public static class UserRequestBuilder {
        private Integer id;
        private String name;
        private String keyword;
        private String password;
        private String newPassword;
        private String secretKey;
        private String publicKey;
        private String privateKey;
        private Integer encryptVersion;
        private Integer accountType;
        private Integer validDays;
        private Integer version;
        private String extParams;

        UserRequestBuilder() {
        }

        public UserRequestBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public UserRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UserRequestBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public UserRequestBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserRequestBuilder newPassword(String newPassword) {
            this.newPassword = newPassword;
            return this;
        }

        public UserRequestBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public UserRequestBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public UserRequestBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public UserRequestBuilder encryptVersion(Integer encryptVersion) {
            this.encryptVersion = encryptVersion;
            return this;
        }

        public UserRequestBuilder accountType(Integer accountType) {
            this.accountType = accountType;
            return this;
        }

        public UserRequestBuilder validDays(Integer validDays) {
            this.validDays = validDays;
            return this;
        }

        public UserRequestBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public UserRequestBuilder extParams(String extParams) {
            this.extParams = extParams;
            return this;
        }

        public UserRequest build() {
            return new UserRequest(this.id, this.name, this.keyword, this.password, this.newPassword, this.secretKey, this.publicKey, this.privateKey, this.encryptVersion, this.accountType, this.validDays, this.version, this.extParams);
        }

        public String toString() {
            return "UserRequest.UserRequestBuilder(id=" + this.id + ", name=" + this.name + ", keyword=" + this.keyword + ", password=" + this.password + ", newPassword=" + this.newPassword + ", secretKey=" + this.secretKey + ", publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", encryptVersion=" + this.encryptVersion + ", accountType=" + this.accountType + ", validDays=" + this.validDays + ", version=" + this.version + ", extParams=" + this.extParams + ")";
        }
    }
}

