/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.pojo.common.PageRequest;

@ApiModel(value="Inlong cluster paging query request")
public class ClusterPageRequest
extends PageRequest {
    @ApiModelProperty(value="Cluster type, including TUBEMQ, PULSAR, DATAPROXY, etc.")
    private String type;
    @ApiModelProperty(value="Cluster type list")
    private List<String> typeList;
    @ApiModelProperty(value="Cluster name")
    private String name;
    @ApiModelProperty(value="Cluster display name, just for display")
    private String displayName;
    @ApiModelProperty(value="Parent cluster ID, used for cluster node")
    private Integer parentId;
    @ApiModelProperty(value="Inlong tenant of cluster", hidden=true)
    private String tenant;
    @ApiModelProperty(value="Keywords, name, url, cluster tag, etc.")
    private String keyword;
    @ApiModelProperty(value="Cluster tag")
    private String clusterTag;
    @ApiModelProperty(value="Extend tag")
    private String extTag;
    @ApiModelProperty(value="Protocol type, such as: TCP, HTTP")
    private String protocolType;
    @ApiModelProperty(value="The inlong cluster tag list")
    private List<String> clusterTagList;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;
    @ApiModelProperty(value="Whether the current user is in the administrator role", hidden=true)
    private Boolean isAdminRole;

    public static ClusterPageRequestBuilder builder() {
        return new ClusterPageRequestBuilder();
    }

    public String getType() {
        return this.type;
    }

    public List<String> getTypeList() {
        return this.typeList;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public String getExtTag() {
        return this.extTag;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public List<String> getClusterTagList() {
        return this.clusterTagList;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public Boolean getIsAdminRole() {
        return this.isAdminRole;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTypeList(List<String> typeList) {
        this.typeList = typeList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setClusterTag(String clusterTag) {
        this.clusterTag = clusterTag;
    }

    public void setExtTag(String extTag) {
        this.extTag = extTag;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public void setClusterTagList(List<String> clusterTagList) {
        this.clusterTagList = clusterTagList;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setIsAdminRole(Boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public String toString() {
        return "ClusterPageRequest(type=" + this.getType() + ", typeList=" + this.getTypeList() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", parentId=" + this.getParentId() + ", tenant=" + this.getTenant() + ", keyword=" + this.getKeyword() + ", clusterTag=" + this.getClusterTag() + ", extTag=" + this.getExtTag() + ", protocolType=" + this.getProtocolType() + ", clusterTagList=" + this.getClusterTagList() + ", status=" + this.getStatus() + ", currentUser=" + this.getCurrentUser() + ", isAdminRole=" + this.getIsAdminRole() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterPageRequest)) {
            return false;
        }
        ClusterPageRequest other = (ClusterPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$parentId = this.getParentId();
        Integer other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$isAdminRole = this.getIsAdminRole();
        Boolean other$isAdminRole = other.getIsAdminRole();
        if (this$isAdminRole == null ? other$isAdminRole != null : !((Object)this$isAdminRole).equals(other$isAdminRole)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$typeList = this.getTypeList();
        List<String> other$typeList = other.getTypeList();
        if (this$typeList == null ? other$typeList != null : !((Object)this$typeList).equals(other$typeList)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$clusterTag = this.getClusterTag();
        String other$clusterTag = other.getClusterTag();
        if (this$clusterTag == null ? other$clusterTag != null : !this$clusterTag.equals(other$clusterTag)) {
            return false;
        }
        String this$extTag = this.getExtTag();
        String other$extTag = other.getExtTag();
        if (this$extTag == null ? other$extTag != null : !this$extTag.equals(other$extTag)) {
            return false;
        }
        String this$protocolType = this.getProtocolType();
        String other$protocolType = other.getProtocolType();
        if (this$protocolType == null ? other$protocolType != null : !this$protocolType.equals(other$protocolType)) {
            return false;
        }
        List<String> this$clusterTagList = this.getClusterTagList();
        List<String> other$clusterTagList = other.getClusterTagList();
        if (this$clusterTagList == null ? other$clusterTagList != null : !((Object)this$clusterTagList).equals(other$clusterTagList)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        return !(this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterPageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $isAdminRole = this.getIsAdminRole();
        result = result * 59 + ($isAdminRole == null ? 43 : ((Object)$isAdminRole).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $typeList = this.getTypeList();
        result = result * 59 + ($typeList == null ? 43 : ((Object)$typeList).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $clusterTag = this.getClusterTag();
        result = result * 59 + ($clusterTag == null ? 43 : $clusterTag.hashCode());
        String $extTag = this.getExtTag();
        result = result * 59 + ($extTag == null ? 43 : $extTag.hashCode());
        String $protocolType = this.getProtocolType();
        result = result * 59 + ($protocolType == null ? 43 : $protocolType.hashCode());
        List<String> $clusterTagList = this.getClusterTagList();
        result = result * 59 + ($clusterTagList == null ? 43 : ((Object)$clusterTagList).hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        return result;
    }

    public ClusterPageRequest() {
    }

    public ClusterPageRequest(String type, List<String> typeList, String name, String displayName, Integer parentId, String tenant, String keyword, String clusterTag, String extTag, String protocolType, List<String> clusterTagList, Integer status, String currentUser, Boolean isAdminRole) {
        this.type = type;
        this.typeList = typeList;
        this.name = name;
        this.displayName = displayName;
        this.parentId = parentId;
        this.tenant = tenant;
        this.keyword = keyword;
        this.clusterTag = clusterTag;
        this.extTag = extTag;
        this.protocolType = protocolType;
        this.clusterTagList = clusterTagList;
        this.status = status;
        this.currentUser = currentUser;
        this.isAdminRole = isAdminRole;
    }

    public static class ClusterPageRequestBuilder {
        private String type;
        private List<String> typeList;
        private String name;
        private String displayName;
        private Integer parentId;
        private String tenant;
        private String keyword;
        private String clusterTag;
        private String extTag;
        private String protocolType;
        private List<String> clusterTagList;
        private Integer status;
        private String currentUser;
        private Boolean isAdminRole;

        ClusterPageRequestBuilder() {
        }

        public ClusterPageRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ClusterPageRequestBuilder typeList(List<String> typeList) {
            this.typeList = typeList;
            return this;
        }

        public ClusterPageRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ClusterPageRequestBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ClusterPageRequestBuilder parentId(Integer parentId) {
            this.parentId = parentId;
            return this;
        }

        public ClusterPageRequestBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public ClusterPageRequestBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public ClusterPageRequestBuilder clusterTag(String clusterTag) {
            this.clusterTag = clusterTag;
            return this;
        }

        public ClusterPageRequestBuilder extTag(String extTag) {
            this.extTag = extTag;
            return this;
        }

        public ClusterPageRequestBuilder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public ClusterPageRequestBuilder clusterTagList(List<String> clusterTagList) {
            this.clusterTagList = clusterTagList;
            return this;
        }

        public ClusterPageRequestBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public ClusterPageRequestBuilder currentUser(String currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public ClusterPageRequestBuilder isAdminRole(Boolean isAdminRole) {
            this.isAdminRole = isAdminRole;
            return this;
        }

        public ClusterPageRequest build() {
            return new ClusterPageRequest(this.type, this.typeList, this.name, this.displayName, this.parentId, this.tenant, this.keyword, this.clusterTag, this.extTag, this.protocolType, this.clusterTagList, this.status, this.currentUser, this.isAdminRole);
        }

        public String toString() {
            return "ClusterPageRequest.ClusterPageRequestBuilder(type=" + this.type + ", typeList=" + this.typeList + ", name=" + this.name + ", displayName=" + this.displayName + ", parentId=" + this.parentId + ", tenant=" + this.tenant + ", keyword=" + this.keyword + ", clusterTag=" + this.clusterTag + ", extTag=" + this.extTag + ", protocolType=" + this.protocolType + ", clusterTagList=" + this.clusterTagList + ", status=" + this.status + ", currentUser=" + this.currentUser + ", isAdminRole=" + this.isAdminRole + ")";
        }
    }
}

