/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.HudiProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.KafkaProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.MongoDBProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.MySQLBinlogProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.OracleProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.PostgreSQLProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.PulsarProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.RedisProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.SQLServerProvider;
import org.apache.inlong.manager.pojo.sort.node.provider.TubeMqProvider;

public class ExtractNodeProviderFactory {
    private static final List<ExtractNodeProvider> EXTRACT_NODE_PROVIDER_LIST = new ArrayList<ExtractNodeProvider>();

    public static ExtractNodeProvider getExtractNodeProvider(String sourceType) {
        return EXTRACT_NODE_PROVIDER_LIST.stream().filter(inst -> inst.accept(sourceType)).findFirst().orElseThrow(() -> new BusinessException(ErrorCodeEnum.SOURCE_TYPE_NOT_SUPPORT, String.format(ErrorCodeEnum.SOURCE_TYPE_NOT_SUPPORT.getMessage(), sourceType)));
    }

    static {
        EXTRACT_NODE_PROVIDER_LIST.add(new HudiProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new KafkaProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new MongoDBProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new OracleProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new PulsarProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new RedisProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new TubeMqProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new SQLServerProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new PostgreSQLProvider());
        EXTRACT_NODE_PROVIDER_LIST.add(new MySQLBinlogProvider());
    }
}

