/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sort.node.ExtractNodeProviderFactory;
import org.apache.inlong.manager.pojo.sort.node.LoadNodeProviderFactory;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.LoadNode;

public class NodeFactory {
    public static List<ExtractNode> createExtractNodes(List<StreamSource> sourceInfos) {
        if (CollectionUtils.isEmpty(sourceInfos)) {
            return Lists.newArrayList();
        }
        return sourceInfos.stream().map(v -> {
            String sourceType = v.getSourceType();
            return ExtractNodeProviderFactory.getExtractNodeProvider(sourceType).createExtractNode((StreamNode)v);
        }).collect(Collectors.toList());
    }

    public static List<LoadNode> createLoadNodes(List<StreamSink> sinkInfos, Map<String, StreamField> constantFieldMap) {
        if (CollectionUtils.isEmpty(sinkInfos)) {
            return Lists.newArrayList();
        }
        return sinkInfos.stream().map(v -> {
            String sinkType = v.getSinkType();
            return LoadNodeProviderFactory.getLoadNodeProvider(sinkType).createLoadNode((StreamNode)v, constantFieldMap);
        }).collect(Collectors.toList());
    }
}

