/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.base;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.pojo.sort.node.base.NodeProvider;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.format.AvroFormat;
import org.apache.inlong.sort.protocol.node.format.CanalJsonFormat;
import org.apache.inlong.sort.protocol.node.format.CsvFormat;
import org.apache.inlong.sort.protocol.node.format.DebeziumJsonFormat;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.format.InLongMsgFormat;
import org.apache.inlong.sort.protocol.node.format.JsonFormat;
import org.apache.inlong.sort.protocol.node.format.RawFormat;

public interface ExtractNodeProvider
extends NodeProvider {
    public ExtractNode createExtractNode(StreamNode var1);

    default public List<FieldInfo> parseStreamFieldInfos(List<StreamField> streamFields, String nodeId) {
        return this.parseStreamFieldInfos(streamFields, nodeId, null);
    }

    default public List<FieldInfo> parseStreamFieldInfos(List<StreamField> streamFields, String nodeId, FieldTypeMappingStrategy fieldTypeMappingStrategy) {
        return streamFields.stream().filter(s -> Objects.isNull(s.getFieldValue())).map(streamFieldInfo -> FieldInfoUtils.parseStreamFieldInfo(streamFieldInfo, nodeId, fieldTypeMappingStrategy)).collect(Collectors.toList());
    }

    default public Format parsingFormat(String serializationType, boolean wrapWithInlongMsg, String separatorStr, boolean ignoreParseErrors) {
        AvroFormat format;
        DataTypeEnum dataType = DataTypeEnum.forType((String)serializationType);
        switch (dataType) {
            case CSV: {
                if (StringUtils.isNumeric((CharSequence)separatorStr)) {
                    char dataSeparator = (char)Integer.parseInt(separatorStr);
                    separatorStr = Character.toString(dataSeparator);
                }
                CsvFormat csvFormat = new CsvFormat(separatorStr);
                csvFormat.setIgnoreParseErrors(Boolean.valueOf(ignoreParseErrors));
                format = csvFormat;
                break;
            }
            case AVRO: {
                format = new AvroFormat();
                break;
            }
            case JSON: {
                JsonFormat jsonFormat = new JsonFormat();
                jsonFormat.setIgnoreParseErrors(Boolean.valueOf(ignoreParseErrors));
                format = jsonFormat;
                break;
            }
            case CANAL: {
                format = new CanalJsonFormat();
                break;
            }
            case DEBEZIUM_JSON: {
                DebeziumJsonFormat debeziumJsonFormat = new DebeziumJsonFormat();
                debeziumJsonFormat.setIgnoreParseErrors(Boolean.valueOf(ignoreParseErrors));
                format = debeziumJsonFormat;
                break;
            }
            case RAW: {
                format = new RawFormat();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported dataType=%s", dataType));
            }
        }
        if (wrapWithInlongMsg) {
            AvroFormat innerFormat = format;
            format = new InLongMsgFormat((Format)innerFormat, Boolean.valueOf(false));
        }
        return format;
    }
}

