/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.source.pulsar.PulsarSource;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.enums.PulsarScanStartupMode;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.extract.PulsarExtractNode;
import org.apache.inlong.sort.protocol.node.format.Format;

public class PulsarProvider
implements ExtractNodeProvider {
    @Override
    public Boolean accept(String sourceType) {
        return "PULSAR".equals(sourceType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        PulsarSource pulsarSource = (PulsarSource)streamNodeInfo;
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(pulsarSource.getFieldList(), pulsarSource.getSourceName());
        Map<String, String> properties = this.parseProperties(pulsarSource.getProperties());
        String fullTopicName = pulsarSource.getPulsarTenant() + "/" + pulsarSource.getNamespace() + "/" + pulsarSource.getTopic();
        Format format = this.parsingFormat(pulsarSource.getSerializationType(), pulsarSource.isWrapWithInlongMsg(), pulsarSource.getDataSeparator(), pulsarSource.isIgnoreParseError());
        PulsarScanStartupMode startupMode = PulsarScanStartupMode.forName((String)pulsarSource.getScanStartupMode());
        String primaryKey = pulsarSource.getPrimaryKey();
        String serviceUrl = pulsarSource.getServiceUrl();
        String adminUrl = pulsarSource.getAdminUrl();
        String scanStartupSubStartOffset = StringUtils.isNotBlank((CharSequence)pulsarSource.getSubscription()) ? PulsarScanStartupMode.EARLIEST.getValue() : null;
        return new PulsarExtractNode(pulsarSource.getSourceName(), pulsarSource.getSourceName(), fieldInfos, null, properties, fullTopicName, adminUrl, serviceUrl, format, startupMode.getValue(), primaryKey, pulsarSource.getSubscription(), scanStartupSubStartOffset);
    }
}

