/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.audit;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;

@ApiModel(value="Audit source request")
public class AuditSourceRequest {
    @NotBlank
    @ApiModelProperty(value="Audit source name")
    private String name;
    @NotBlank
    @ApiModelProperty(value="Audit source type, including: MYSQL, CLICKHOUSE, ELASTICSEARCH", required=true)
    private String type;
    @NotBlank
    @ApiModelProperty(value="Audit source URL, for MYSQL or CLICKHOUSE, is jdbcUrl, and for ELASTICSEARCH is the access URL with hostname:port", required=true)
    private String url;
    @ApiModelProperty(value="Offline the url if not null")
    private String offlineUrl;
    @ApiModelProperty(value="Enable auth or not, 0: disable, 1: enable")
    private Integer enableAuth;
    @ApiModelProperty(value="Audit source username, needed if enableAuth is 1")
    private String username;
    @ApiModelProperty(value="Audit source token, needed if enableAuth is 1")
    private String token;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public static AuditSourceRequestBuilder builder() {
        return new AuditSourceRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getOfflineUrl() {
        return this.offlineUrl;
    }

    public Integer getEnableAuth() {
        return this.enableAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOfflineUrl(String offlineUrl) {
        this.offlineUrl = offlineUrl;
    }

    public void setEnableAuth(Integer enableAuth) {
        this.enableAuth = enableAuth;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditSourceRequest)) {
            return false;
        }
        AuditSourceRequest other = (AuditSourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$enableAuth = this.getEnableAuth();
        Integer other$enableAuth = other.getEnableAuth();
        if (this$enableAuth == null ? other$enableAuth != null : !((Object)this$enableAuth).equals(other$enableAuth)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$offlineUrl = this.getOfflineUrl();
        String other$offlineUrl = other.getOfflineUrl();
        if (this$offlineUrl == null ? other$offlineUrl != null : !this$offlineUrl.equals(other$offlineUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditSourceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $enableAuth = this.getEnableAuth();
        result = result * 59 + ($enableAuth == null ? 43 : ((Object)$enableAuth).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $offlineUrl = this.getOfflineUrl();
        result = result * 59 + ($offlineUrl == null ? 43 : $offlineUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "AuditSourceRequest(name=" + this.getName() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", offlineUrl=" + this.getOfflineUrl() + ", enableAuth=" + this.getEnableAuth() + ", username=" + this.getUsername() + ", token=" + this.getToken() + ", version=" + this.getVersion() + ")";
    }

    public AuditSourceRequest() {
    }

    public AuditSourceRequest(String name, String type, String url, String offlineUrl, Integer enableAuth, String username, String token, Integer version) {
        this.name = name;
        this.type = type;
        this.url = url;
        this.offlineUrl = offlineUrl;
        this.enableAuth = enableAuth;
        this.username = username;
        this.token = token;
        this.version = version;
    }

    public static class AuditSourceRequestBuilder {
        private String name;
        private String type;
        private String url;
        private String offlineUrl;
        private Integer enableAuth;
        private String username;
        private String token;
        private Integer version;

        AuditSourceRequestBuilder() {
        }

        public AuditSourceRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AuditSourceRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AuditSourceRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public AuditSourceRequestBuilder offlineUrl(String offlineUrl) {
            this.offlineUrl = offlineUrl;
            return this;
        }

        public AuditSourceRequestBuilder enableAuth(Integer enableAuth) {
            this.enableAuth = enableAuth;
            return this;
        }

        public AuditSourceRequestBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AuditSourceRequestBuilder token(String token) {
            this.token = token;
            return this;
        }

        public AuditSourceRequestBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public AuditSourceRequest build() {
            return new AuditSourceRequest(this.name, this.type, this.url, this.offlineUrl, this.enableAuth, this.username, this.token, this.version);
        }

        public String toString() {
            return "AuditSourceRequest.AuditSourceRequestBuilder(name=" + this.name + ", type=" + this.type + ", url=" + this.url + ", offlineUrl=" + this.offlineUrl + ", enableAuth=" + this.enableAuth + ", username=" + this.username + ", token=" + this.token + ", version=" + this.version + ")";
        }
    }
}

