/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateByIdValidation;
import org.apache.inlong.manager.common.validation.UpdateByKeyValidation;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

@ApiModel(value="Stream sink request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="sinkType")
public abstract class SinkRequest {
    @ApiModelProperty(value="Primary key")
    @NotNull(groups={UpdateByIdValidation.class}, message="id cannot be null")
    private @NotNull(groups={UpdateByIdValidation.class}, message="id cannot be null") Integer id;
    @ApiModelProperty(value="Inlong group id")
    @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="inlongGroupId cannot be blank")
    @Length(min=4, max=256, message="length must be between 4 and 200")
    @Pattern(regexp="^[a-zA-Z0-9_.-]{4,200}$", message="only supports letters, numbers, '.', '-', or '_'")
    private @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="inlongGroupId cannot be blank") @Length(min=4, max=256, message="length must be between 4 and 200") @Pattern(regexp="^[a-zA-Z0-9_.-]{4,200}$", message="only supports letters, numbers, '.', '-', or '_'") String inlongGroupId;
    @ApiModelProperty(value="Inlong stream id")
    @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="inlongStreamId cannot be blank")
    @Length(min=1, max=256, message="inlongStreamId length must be between 1 and 200")
    @Pattern(regexp="^[a-zA-Z0-9_.-]{1,200}$", message="inlongStreamId only supports letters, numbers, '.', '-', or '_'")
    private @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="inlongStreamId cannot be blank") @Length(min=1, max=256, message="inlongStreamId length must be between 1 and 200") @Pattern(regexp="^[a-zA-Z0-9_.-]{1,200}$", message="inlongStreamId only supports letters, numbers, '.', '-', or '_'") String inlongStreamId;
    @ApiModelProperty(value="Sink type, including: HIVE, ES, etc.")
    @NotBlank(message="sinkType cannot be blank")
    @Length(max=15, message="length must be less than or equal to 15")
    private @NotBlank(message="sinkType cannot be blank") @Length(max=15, message="length must be less than or equal to 15") String sinkType;
    @ApiModelProperty(value="Sink name, unique in one stream")
    @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="sinkName cannot be blank")
    @Length(min=1, max=100, message="sinkName length must be between 1 and 100")
    @Pattern(regexp="^[a-zA-Z0-9_.-]{1,100}$", message="sinkName only supports letters, numbers, '.', '-', or '_'")
    private @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="sinkName cannot be blank") @Length(min=1, max=100, message="sinkName length must be between 1 and 100") @Pattern(regexp="^[a-zA-Z0-9_.-]{1,100}$", message="sinkName only supports letters, numbers, '.', '-', or '_'") String sinkName;
    @ApiModelProperty(value="Sink description")
    @Length(max=500, message="length must be less than or equal to 500")
    private @Length(max=500, message="length must be less than or equal to 500") String description;
    @ApiModelProperty(value="Inlong cluster name")
    @Length(min=1, max=128, message="length must be between 1 and 128")
    @Pattern(regexp="^[a-z0-9_.-]{1,128}$", message="only supports lowercase letters, numbers, '.', '-', or '_'")
    private @Length(min=1, max=128, message="length must be between 1 and 128") @Pattern(regexp="^[a-z0-9_.-]{1,128}$", message="only supports lowercase letters, numbers, '.', '-', or '_'") String inlongClusterName;
    @ApiModelProperty(value="Data node name")
    @Length(min=1, max=128, message="length must be between 1 and 128")
    @Pattern(regexp="^[A-Za-z0-9_-]{1,128}$", message="only supports letters, numbers, '-', or '_'")
    private @Length(min=1, max=128, message="length must be between 1 and 128") @Pattern(regexp="^[A-Za-z0-9_-]{1,128}$", message="only supports letters, numbers, '-', or '_'") String dataNodeName;
    @ApiModelProperty(value="Sort task name")
    @Length(max=512, message="length must be less than or equal to 512")
    private @Length(max=512, message="length must be less than or equal to 512") String sortTaskName;
    @ApiModelProperty(value="Sort consumer group")
    @Length(max=512, message="length must be less than or equal to 512")
    private @Length(max=512, message="length must be less than or equal to 512") String sortConsumerGroup;
    @ApiModelProperty(value="Whether to enable create sink resource? 0: disable, 1: enable. Default is 1")
    @Range(min=0L, max=1L, message="default is 1, only supports [0: disable, 1: enable]")
    private @Range(min=0L, max=1L, message="default is 1, only supports [0: disable, 1: enable]") Integer enableCreateResource = 1;
    @ApiModelProperty(value="Whether to start the process after saving or updating. Default is false")
    private Boolean startProcess = false;
    @ApiModelProperty(value="Sink field list")
    private List<SinkField> sinkFieldList;
    @ApiModelProperty(value="Other properties if needed")
    private Map<String, Object> properties = Maps.newHashMap();
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateByIdValidation.class, UpdateByKeyValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateByIdValidation.class, UpdateByKeyValidation.class}, message="version cannot be null") Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getSinkType() {
        return this.sinkType;
    }

    public String getSinkName() {
        return this.sinkName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInlongClusterName() {
        return this.inlongClusterName;
    }

    public String getDataNodeName() {
        return this.dataNodeName;
    }

    public String getSortTaskName() {
        return this.sortTaskName;
    }

    public String getSortConsumerGroup() {
        return this.sortConsumerGroup;
    }

    public Integer getEnableCreateResource() {
        return this.enableCreateResource;
    }

    public Boolean getStartProcess() {
        return this.startProcess;
    }

    public List<SinkField> getSinkFieldList() {
        return this.sinkFieldList;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setSinkType(String sinkType) {
        this.sinkType = sinkType;
    }

    public void setSinkName(String sinkName) {
        this.sinkName = sinkName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInlongClusterName(String inlongClusterName) {
        this.inlongClusterName = inlongClusterName;
    }

    public void setDataNodeName(String dataNodeName) {
        this.dataNodeName = dataNodeName;
    }

    public void setSortTaskName(String sortTaskName) {
        this.sortTaskName = sortTaskName;
    }

    public void setSortConsumerGroup(String sortConsumerGroup) {
        this.sortConsumerGroup = sortConsumerGroup;
    }

    public void setEnableCreateResource(Integer enableCreateResource) {
        this.enableCreateResource = enableCreateResource;
    }

    public void setStartProcess(Boolean startProcess) {
        this.startProcess = startProcess;
    }

    public void setSinkFieldList(List<SinkField> sinkFieldList) {
        this.sinkFieldList = sinkFieldList;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkRequest)) {
            return false;
        }
        SinkRequest other = (SinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$enableCreateResource = this.getEnableCreateResource();
        Integer other$enableCreateResource = other.getEnableCreateResource();
        if (this$enableCreateResource == null ? other$enableCreateResource != null : !((Object)this$enableCreateResource).equals(other$enableCreateResource)) {
            return false;
        }
        Boolean this$startProcess = this.getStartProcess();
        Boolean other$startProcess = other.getStartProcess();
        if (this$startProcess == null ? other$startProcess != null : !((Object)this$startProcess).equals(other$startProcess)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$sinkType = this.getSinkType();
        String other$sinkType = other.getSinkType();
        if (this$sinkType == null ? other$sinkType != null : !this$sinkType.equals(other$sinkType)) {
            return false;
        }
        String this$sinkName = this.getSinkName();
        String other$sinkName = other.getSinkName();
        if (this$sinkName == null ? other$sinkName != null : !this$sinkName.equals(other$sinkName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$inlongClusterName = this.getInlongClusterName();
        String other$inlongClusterName = other.getInlongClusterName();
        if (this$inlongClusterName == null ? other$inlongClusterName != null : !this$inlongClusterName.equals(other$inlongClusterName)) {
            return false;
        }
        String this$dataNodeName = this.getDataNodeName();
        String other$dataNodeName = other.getDataNodeName();
        if (this$dataNodeName == null ? other$dataNodeName != null : !this$dataNodeName.equals(other$dataNodeName)) {
            return false;
        }
        String this$sortTaskName = this.getSortTaskName();
        String other$sortTaskName = other.getSortTaskName();
        if (this$sortTaskName == null ? other$sortTaskName != null : !this$sortTaskName.equals(other$sortTaskName)) {
            return false;
        }
        String this$sortConsumerGroup = this.getSortConsumerGroup();
        String other$sortConsumerGroup = other.getSortConsumerGroup();
        if (this$sortConsumerGroup == null ? other$sortConsumerGroup != null : !this$sortConsumerGroup.equals(other$sortConsumerGroup)) {
            return false;
        }
        List<SinkField> this$sinkFieldList = this.getSinkFieldList();
        List<SinkField> other$sinkFieldList = other.getSinkFieldList();
        if (this$sinkFieldList == null ? other$sinkFieldList != null : !((Object)this$sinkFieldList).equals(other$sinkFieldList)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $enableCreateResource = this.getEnableCreateResource();
        result = result * 59 + ($enableCreateResource == null ? 43 : ((Object)$enableCreateResource).hashCode());
        Boolean $startProcess = this.getStartProcess();
        result = result * 59 + ($startProcess == null ? 43 : ((Object)$startProcess).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $sinkType = this.getSinkType();
        result = result * 59 + ($sinkType == null ? 43 : $sinkType.hashCode());
        String $sinkName = this.getSinkName();
        result = result * 59 + ($sinkName == null ? 43 : $sinkName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $inlongClusterName = this.getInlongClusterName();
        result = result * 59 + ($inlongClusterName == null ? 43 : $inlongClusterName.hashCode());
        String $dataNodeName = this.getDataNodeName();
        result = result * 59 + ($dataNodeName == null ? 43 : $dataNodeName.hashCode());
        String $sortTaskName = this.getSortTaskName();
        result = result * 59 + ($sortTaskName == null ? 43 : $sortTaskName.hashCode());
        String $sortConsumerGroup = this.getSortConsumerGroup();
        result = result * 59 + ($sortConsumerGroup == null ? 43 : $sortConsumerGroup.hashCode());
        List<SinkField> $sinkFieldList = this.getSinkFieldList();
        result = result * 59 + ($sinkFieldList == null ? 43 : ((Object)$sinkFieldList).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "SinkRequest(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", sinkType=" + this.getSinkType() + ", sinkName=" + this.getSinkName() + ", description=" + this.getDescription() + ", inlongClusterName=" + this.getInlongClusterName() + ", dataNodeName=" + this.getDataNodeName() + ", sortTaskName=" + this.getSortTaskName() + ", sortConsumerGroup=" + this.getSortConsumerGroup() + ", enableCreateResource=" + this.getEnableCreateResource() + ", startProcess=" + this.getStartProcess() + ", sinkFieldList=" + this.getSinkFieldList() + ", properties=" + this.getProperties() + ", version=" + this.getVersion() + ")";
    }
}

