/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.cls;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.cls.ClsSinkRequest;

public class ClsSinkDTO {
    @ApiModelProperty(value="Cloud log service topic id")
    private String topicId;
    @ApiModelProperty(value="Cloud log service topic name")
    private String topicName;
    @ApiModelProperty(value="Cloud log service topic save time")
    private Integer saveTime;
    @ApiModelProperty(value="Cloud log service tag name")
    private String tag;
    @ApiModelProperty(value="Cloud log service index tokenizer")
    private String tokenizer;

    public static ClsSinkDTO getFromRequest(ClsSinkRequest request, String extParams) {
        ClsSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? ClsSinkDTO.getFromJson(extParams) : new ClsSinkDTO();
        return (ClsSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static ClsSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (ClsSinkDTO)JsonUtils.parseObject((String)extParams, ClsSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of CLS SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static ClsSinkDTOBuilder builder() {
        return new ClsSinkDTOBuilder();
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public Integer getSaveTime() {
        return this.saveTime;
    }

    public String getTag() {
        return this.tag;
    }

    public String getTokenizer() {
        return this.tokenizer;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setSaveTime(Integer saveTime) {
        this.saveTime = saveTime;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setTokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClsSinkDTO)) {
            return false;
        }
        ClsSinkDTO other = (ClsSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$saveTime = this.getSaveTime();
        Integer other$saveTime = other.getSaveTime();
        if (this$saveTime == null ? other$saveTime != null : !((Object)this$saveTime).equals(other$saveTime)) {
            return false;
        }
        String this$topicId = this.getTopicId();
        String other$topicId = other.getTopicId();
        if (this$topicId == null ? other$topicId != null : !this$topicId.equals(other$topicId)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$tokenizer = this.getTokenizer();
        String other$tokenizer = other.getTokenizer();
        return !(this$tokenizer == null ? other$tokenizer != null : !this$tokenizer.equals(other$tokenizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClsSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $saveTime = this.getSaveTime();
        result = result * 59 + ($saveTime == null ? 43 : ((Object)$saveTime).hashCode());
        String $topicId = this.getTopicId();
        result = result * 59 + ($topicId == null ? 43 : $topicId.hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $tokenizer = this.getTokenizer();
        result = result * 59 + ($tokenizer == null ? 43 : $tokenizer.hashCode());
        return result;
    }

    public String toString() {
        return "ClsSinkDTO(topicId=" + this.getTopicId() + ", topicName=" + this.getTopicName() + ", saveTime=" + this.getSaveTime() + ", tag=" + this.getTag() + ", tokenizer=" + this.getTokenizer() + ")";
    }

    public ClsSinkDTO() {
    }

    public ClsSinkDTO(String topicId, String topicName, Integer saveTime, String tag, String tokenizer) {
        this.topicId = topicId;
        this.topicName = topicName;
        this.saveTime = saveTime;
        this.tag = tag;
        this.tokenizer = tokenizer;
    }

    public static class ClsSinkDTOBuilder {
        private String topicId;
        private String topicName;
        private Integer saveTime;
        private String tag;
        private String tokenizer;

        ClsSinkDTOBuilder() {
        }

        public ClsSinkDTOBuilder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public ClsSinkDTOBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ClsSinkDTOBuilder saveTime(Integer saveTime) {
            this.saveTime = saveTime;
            return this;
        }

        public ClsSinkDTOBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public ClsSinkDTOBuilder tokenizer(String tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public ClsSinkDTO build() {
            return new ClsSinkDTO(this.topicId, this.topicName, this.saveTime, this.tag, this.tokenizer);
        }

        public String toString() {
            return "ClsSinkDTO.ClsSinkDTOBuilder(topicId=" + this.topicId + ", topicName=" + this.topicName + ", saveTime=" + this.saveTime + ", tag=" + this.tag + ", tokenizer=" + this.tokenizer + ")";
        }
    }
}

