/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.doris;

import io.swagger.annotations.ApiModelProperty;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.doris.DorisSinkRequest;

public class DorisSinkDTO {
    @ApiModelProperty(value="Doris FE http address")
    private String feNodes;
    @ApiModelProperty(value="Username for doris accessing")
    private String username;
    @ApiModelProperty(value="Password for doris accessing")
    private String password;
    @ApiModelProperty(value="Doris table name, such as: db.tbl")
    private String tableIdentifier;
    @ApiModelProperty(value="Label prefix for stream loading. Used for guaranteeing Flink EOS semantics, as global unique is needed in 2pc.")
    private String labelPrefix;
    @ApiModelProperty(value="The primary key of sink table")
    private String primaryKey;
    @ApiModelProperty(value="The multiple enable of sink")
    private Boolean sinkMultipleEnable = false;
    @ApiModelProperty(value="The multiple format of sink")
    private String sinkMultipleFormat;
    @ApiModelProperty(value="The multiple database-pattern of sink")
    private String databasePattern;
    @ApiModelProperty(value="The multiple table-pattern of sink")
    private String tablePattern;
    @ApiModelProperty(value="Password encrypt version")
    private Integer encryptVersion;
    @ApiModelProperty(value="Properties for doris")
    private Map<String, Object> properties;

    public static DorisSinkDTO getFromRequest(DorisSinkRequest request, String extParams) throws Exception {
        Integer encryptVersion = AESUtils.getCurrentVersion(null);
        String passwd = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getPassword())) {
            passwd = AESUtils.encryptToString((byte[])request.getPassword().getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion);
        }
        DorisSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? DorisSinkDTO.getFromJson(extParams) : new DorisSinkDTO();
        CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
        dto.setPassword(passwd);
        return dto;
    }

    public static DorisSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return ((DorisSinkDTO)JsonUtils.parseObject((String)extParams, DorisSinkDTO.class)).decryptPassword();
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of Doris SinkDTO failure: %s", e.getMessage()));
        }
    }

    private DorisSinkDTO decryptPassword() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            byte[] passwordBytes = AESUtils.decryptAsString((String)this.password, (Integer)this.encryptVersion);
            this.password = new String(passwordBytes, StandardCharsets.UTF_8);
        }
        return this;
    }

    public static DorisSinkDTOBuilder builder() {
        return new DorisSinkDTOBuilder();
    }

    public String getFeNodes() {
        return this.feNodes;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableIdentifier() {
        return this.tableIdentifier;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    public String getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public Integer getEncryptVersion() {
        return this.encryptVersion;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setFeNodes(String feNodes) {
        this.feNodes = feNodes;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTableIdentifier(String tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    public void setLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setSinkMultipleEnable(Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(String sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setEncryptVersion(Integer encryptVersion) {
        this.encryptVersion = encryptVersion;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DorisSinkDTO)) {
            return false;
        }
        DorisSinkDTO other = (DorisSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        Integer this$encryptVersion = this.getEncryptVersion();
        Integer other$encryptVersion = other.getEncryptVersion();
        if (this$encryptVersion == null ? other$encryptVersion != null : !((Object)this$encryptVersion).equals(other$encryptVersion)) {
            return false;
        }
        String this$feNodes = this.getFeNodes();
        String other$feNodes = other.getFeNodes();
        if (this$feNodes == null ? other$feNodes != null : !this$feNodes.equals(other$feNodes)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tableIdentifier = this.getTableIdentifier();
        String other$tableIdentifier = other.getTableIdentifier();
        if (this$tableIdentifier == null ? other$tableIdentifier != null : !this$tableIdentifier.equals(other$tableIdentifier)) {
            return false;
        }
        String this$labelPrefix = this.getLabelPrefix();
        String other$labelPrefix = other.getLabelPrefix();
        if (this$labelPrefix == null ? other$labelPrefix != null : !this$labelPrefix.equals(other$labelPrefix)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$sinkMultipleFormat = this.getSinkMultipleFormat();
        String other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DorisSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        Integer $encryptVersion = this.getEncryptVersion();
        result = result * 59 + ($encryptVersion == null ? 43 : ((Object)$encryptVersion).hashCode());
        String $feNodes = this.getFeNodes();
        result = result * 59 + ($feNodes == null ? 43 : $feNodes.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tableIdentifier = this.getTableIdentifier();
        result = result * 59 + ($tableIdentifier == null ? 43 : $tableIdentifier.hashCode());
        String $labelPrefix = this.getLabelPrefix();
        result = result * 59 + ($labelPrefix == null ? 43 : $labelPrefix.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "DorisSinkDTO(feNodes=" + this.getFeNodes() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableIdentifier=" + this.getTableIdentifier() + ", labelPrefix=" + this.getLabelPrefix() + ", primaryKey=" + this.getPrimaryKey() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", encryptVersion=" + this.getEncryptVersion() + ", properties=" + this.getProperties() + ")";
    }

    public DorisSinkDTO() {
    }

    public DorisSinkDTO(String feNodes, String username, String password, String tableIdentifier, String labelPrefix, String primaryKey, Boolean sinkMultipleEnable, String sinkMultipleFormat, String databasePattern, String tablePattern, Integer encryptVersion, Map<String, Object> properties) {
        this.feNodes = feNodes;
        this.username = username;
        this.password = password;
        this.tableIdentifier = tableIdentifier;
        this.labelPrefix = labelPrefix;
        this.primaryKey = primaryKey;
        this.sinkMultipleEnable = sinkMultipleEnable;
        this.sinkMultipleFormat = sinkMultipleFormat;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.encryptVersion = encryptVersion;
        this.properties = properties;
    }

    public static class DorisSinkDTOBuilder {
        private String feNodes;
        private String username;
        private String password;
        private String tableIdentifier;
        private String labelPrefix;
        private String primaryKey;
        private Boolean sinkMultipleEnable;
        private String sinkMultipleFormat;
        private String databasePattern;
        private String tablePattern;
        private Integer encryptVersion;
        private Map<String, Object> properties;

        DorisSinkDTOBuilder() {
        }

        public DorisSinkDTOBuilder feNodes(String feNodes) {
            this.feNodes = feNodes;
            return this;
        }

        public DorisSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public DorisSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public DorisSinkDTOBuilder tableIdentifier(String tableIdentifier) {
            this.tableIdentifier = tableIdentifier;
            return this;
        }

        public DorisSinkDTOBuilder labelPrefix(String labelPrefix) {
            this.labelPrefix = labelPrefix;
            return this;
        }

        public DorisSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public DorisSinkDTOBuilder sinkMultipleEnable(Boolean sinkMultipleEnable) {
            this.sinkMultipleEnable = sinkMultipleEnable;
            return this;
        }

        public DorisSinkDTOBuilder sinkMultipleFormat(String sinkMultipleFormat) {
            this.sinkMultipleFormat = sinkMultipleFormat;
            return this;
        }

        public DorisSinkDTOBuilder databasePattern(String databasePattern) {
            this.databasePattern = databasePattern;
            return this;
        }

        public DorisSinkDTOBuilder tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return this;
        }

        public DorisSinkDTOBuilder encryptVersion(Integer encryptVersion) {
            this.encryptVersion = encryptVersion;
            return this;
        }

        public DorisSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public DorisSinkDTO build() {
            return new DorisSinkDTO(this.feNodes, this.username, this.password, this.tableIdentifier, this.labelPrefix, this.primaryKey, this.sinkMultipleEnable, this.sinkMultipleFormat, this.databasePattern, this.tablePattern, this.encryptVersion, this.properties);
        }

        public String toString() {
            return "DorisSinkDTO.DorisSinkDTOBuilder(feNodes=" + this.feNodes + ", username=" + this.username + ", password=" + this.password + ", tableIdentifier=" + this.tableIdentifier + ", labelPrefix=" + this.labelPrefix + ", primaryKey=" + this.primaryKey + ", sinkMultipleEnable=" + this.sinkMultipleEnable + ", sinkMultipleFormat=" + this.sinkMultipleFormat + ", databasePattern=" + this.databasePattern + ", tablePattern=" + this.tablePattern + ", encryptVersion=" + this.encryptVersion + ", properties=" + this.properties + ")";
        }
    }
}

