/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.pulsar.PulsarSinkRequest;

@ApiModel(value="Pulsar sink info")
@JsonTypeDefine(value="PULSAR")
public class PulsarSink
extends StreamSink {
    @ApiModelProperty(value="Pulsar service url")
    private String serviceUrl;
    @ApiModelProperty(value="Pulsar tenant")
    private String pulsarTenant;
    @ApiModelProperty(value="Pulsar namespace")
    private String namespace;
    @ApiModelProperty(value="Pulsar topic")
    private String topic;
    @ApiModelProperty(value="Pulsar token")
    private String token;
    @ApiModelProperty(value="Admin url")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar partition number")
    private Integer partitionNum;

    public PulsarSink() {
        this.setSinkType("PULSAR");
    }

    @Override
    public SinkRequest genSinkRequest() {
        return (SinkRequest)CommonBeanUtils.copyProperties((Object)this, PulsarSinkRequest::new);
    }

    protected PulsarSink(PulsarSinkBuilder<?, ?> b) {
        super((StreamSink.StreamSinkBuilder<?, ?>)b);
        this.serviceUrl = ((PulsarSinkBuilder)b).serviceUrl;
        this.pulsarTenant = ((PulsarSinkBuilder)b).pulsarTenant;
        this.namespace = ((PulsarSinkBuilder)b).namespace;
        this.topic = ((PulsarSinkBuilder)b).topic;
        this.token = ((PulsarSinkBuilder)b).token;
        this.adminUrl = ((PulsarSinkBuilder)b).adminUrl;
        this.partitionNum = ((PulsarSinkBuilder)b).partitionNum;
    }

    public static PulsarSinkBuilder<?, ?> builder() {
        return new PulsarSinkBuilderImpl();
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getPulsarTenant() {
        return this.pulsarTenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getToken() {
        return this.token;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public Integer getPartitionNum() {
        return this.partitionNum;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setPulsarTenant(String pulsarTenant) {
        this.pulsarTenant = pulsarTenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setPartitionNum(Integer partitionNum) {
        this.partitionNum = partitionNum;
    }

    public PulsarSink(String serviceUrl, String pulsarTenant, String namespace, String topic, String token, String adminUrl, Integer partitionNum) {
        this.serviceUrl = serviceUrl;
        this.pulsarTenant = pulsarTenant;
        this.namespace = namespace;
        this.topic = topic;
        this.token = token;
        this.adminUrl = adminUrl;
        this.partitionNum = partitionNum;
    }

    @Override
    public String toString() {
        return "PulsarSink(super=" + super.toString() + ", serviceUrl=" + this.getServiceUrl() + ", pulsarTenant=" + this.getPulsarTenant() + ", namespace=" + this.getNamespace() + ", topic=" + this.getTopic() + ", token=" + this.getToken() + ", adminUrl=" + this.getAdminUrl() + ", partitionNum=" + this.getPartitionNum() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarSink)) {
            return false;
        }
        PulsarSink other = (PulsarSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitionNum = this.getPartitionNum();
        Integer other$partitionNum = other.getPartitionNum();
        if (this$partitionNum == null ? other$partitionNum != null : !((Object)this$partitionNum).equals(other$partitionNum)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$pulsarTenant = this.getPulsarTenant();
        String other$pulsarTenant = other.getPulsarTenant();
        if (this$pulsarTenant == null ? other$pulsarTenant != null : !this$pulsarTenant.equals(other$pulsarTenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        return !(this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarSink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitionNum = this.getPartitionNum();
        result = result * 59 + ($partitionNum == null ? 43 : ((Object)$partitionNum).hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $pulsarTenant = this.getPulsarTenant();
        result = result * 59 + ($pulsarTenant == null ? 43 : $pulsarTenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        return result;
    }

    private static final class PulsarSinkBuilderImpl
    extends PulsarSinkBuilder<PulsarSink, PulsarSinkBuilderImpl> {
        private PulsarSinkBuilderImpl() {
        }

        @Override
        protected PulsarSinkBuilderImpl self() {
            return this;
        }

        @Override
        public PulsarSink build() {
            return new PulsarSink(this);
        }
    }

    public static abstract class PulsarSinkBuilder<C extends PulsarSink, B extends PulsarSinkBuilder<C, B>>
    extends StreamSink.StreamSinkBuilder<C, B> {
        private String serviceUrl;
        private String pulsarTenant;
        private String namespace;
        private String topic;
        private String token;
        private String adminUrl;
        private Integer partitionNum;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return (B)this.self();
        }

        public B pulsarTenant(String pulsarTenant) {
            this.pulsarTenant = pulsarTenant;
            return (B)this.self();
        }

        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        public B topic(String topic) {
            this.topic = topic;
            return (B)this.self();
        }

        public B token(String token) {
            this.token = token;
            return (B)this.self();
        }

        public B adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return (B)this.self();
        }

        public B partitionNum(Integer partitionNum) {
            this.partitionNum = partitionNum;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PulsarSink.PulsarSinkBuilder(super=" + super.toString() + ", serviceUrl=" + this.serviceUrl + ", pulsarTenant=" + this.pulsarTenant + ", namespace=" + this.namespace + ", topic=" + this.topic + ", token=" + this.token + ", adminUrl=" + this.adminUrl + ", partitionNum=" + this.partitionNum + ")";
        }
    }
}

