/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.base;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sort.node.base.NodeProvider;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.formats.common.StringTypeInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.CanalJsonFormat;
import org.apache.inlong.sort.protocol.node.format.DebeziumJsonFormat;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;
import org.apache.inlong.sort.protocol.transformation.function.CustomFunction;

public interface LoadNodeProvider
extends NodeProvider {
    public LoadNode createLoadNode(StreamNode var1, Map<String, StreamField> var2);

    default public List<FieldInfo> parseSinkFieldInfos(List<SinkField> sinkFields, String nodeId) {
        return this.parseSinkFieldInfos(sinkFields, nodeId, null);
    }

    default public List<FieldInfo> parseSinkFieldInfos(List<SinkField> sinkFields, String nodeId, FieldTypeMappingStrategy fieldTypeMappingStrategy) {
        return sinkFields.stream().map(field -> FieldInfoUtils.parseSinkFieldInfo(field, nodeId, fieldTypeMappingStrategy)).collect(Collectors.toList());
    }

    default public List<FieldRelation> parseSinkFields(List<SinkField> fieldList, Map<String, StreamField> constantFieldMap) {
        if (CollectionUtils.isEmpty(fieldList)) {
            return Lists.newArrayList();
        }
        return fieldList.stream().filter(sinkField -> StringUtils.isNotEmpty((CharSequence)sinkField.getSourceFieldName())).map(field -> {
            FieldInfo outputField = new FieldInfo(field.getFieldName(), FieldInfoUtils.convertFieldFormat(field.getFieldType(), field.getFieldFormat()));
            String fieldKey = String.format("%s-%s", field.getOriginNodeName(), field.getSourceFieldName());
            StreamField constantField = (StreamField)constantFieldMap.get(fieldKey);
            Object inputField = constantField != null ? (outputField.getFormatInfo() != null && outputField.getFormatInfo().getTypeInfo() == StringTypeInfo.INSTANCE ? new StringConstantParam(constantField.getFieldValue()) : new ConstantParam((Object)constantField.getFieldValue())) : (FieldType.FUNCTION.name().equalsIgnoreCase(field.getSourceFieldType()) ? new CustomFunction(field.getSourceFieldName()) : new FieldInfo(field.getSourceFieldName(), field.getOriginNodeName(), FieldInfoUtils.convertFieldFormat(field.getSourceFieldType())));
            return new FieldRelation((FunctionParam)inputField, outputField);
        }).collect(Collectors.toList());
    }

    default public Format parsingSinkMultipleFormat(Boolean multipleEnable, String multipleFormat) {
        CanalJsonFormat format = null;
        if (Boolean.TRUE.equals(multipleEnable) && StringUtils.isNotBlank((CharSequence)multipleFormat)) {
            DataTypeEnum dataType = DataTypeEnum.forType((String)multipleFormat);
            switch (dataType) {
                case CANAL: {
                    format = new CanalJsonFormat();
                    break;
                }
                case DEBEZIUM_JSON: {
                    format = new DebeziumJsonFormat();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported dataType=%s", dataType));
                }
            }
        }
        return format;
    }

    default public List<SinkField> addSinkMetaFields(List<SinkField> sinkFields) {
        return sinkFields;
    }
}

