/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.pulsar.PulsarSourceRequest;

@ApiModel(value="Pulsar source info")
@JsonTypeDefine(value="PULSAR")
public class PulsarSource
extends StreamSource {
    @ApiModelProperty(value="Pulsar tenant")
    private String pulsarTenant;
    @ApiModelProperty(value="Pulsar namespace")
    private String namespace;
    @ApiModelProperty(value="Pulsar topic")
    private String topic;
    @ApiModelProperty(value="Pulsar subscription")
    private String subscription;
    @ApiModelProperty(value="Pulsar adminUrl")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar serviceUrl")
    private String serviceUrl;
    @ApiModelProperty(value="Primary key, needed when serialization type is csv, json, avro")
    private String primaryKey;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="Data field escape symbol")
    private String dataEscapeChar;
    @ApiModelProperty(value="Configure the Source's startup mode. Available options are earliest, latest, external-subscription, and specific-offsets.")
    private String scanStartupMode;
    private boolean isInlongComponent;
    @ApiModelProperty(value="Whether wrap content with InlongMsg")
    private boolean wrapWithInlongMsg;

    public PulsarSource() {
        this.setSourceType("PULSAR");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, PulsarSourceRequest::new);
    }

    private static String $default$pulsarTenant() {
        return "public";
    }

    private static String $default$scanStartupMode() {
        return "earliest";
    }

    private static boolean $default$isInlongComponent() {
        return false;
    }

    private static boolean $default$wrapWithInlongMsg() {
        return true;
    }

    protected PulsarSource(PulsarSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.pulsarTenant = ((PulsarSourceBuilder)b).pulsarTenant$set ? ((PulsarSourceBuilder)b).pulsarTenant$value : PulsarSource.$default$pulsarTenant();
        this.namespace = ((PulsarSourceBuilder)b).namespace;
        this.topic = ((PulsarSourceBuilder)b).topic;
        this.subscription = ((PulsarSourceBuilder)b).subscription;
        this.adminUrl = ((PulsarSourceBuilder)b).adminUrl;
        this.serviceUrl = ((PulsarSourceBuilder)b).serviceUrl;
        this.primaryKey = ((PulsarSourceBuilder)b).primaryKey;
        this.dataEncoding = ((PulsarSourceBuilder)b).dataEncoding;
        this.dataSeparator = ((PulsarSourceBuilder)b).dataSeparator;
        this.dataEscapeChar = ((PulsarSourceBuilder)b).dataEscapeChar;
        this.scanStartupMode = ((PulsarSourceBuilder)b).scanStartupMode$set ? ((PulsarSourceBuilder)b).scanStartupMode$value : PulsarSource.$default$scanStartupMode();
        this.isInlongComponent = ((PulsarSourceBuilder)b).isInlongComponent$set ? ((PulsarSourceBuilder)b).isInlongComponent$value : PulsarSource.$default$isInlongComponent();
        this.wrapWithInlongMsg = ((PulsarSourceBuilder)b).wrapWithInlongMsg$set ? ((PulsarSourceBuilder)b).wrapWithInlongMsg$value : PulsarSource.$default$wrapWithInlongMsg();
    }

    public static PulsarSourceBuilder<?, ?> builder() {
        return new PulsarSourceBuilderImpl();
    }

    public String getPulsarTenant() {
        return this.pulsarTenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public boolean isInlongComponent() {
        return this.isInlongComponent;
    }

    public boolean isWrapWithInlongMsg() {
        return this.wrapWithInlongMsg;
    }

    public void setPulsarTenant(String pulsarTenant) {
        this.pulsarTenant = pulsarTenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setInlongComponent(boolean isInlongComponent) {
        this.isInlongComponent = isInlongComponent;
    }

    public void setWrapWithInlongMsg(boolean wrapWithInlongMsg) {
        this.wrapWithInlongMsg = wrapWithInlongMsg;
    }

    public PulsarSource(String pulsarTenant, String namespace, String topic, String subscription, String adminUrl, String serviceUrl, String primaryKey, String dataEncoding, String dataSeparator, String dataEscapeChar, String scanStartupMode, boolean isInlongComponent, boolean wrapWithInlongMsg) {
        this.pulsarTenant = pulsarTenant;
        this.namespace = namespace;
        this.topic = topic;
        this.subscription = subscription;
        this.adminUrl = adminUrl;
        this.serviceUrl = serviceUrl;
        this.primaryKey = primaryKey;
        this.dataEncoding = dataEncoding;
        this.dataSeparator = dataSeparator;
        this.dataEscapeChar = dataEscapeChar;
        this.scanStartupMode = scanStartupMode;
        this.isInlongComponent = isInlongComponent;
        this.wrapWithInlongMsg = wrapWithInlongMsg;
    }

    @Override
    public String toString() {
        return "PulsarSource(super=" + super.toString() + ", pulsarTenant=" + this.getPulsarTenant() + ", namespace=" + this.getNamespace() + ", topic=" + this.getTopic() + ", subscription=" + this.getSubscription() + ", adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", primaryKey=" + this.getPrimaryKey() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ", scanStartupMode=" + this.getScanStartupMode() + ", isInlongComponent=" + this.isInlongComponent() + ", wrapWithInlongMsg=" + this.isWrapWithInlongMsg() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarSource)) {
            return false;
        }
        PulsarSource other = (PulsarSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isInlongComponent() != other.isInlongComponent()) {
            return false;
        }
        if (this.isWrapWithInlongMsg() != other.isWrapWithInlongMsg()) {
            return false;
        }
        String this$pulsarTenant = this.getPulsarTenant();
        String other$pulsarTenant = other.getPulsarTenant();
        if (this$pulsarTenant == null ? other$pulsarTenant != null : !this$pulsarTenant.equals(other$pulsarTenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        if (this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        return !(this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isInlongComponent() ? 79 : 97);
        result = result * 59 + (this.isWrapWithInlongMsg() ? 79 : 97);
        String $pulsarTenant = this.getPulsarTenant();
        result = result * 59 + ($pulsarTenant == null ? 43 : $pulsarTenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        return result;
    }

    private static final class PulsarSourceBuilderImpl
    extends PulsarSourceBuilder<PulsarSource, PulsarSourceBuilderImpl> {
        private PulsarSourceBuilderImpl() {
        }

        @Override
        protected PulsarSourceBuilderImpl self() {
            return this;
        }

        @Override
        public PulsarSource build() {
            return new PulsarSource(this);
        }
    }

    public static abstract class PulsarSourceBuilder<C extends PulsarSource, B extends PulsarSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private boolean pulsarTenant$set;
        private String pulsarTenant$value;
        private String namespace;
        private String topic;
        private String subscription;
        private String adminUrl;
        private String serviceUrl;
        private String primaryKey;
        private String dataEncoding;
        private String dataSeparator;
        private String dataEscapeChar;
        private boolean scanStartupMode$set;
        private String scanStartupMode$value;
        private boolean isInlongComponent$set;
        private boolean isInlongComponent$value;
        private boolean wrapWithInlongMsg$set;
        private boolean wrapWithInlongMsg$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B pulsarTenant(String pulsarTenant) {
            this.pulsarTenant$value = pulsarTenant;
            this.pulsarTenant$set = true;
            return (B)this.self();
        }

        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        public B topic(String topic) {
            this.topic = topic;
            return (B)this.self();
        }

        public B subscription(String subscription) {
            this.subscription = subscription;
            return (B)this.self();
        }

        public B adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return (B)this.self();
        }

        public B serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        public B dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return (B)this.self();
        }

        public B dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return (B)this.self();
        }

        public B dataEscapeChar(String dataEscapeChar) {
            this.dataEscapeChar = dataEscapeChar;
            return (B)this.self();
        }

        public B scanStartupMode(String scanStartupMode) {
            this.scanStartupMode$value = scanStartupMode;
            this.scanStartupMode$set = true;
            return (B)this.self();
        }

        public B isInlongComponent(boolean isInlongComponent) {
            this.isInlongComponent$value = isInlongComponent;
            this.isInlongComponent$set = true;
            return (B)this.self();
        }

        public B wrapWithInlongMsg(boolean wrapWithInlongMsg) {
            this.wrapWithInlongMsg$value = wrapWithInlongMsg;
            this.wrapWithInlongMsg$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PulsarSource.PulsarSourceBuilder(super=" + super.toString() + ", pulsarTenant$value=" + this.pulsarTenant$value + ", namespace=" + this.namespace + ", topic=" + this.topic + ", subscription=" + this.subscription + ", adminUrl=" + this.adminUrl + ", serviceUrl=" + this.serviceUrl + ", primaryKey=" + this.primaryKey + ", dataEncoding=" + this.dataEncoding + ", dataSeparator=" + this.dataSeparator + ", dataEscapeChar=" + this.dataEscapeChar + ", scanStartupMode$value=" + this.scanStartupMode$value + ", isInlongComponent$value=" + this.isInlongComponent$value + ", wrapWithInlongMsg$value=" + this.wrapWithInlongMsg$value + ")";
        }
    }
}

