/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.workflow.form.process;

import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.exceptions.FormValidateException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.BaseProcessForm;

public class ApplyGroupProcessForm
extends BaseProcessForm {
    public static final String FORM_NAME = "ApplyGroupProcessForm";
    @ApiModelProperty(value="Inlong group info", required=true)
    private InlongGroupInfo groupInfo;
    @ApiModelProperty(value="All inlong stream info under the inlong group, including the sink info")
    private List<InlongStreamBriefInfo> streamInfoList;

    @Override
    public void validate() throws FormValidateException {
        Preconditions.expectNotNull((Object)this.groupInfo, (String)"inlong group info is empty");
    }

    @Override
    public String getFormName() {
        return FORM_NAME;
    }

    @Override
    public String getInlongGroupId() {
        return this.groupInfo.getInlongGroupId();
    }

    @Override
    public Map<String, Object> showInList() {
        HashMap show = Maps.newHashMap();
        show.put("inlongGroupId", this.groupInfo.getInlongGroupId());
        show.put("inlongGroupMode", this.groupInfo.getInlongGroupMode());
        return show;
    }

    public InlongGroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public List<InlongStreamBriefInfo> getStreamInfoList() {
        return this.streamInfoList;
    }

    public void setGroupInfo(InlongGroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public void setStreamInfoList(List<InlongStreamBriefInfo> streamInfoList) {
        this.streamInfoList = streamInfoList;
    }

    @Override
    public String toString() {
        return "ApplyGroupProcessForm(groupInfo=" + this.getGroupInfo() + ", streamInfoList=" + this.getStreamInfoList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplyGroupProcessForm)) {
            return false;
        }
        ApplyGroupProcessForm other = (ApplyGroupProcessForm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlongGroupInfo this$groupInfo = this.getGroupInfo();
        InlongGroupInfo other$groupInfo = other.getGroupInfo();
        if (this$groupInfo == null ? other$groupInfo != null : !((Object)this$groupInfo).equals(other$groupInfo)) {
            return false;
        }
        List<InlongStreamBriefInfo> this$streamInfoList = this.getStreamInfoList();
        List<InlongStreamBriefInfo> other$streamInfoList = other.getStreamInfoList();
        return !(this$streamInfoList == null ? other$streamInfoList != null : !((Object)this$streamInfoList).equals(other$streamInfoList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApplyGroupProcessForm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlongGroupInfo $groupInfo = this.getGroupInfo();
        result = result * 59 + ($groupInfo == null ? 43 : ((Object)$groupInfo).hashCode());
        List<InlongStreamBriefInfo> $streamInfoList = this.getStreamInfoList();
        result = result * 59 + ($streamInfoList == null ? 43 : ((Object)$streamInfoList).hashCode());
        return result;
    }
}

