/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.beans.ClusterBean;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.business.BusinessApproveInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessCountVO;
import org.apache.inlong.manager.common.pojo.business.BusinessExtInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.business.BusinessListVO;
import org.apache.inlong.manager.common.pojo.business.BusinessPageRequest;
import org.apache.inlong.manager.common.pojo.business.BusinessTopicVO;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.BusinessExtEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.BusinessExtEntityMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessServiceImpl
implements BusinessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessServiceImpl.class);
    @Autowired
    private BusinessEntityMapper businessMapper;
    @Autowired
    private BusinessExtEntityMapper businessExtMapper;
    @Autowired
    private ClusterBean clusterBean;
    @Autowired
    private DataStreamService streamService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public String save(BusinessInfo businessInfo, String operator) {
        LOGGER.debug("begin to save business info={}", (Object)businessInfo);
        Preconditions.checkNotNull((Object)businessInfo, (String)"business info is empty");
        String bizName = businessInfo.getName();
        Preconditions.checkNotNull((Object)bizName, (String)"business name is empty");
        String topic = bizName.toLowerCase(Locale.ROOT);
        String bid = "b_" + topic;
        Integer count = this.businessMapper.selectIdentifierExist(bid);
        if (count >= 1) {
            LOGGER.error("bid [{}] has already exists", (Object)bid);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_DUPLICATE);
        }
        BusinessEntity entity = (BusinessEntity)CommonBeanUtils.copyProperties((Object)businessInfo, BusinessEntity::new);
        entity.setBusinessIdentifier(bid);
        entity.setMqResourceObj(topic);
        entity.setSchemaName("m0_day");
        entity.setStatus(EntityStatus.BIZ_WAIT_SUBMIT.getCode());
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setCreateTime(new Date());
        this.businessMapper.insertSelective(entity);
        this.saveExt(bid, businessInfo.getExtList());
        LOGGER.info("success to save business info");
        return bid;
    }

    @Override
    public BusinessInfo get(String identifier) {
        LOGGER.debug("begin to get business info by bid={}", (Object)identifier);
        Preconditions.checkNotNull((Object)identifier, (String)"businessIdentifier is empty");
        BusinessEntity entity = this.businessMapper.selectByIdentifier(identifier);
        if (entity == null) {
            LOGGER.error("business not found by bid={}", (Object)identifier);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_NOT_FOUND);
        }
        BusinessInfo businessInfo = (BusinessInfo)CommonBeanUtils.copyProperties((Object)entity, BusinessInfo::new);
        List extEntityList = this.businessExtMapper.selectByBusinessIdentifier(identifier);
        List extInfoList = CommonBeanUtils.copyListProperties((List)extEntityList, BusinessExtInfo::new);
        businessInfo.setExtList(extInfoList);
        LOGGER.info("success to get business info");
        return businessInfo;
    }

    @Override
    public PageInfo<BusinessListVO> listByCondition(BusinessPageRequest request) {
        LOGGER.debug("begin to list business info by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.businessMapper.selectByCondition(request);
        List businessList = CommonBeanUtils.copyListProperties((List)entityPage, BusinessListVO::new);
        PageInfo page = new PageInfo(businessList);
        page.setTotal(entityPage.getTotal());
        LOGGER.info("success to list business info");
        return page;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public String update(BusinessInfo businessInfo, String operator) {
        LOGGER.debug("begin to update business info={}", (Object)businessInfo);
        Preconditions.checkNotNull((Object)businessInfo, (String)"business info is empty");
        String bid = businessInfo.getBusinessIdentifier();
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        BusinessEntity entity = this.businessMapper.selectByIdentifier(bid);
        if (entity == null) {
            LOGGER.error("business not found by bid={}", (Object)bid);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_NOT_FOUND);
        }
        this.checkBizCanUpdate(entity, businessInfo);
        CommonBeanUtils.copyProperties((Object)businessInfo, (Object)entity, (boolean)true);
        if (EntityStatus.BIZ_CONFIG_FAILED.getCode().equals(entity.getStatus())) {
            entity.setStatus(EntityStatus.BIZ_WAIT_SUBMIT.getCode());
        }
        entity.setModifier(operator);
        this.businessMapper.updateByIdentifierSelective(entity);
        this.updateExt(bid, businessInfo.getExtList());
        LOGGER.info("success to update business info");
        return bid;
    }

    private void checkBizCanUpdate(BusinessEntity entity, BusinessInfo businessInfo) {
        boolean updateBid;
        if (entity == null || businessInfo == null) {
            return;
        }
        Integer oldStatus = entity.getStatus();
        if (!EntityStatus.ALLOW_UPDATE_BIZ_STATUS.contains(oldStatus)) {
            LOGGER.error("current status was not allowed to update");
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_UPDATE_NOT_ALLOWED);
        }
        boolean bl = updateBid = !EntityStatus.DRAFT.getCode().equals(oldStatus) && !Objects.equals(entity.getBusinessIdentifier(), businessInfo.getBusinessIdentifier());
        if (updateBid) {
            LOGGER.error("current status was not allowed to update business identifier");
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_BID_UPDATE_NOT_ALLOWED);
        }
        if (EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode().equals(oldStatus)) {
            if (!Objects.equals(entity.getBusinessIdentifier(), businessInfo.getBusinessIdentifier())) {
                LOGGER.error("current status was not allowed to update business identifier");
                throw new BusinessException(BizErrorCodeEnum.BUSINESS_BID_UPDATE_NOT_ALLOWED);
            }
            if (!Objects.equals(entity.getMiddlewareType(), businessInfo.getMiddlewareType())) {
                LOGGER.error("current status was not allowed to update middleware type");
                throw new BusinessException(BizErrorCodeEnum.BUSINESS_MIDDLEWARE_UPDATE_NOT_ALLOWED);
            }
        }
    }

    @Override
    public boolean updateStatus(String bid, Integer status, String operator) {
        LOGGER.debug("begin to update business status, bid={}, status={}, username={}", new Object[]{bid, status, operator});
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        this.businessMapper.updateStatusByIdentifier(bid, status, operator);
        LOGGER.info("success to update business status");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean delete(String bid, String operator) {
        LOGGER.debug("begin to delete business, bid={}", (Object)bid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        BusinessEntity entity = this.businessMapper.selectByIdentifier(bid);
        if (entity == null) {
            LOGGER.error("business not found by bid={}", (Object)bid);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_NOT_FOUND);
        }
        if (!EntityStatus.ALLOW_DELETE_BIZ_STATUS.contains(entity.getStatus())) {
            LOGGER.error("current status was not allowed to delete");
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_DELETE_NOT_ALLOWED);
        }
        if (EntityStatus.ALLOW_DELETE_BIZ_CASCADE_STATUS.contains(entity.getStatus())) {
            this.streamService.logicDeleteAllByBid(entity.getBusinessIdentifier(), operator);
        } else {
            int count = this.streamService.selectCountByBid(bid);
            if (count >= 1) {
                LOGGER.error("bid={} have [{}] data streams, deleted failed", (Object)bid, (Object)count);
                throw new BusinessException(BizErrorCodeEnum.BUSINESS_HAS_DATA_STREAM);
            }
        }
        entity.setIsDeleted(EntityStatus.IS_DELETED.getCode());
        entity.setStatus(EntityStatus.DELETED.getCode());
        entity.setModifier(operator);
        this.businessMapper.updateByIdentifierSelective(entity);
        LOGGER.debug("begin to delete business ext property, bid={}", (Object)bid);
        this.businessExtMapper.logicDeleteAllByBid(bid);
        LOGGER.info("success to delete business and business ext property");
        return true;
    }

    @Override
    public boolean exist(String bid) {
        LOGGER.debug("begin to check business, bid={}", (Object)bid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Integer count = this.businessMapper.selectIdentifierExist(bid);
        LOGGER.info("success to check business");
        return count >= 1;
    }

    @Override
    public BusinessCountVO countBusinessByUser(String operator) {
        LOGGER.debug("begin to count business by user={}", (Object)operator);
        BusinessCountVO countVO = new BusinessCountVO();
        List statusCount = this.businessMapper.countCurrentUserBusiness(operator);
        for (Map map : statusCount) {
            int status = (Integer)map.get("status");
            long count = (Long)map.get("count");
            countVO.setTotalCount(countVO.getTotalCount() + count);
            if (status == EntityStatus.BIZ_CONFIG_ING.getCode()) {
                countVO.setWaitAssignCount(countVO.getWaitAssignCount() + count);
                continue;
            }
            if (status == EntityStatus.BIZ_WAIT_APPROVAL.getCode()) {
                countVO.setWaitApproveCount(countVO.getWaitApproveCount() + count);
                continue;
            }
            if (status != EntityStatus.BIZ_APPROVE_REJECTED.getCode()) continue;
            countVO.setRejectCount(countVO.getRejectCount() + count);
        }
        LOGGER.info("success to count business");
        return countVO;
    }

    @Override
    public BusinessTopicVO getTopic(String bid) {
        LOGGER.debug("begin to get topic by bid={}", (Object)bid);
        BusinessInfo businessInfo = this.get(bid);
        String middlewareType = businessInfo.getMiddlewareType();
        BusinessTopicVO topicVO = new BusinessTopicVO();
        if (!"TUBE".equalsIgnoreCase(middlewareType)) {
            LOGGER.error("middlewareType={} not supported", (Object)middlewareType);
            throw new BusinessException(BizErrorCodeEnum.MIDDLEWARE_TYPE_NOT_SUPPORTED);
        }
        topicVO.setTopicName(businessInfo.getMqResourceObj());
        topicVO.setMasterUrl(this.clusterBean.getTubeMaster());
        topicVO.setBusinessIdentifier(bid);
        topicVO.setMiddlewareType(middlewareType);
        return topicVO;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean updateAfterApprove(BusinessApproveInfo approveInfo, String operator) {
        LOGGER.debug("begin to update business after approve={}", (Object)approveInfo);
        Preconditions.checkNotNull((Object)approveInfo, (String)"BusinessApproveInfo is empty");
        String bid = approveInfo.getBusinessIdentifier();
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        this.updateStatus(bid, EntityStatus.BIZ_CONFIG_ING.getCode(), operator);
        LOGGER.info("success to update business status after approve");
        return true;
    }

    @Transactional(rollbackFor={Throwable.class})
    void updateExt(String bid, List<BusinessExtInfo> extInfoList) {
        LOGGER.debug("begin to update business ext, bid={}, ext={}", (Object)bid, extInfoList);
        try {
            this.businessExtMapper.deleteAllByBid(bid);
            this.saveExt(bid, extInfoList);
            LOGGER.info("success to update business ext");
        }
        catch (Exception e) {
            LOGGER.error("failed to update business ext: ", (Throwable)e);
            throw new BusinessException(BizErrorCodeEnum.BUSINESS_SAVE_FAILED);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    void saveExt(String bid, List<BusinessExtInfo> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        List entityList = CommonBeanUtils.copyListProperties(infoList, BusinessExtEntity::new);
        Date date = new Date();
        for (BusinessExtEntity entity : entityList) {
            entity.setBusinessIdentifier(bid);
            entity.setModifyTime(date);
        }
        this.businessExtMapper.insertAll(entityList);
    }
}

