/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.newbusiness;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.dao.entity.DataStreamEntity;
import org.apache.inlong.manager.dao.mapper.DataStreamEntityMapper;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.thirdpart.hive.CreateHiveTableForAllStreamListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreateTubeConsumeGroupTaskEventListener;
import org.apache.inlong.manager.service.thirdpart.mq.CreateTubeTopicTaskEventListener;
import org.apache.inlong.manager.service.thirdpart.sort.PushHiveConfigToSortEventListener;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.newbusiness.CreateResourceWorkflowForm;
import org.apache.inlong.manager.service.workflow.newbusiness.listener.CreateResourceCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.newbusiness.listener.CreateResourceFailedProcessListener;
import org.apache.inlong.manager.service.workflow.newbusiness.listener.InitBusinessInfoListener;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.model.definition.Element;
import org.apache.inlong.manager.workflow.model.definition.EndEvent;
import org.apache.inlong.manager.workflow.model.definition.Process;
import org.apache.inlong.manager.workflow.model.definition.ServiceTask;
import org.apache.inlong.manager.workflow.model.definition.StartEvent;
import org.apache.inlong.manager.workflow.model.definition.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateResourceWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateResourceWorkflowDefinition.class);
    @Autowired
    private InitBusinessInfoListener initBusinessInfoListener;
    @Autowired
    private CreateResourceCompleteProcessListener createResourceCompleteProcessListener;
    @Autowired
    private CreateResourceFailedProcessListener createResourceFailedProcessListener;
    @Autowired
    private CreateTubeTopicTaskEventListener createTubeTopicTaskEventListener;
    @Autowired
    private CreateTubeConsumeGroupTaskEventListener createTubeConsumeGroupTaskEventListener;
    @Autowired
    private CreateHiveTableForAllStreamListener createHiveTableForAllStreamListener;
    @Autowired
    private PushHiveConfigToSortEventListener pushHiveConfigToSortEventListener;
    @Autowired
    private StorageService storageService;
    @Autowired
    private DataStreamEntityMapper streamMapper;

    @Override
    public Process defineProcess() {
        Process process = new Process();
        process.addListener((ProcessEventListener)this.initBusinessInfoListener);
        process.addListener((ProcessEventListener)this.createResourceCompleteProcessListener);
        process.addListener((ProcessEventListener)this.createResourceFailedProcessListener);
        process.setType("Business Resource Creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(CreateResourceWorkflowForm.class);
        process.setVersion(1);
        process.setHidden(Boolean.valueOf(true));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        ServiceTask createTubeTopicTask = new ServiceTask();
        createTubeTopicTask.setSkipResolver(c -> {
            CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)c.getProcessForm();
            BusinessInfo businessInfo = form.getBusinessInfo();
            if ("TUBE".equalsIgnoreCase(businessInfo.getMiddlewareType())) {
                return false;
            }
            log.warn("not need to create tube resource for bid={}, as the middleware type is {}", (Object)businessInfo.getMiddlewareType(), (Object)form.getBusinessId());
            return true;
        });
        createTubeTopicTask.setName("createTubeTopic");
        createTubeTopicTask.setDisplayName("Create Tube Topic");
        createTubeTopicTask.addListener((TaskEventListener)this.createTubeTopicTaskEventListener);
        process.addTask((Task)createTubeTopicTask);
        ServiceTask createConsumerGroupForSortTask = new ServiceTask();
        createConsumerGroupForSortTask.setSkipResolver(c -> {
            CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)c.getProcessForm();
            BusinessInfo businessInfo = form.getBusinessInfo();
            if ("TUBE".equalsIgnoreCase(businessInfo.getMiddlewareType())) {
                return false;
            }
            log.warn("no need to create tube resource for bid={}, as the middleware type is {}", (Object)form.getBusinessId(), (Object)businessInfo.getMiddlewareType());
            return true;
        });
        createConsumerGroupForSortTask.setName("createConsumerGroupForSort");
        createConsumerGroupForSortTask.setDisplayName("Create Consumer Group For Sort");
        createConsumerGroupForSortTask.addListener((TaskEventListener)this.createTubeConsumeGroupTaskEventListener);
        process.addTask((Task)createConsumerGroupForSortTask);
        ServiceTask createHiveTablesTask = new ServiceTask();
        createHiveTablesTask.setSkipResolver(c -> {
            CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)c.getProcessForm();
            List<String> dsForHive = this.storageService.filterStreamIdByStorageType(form.getBusinessId(), "HIVE", this.streamMapper.selectByBid(form.getBusinessId()).stream().map(DataStreamEntity::getDataStreamIdentifier).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty(dsForHive)) {
                log.warn("business {} dataStream {} does not have storage, skip to create hive table ", (Object)form.getBusinessId(), (Object)form.getDataStreamIdentifier());
                return true;
            }
            return false;
        });
        createHiveTablesTask.setName("createHiveTableTask");
        createHiveTablesTask.setDisplayName("Create Hive Table");
        createHiveTablesTask.addListener((TaskEventListener)this.createHiveTableForAllStreamListener);
        process.addTask((Task)createHiveTablesTask);
        ServiceTask pushSortConfig = new ServiceTask();
        pushSortConfig.setName("pushSortConfig");
        pushSortConfig.setDisplayName("Push Sort Config");
        pushSortConfig.addListener((TaskEventListener)this.pushHiveConfigToSortEventListener);
        process.addTask((Task)pushSortConfig);
        startEvent.addNext((Element)createTubeTopicTask);
        createTubeTopicTask.addNext((Element)createConsumerGroupForSortTask);
        createConsumerGroupForSortTask.addNext((Element)createHiveTablesTask);
        createHiveTablesTask.addNext((Element)pushSortConfig);
        pushSortConfig.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_BUSINESS_RESOURCE;
    }
}

