/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.newstream;

import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.core.DataStreamService;
import org.apache.inlong.manager.service.workflow.newbusiness.CreateResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.core.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SingleStreamCompleteProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(SingleStreamCompleteProcessListener.class);
    @Autowired
    private BusinessService businessService;
    @Autowired
    private DataStreamService dataStreamService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)context.getProcessForm();
        String bid = form.getBusinessId();
        String dsid = form.getDataStreamIdentifier();
        String username = context.getApplicant();
        this.businessService.updateStatus(bid, EntityStatus.BIZ_CONFIG_SUCCESSFUL.getCode(), username);
        this.dataStreamService.updateStatus(bid, dsid, EntityStatus.DATA_STREAM_CONFIG_SUCCESSFUL.getCode(), username);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

