/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.FileAgentDataGenerateRule;
import org.apache.inlong.manager.common.pojo.agent.AgentStatusReportRequest;
import org.apache.inlong.manager.common.pojo.agent.CheckAgentTaskConfRequest;
import org.apache.inlong.manager.common.pojo.agent.ConfirmAgentIpRequest;
import org.apache.inlong.manager.common.pojo.agent.FileAgentCMDConfig;
import org.apache.inlong.manager.common.pojo.agent.FileAgentCommandInfo;
import org.apache.inlong.manager.common.pojo.agent.FileAgentTaskConfig;
import org.apache.inlong.manager.common.pojo.agent.FileAgentTaskInfo;
import org.apache.inlong.manager.dao.entity.DataSourceCmdConfigEntity;
import org.apache.inlong.manager.dao.entity.DataStreamFieldEntity;
import org.apache.inlong.manager.dao.entity.SourceFileDetailEntity;
import org.apache.inlong.manager.dao.mapper.DataSourceCmdConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataStreamFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceFileDetailEntityMapper;
import org.apache.inlong.manager.service.core.AgentTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentTaskServiceImpl
implements AgentTaskService {
    private static final Logger log = LoggerFactory.getLogger(AgentTaskServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentTaskServiceImpl.class);
    @Autowired
    private SourceFileDetailEntityMapper sourceFileDetailEntityMapper;
    @Autowired
    private DataSourceCmdConfigEntityMapper dataSourceCmdConfigEntityMapper;
    @Autowired
    private DataStreamFieldEntityMapper dataStreamFieldEntityMapper;

    @Override
    public FileAgentTaskInfo getFileAgentTask(FileAgentCommandInfo info) {
        this.dealCommandResult(info);
        List<FileAgentTaskConfig> taskConfigs = this.getFileAgentTaskConfigs(info);
        List<FileAgentCMDConfig> cmdConfigs = this.getFileAgentCMDConfigs(info);
        FileAgentTaskInfo taskInfo = FileAgentTaskInfo.builder().cmdConfigs(cmdConfigs).dataConfigs(taskConfigs).build();
        return taskInfo;
    }

    private List<FileAgentCMDConfig> getFileAgentCMDConfigs(FileAgentCommandInfo info) {
        return this.dataSourceCmdConfigEntityMapper.queryCmdByAgentIp(info.getAgentIp()).stream().map(cmd -> {
            FileAgentCMDConfig cmdConfig = new FileAgentCMDConfig();
            cmdConfig.setDataTime(cmd.getSpecifiedDataTime());
            cmdConfig.setOp(cmd.getCmdType().intValue());
            cmdConfig.setId(cmd.getId().intValue());
            cmdConfig.setTaskId(cmd.getTaskId().intValue());
            return cmdConfig;
        }).collect(Collectors.toList());
    }

    private List<FileAgentTaskConfig> getFileAgentTaskConfigs(FileAgentCommandInfo info) {
        List taskConfigs = this.sourceFileDetailEntityMapper.selectFileAgentTaskByIp(info.getAgentIp());
        for (FileAgentTaskConfig config : taskConfigs) {
            FileAgentDataGenerateRule ruleEnu = FileAgentDataGenerateRule.fromRuleValue((String)config.getDataGenerateRule());
            if (ruleEnu != null) {
                config.setScheduleTime(ruleEnu.getScheduleRule());
            }
            StringBuilder s = new StringBuilder();
            s.append("m=").append(config.getSortType()).append("&");
            s.append("iname=").append(config.getDataStreamIdentifier()).append("&");
            if (config.getDataGenerateRule().equalsIgnoreCase("minute")) {
                s.append("p=t").append("&");
            }
            List preFields = this.dataStreamFieldEntityMapper.queryDataStreamPreFields(config.getBusinessIdentifier(), config.getDataStreamIdentifier());
            if (!config.getSortType().equalsIgnoreCase("13")) {
                int fIndex = 0;
                for (DataStreamFieldEntity f : preFields) {
                    s.append("__addcol" + fIndex + "__" + f.getFieldName());
                    s.append("=");
                    s.append(f.getFieldValue());
                    s.append("&");
                }
            }
            config.setAdditionalAttr(s.toString().substring(0, s.toString().length() - 1));
            int currentStatus = config.getStatus();
            if (currentStatus / 100 != 2) continue;
            int nextStatus = currentStatus % 100 + 300;
            SourceFileDetailEntity update = new SourceFileDetailEntity();
            update.setId(Integer.valueOf(config.getTaskId()));
            update.setStatus(Integer.valueOf(nextStatus));
            update.setPreviousStatus(Integer.valueOf(currentStatus));
            this.sourceFileDetailEntityMapper.updateByPrimaryKeySelective(update);
        }
        return taskConfigs;
    }

    private void dealCommandResult(FileAgentCommandInfo info) {
        if (CollectionUtils.isNotEmpty((Collection)info.getCommandInfo())) {
            List commandInfos = info.getCommandInfo();
            for (FileAgentCommandInfo.CommandInfoBean command : commandInfos) {
                SourceFileDetailEntity current = this.sourceFileDetailEntityMapper.selectByPrimaryKey(Integer.valueOf(command.getTaskId()));
                if (current == null) continue;
                int opType = command.getOpType();
                if (opType == 2 || opType == 6 || opType == 8) {
                    DataSourceCmdConfigEntity cmd = new DataSourceCmdConfigEntity();
                    if (command.getId() <= 0) continue;
                    cmd.setId(Integer.valueOf(command.getId()));
                    cmd.setBsend(Boolean.valueOf(true));
                    cmd.setModifyTime(new Date());
                    cmd.setResultInfo(String.valueOf(command.getCommandResult()));
                    this.dataSourceCmdConfigEntityMapper.updateByPrimaryKeySelective(cmd);
                    continue;
                }
                if (current.getModifyTime().getTime() - command.getDeliveryTime() > 5000L) {
                    log.warn(" task id {} receive heartbeat time delay more than 5's, skip it!", (Object)command.getTaskId());
                    continue;
                }
                int nextStatus = 101;
                if (current.getStatus() == null || current.getStatus() / 100 != 3) continue;
                if (command.getCommandResult() == 0) {
                    if (current.getStatus() == 300 || current.getStatus() == 305) {
                        nextStatus = 100;
                    } else if (current.getStatus() == 301) {
                        nextStatus = 101;
                    } else if (current.getStatus() == 304) {
                        nextStatus = 104;
                    }
                } else if (command.getCommandResult() == 1) {
                    nextStatus = 103;
                }
                SourceFileDetailEntity update = new SourceFileDetailEntity();
                update.setId(Integer.valueOf(command.getTaskId()));
                update.setStatus(Integer.valueOf(nextStatus));
                update.setPreviousStatus(current.getStatus());
                this.sourceFileDetailEntityMapper.updateByPrimaryKeySelective(update);
            }
        }
    }

    @Override
    public String confirmAgentIp(ConfirmAgentIpRequest request) {
        for (String ip : request.getIpList()) {
            List taskConfigs = this.sourceFileDetailEntityMapper.selectFileAgentTaskByIp(ip);
            if (taskConfigs.isEmpty()) continue;
            return ((FileAgentTaskConfig)taskConfigs.get(0)).getIp();
        }
        throw new IllegalArgumentException("Do not find any agent info with the ip's in db.");
    }

    @Override
    public List<FileAgentTaskConfig> checkAgentTaskConf(CheckAgentTaskConfRequest request) {
        List taskConfigs = this.sourceFileDetailEntityMapper.selectFileAgentTaskByIpForCheck(request.getAgentIp());
        LOGGER.info(request.getAgentIp() + " taskConfigs = " + taskConfigs);
        List<FileAgentTaskConfig> toAdds = this.getToBeAdded(request.getTaskInfo(), taskConfigs);
        List<Integer> toRemoves = this.getToBeRemoved(request.getTaskInfo(), taskConfigs);
        List<FileAgentTaskConfig> commons = this.commons(request.getTaskInfo(), taskConfigs);
        ArrayList<FileAgentTaskConfig> result = new ArrayList<FileAgentTaskConfig>(toAdds.size() + toRemoves.size());
        for (FileAgentTaskConfig fileAgentTaskConfig : toAdds) {
            int currentStatus = fileAgentTaskConfig.getStatus();
            if (currentStatus != 100) continue;
            fileAgentTaskConfig.setOp("0");
            this.setFileAgentTaskConfigAttr(fileAgentTaskConfig);
            result.add(fileAgentTaskConfig);
        }
        for (Integer remove : toRemoves) {
            FileAgentTaskConfig config = new FileAgentTaskConfig();
            config.setOp("1");
            config.setTaskId(remove.intValue());
            result.add(config);
        }
        for (FileAgentTaskConfig fileAgentTaskConfig : commons) {
            int currentStatus = fileAgentTaskConfig.getStatus();
            if (currentStatus == 101) {
                fileAgentTaskConfig.setOp("1");
                this.setFileAgentTaskConfigAttr(fileAgentTaskConfig);
                result.add(fileAgentTaskConfig);
                continue;
            }
            if (currentStatus == 104) {
                fileAgentTaskConfig.setOp("4");
                this.setFileAgentTaskConfigAttr(fileAgentTaskConfig);
                result.add(fileAgentTaskConfig);
                continue;
            }
            LOGGER.warn("Agent {} report taskid = {} with status {}, Skip taskid fileAgentTaskConfig = {} ", new Object[]{request.getAgentIp(), fileAgentTaskConfig.getTaskId(), currentStatus, fileAgentTaskConfig});
        }
        return result;
    }

    private void setFileAgentTaskConfigAttr(FileAgentTaskConfig config) {
        FileAgentDataGenerateRule ruleEnu = FileAgentDataGenerateRule.fromRuleValue((String)config.getDataGenerateRule());
        if (ruleEnu != null) {
            config.setScheduleTime(ruleEnu.getScheduleRule());
        }
        StringBuilder s = new StringBuilder();
        s.append("m=").append(config.getSortType()).append("&");
        s.append("iname=").append(config.getDataStreamIdentifier()).append("&");
        if (config.getDataGenerateRule().equalsIgnoreCase("minute")) {
            s.append("p=t").append("&");
        }
        List preFields = this.dataStreamFieldEntityMapper.queryDataStreamPreFields(config.getBusinessIdentifier(), config.getDataStreamIdentifier());
        if (!config.getSortType().equalsIgnoreCase("13")) {
            int fIndex = 0;
            for (DataStreamFieldEntity f : preFields) {
                s.append("__addcol" + fIndex + "__" + f.getFieldName());
                s.append("=");
                s.append(f.getFieldValue());
                s.append("&");
            }
        }
        config.setAdditionalAttr(s.toString().substring(0, s.toString().length() - 1));
    }

    @Override
    public String reportAgentStatus(AgentStatusReportRequest request) {
        Gson gson = new GsonBuilder().create();
        LOGGER.info(gson.toJson((Object)request));
        return "Success";
    }

    private List<FileAgentTaskConfig> getToBeAdded(List<Integer> taskInfo, List<FileAgentTaskConfig> taskConfigs) {
        HashMap<Integer, FileAgentTaskConfig> all = new HashMap<Integer, FileAgentTaskConfig>();
        for (FileAgentTaskConfig config : taskConfigs) {
            all.put(config.getTaskId(), config);
        }
        for (Integer entry : taskInfo) {
            all.remove(entry);
        }
        return new ArrayList<FileAgentTaskConfig>(all.values());
    }

    private List<Integer> getToBeRemoved(List<Integer> taskInfo, List<FileAgentTaskConfig> taskConfigs) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        HashMap<Integer, FileAgentTaskConfig> all = new HashMap<Integer, FileAgentTaskConfig>();
        for (FileAgentTaskConfig config : taskConfigs) {
            all.put(config.getTaskId(), config);
        }
        for (Integer entry : taskInfo) {
            if (all.containsKey(entry)) continue;
            toRemove.add(entry);
        }
        return toRemove;
    }

    private List<FileAgentTaskConfig> commons(List<Integer> taskInfo, List<FileAgentTaskConfig> taskConfigs) {
        HashMap<Integer, FileAgentTaskConfig> all = new HashMap<Integer, FileAgentTaskConfig>();
        ArrayList<FileAgentTaskConfig> commons = new ArrayList<FileAgentTaskConfig>();
        for (FileAgentTaskConfig config : taskConfigs) {
            all.put(config.getTaskId(), config);
        }
        for (Integer entry : taskInfo) {
            if (!all.containsKey(entry)) continue;
            commons.add((FileAgentTaskConfig)all.get(entry));
        }
        return commons;
    }
}

