/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.enums.EntityStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileBasicInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileDetailInfo;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileDetailListVO;
import org.apache.inlong.manager.common.pojo.datasource.SourceFileDetailPageRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.BusinessEntity;
import org.apache.inlong.manager.dao.entity.SourceFileBasicEntity;
import org.apache.inlong.manager.dao.entity.SourceFileDetailEntity;
import org.apache.inlong.manager.dao.mapper.BusinessEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceFileBasicEntityMapper;
import org.apache.inlong.manager.dao.mapper.SourceFileDetailEntityMapper;
import org.apache.inlong.manager.service.core.SourceFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SourceFileServiceImpl
implements SourceFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceFileServiceImpl.class);
    @Autowired
    private SourceFileBasicEntityMapper fileBasicMapper;
    @Autowired
    private SourceFileDetailEntityMapper fileDetailMapper;
    @Autowired
    private BusinessEntityMapper businessMapper;

    @Override
    public Integer saveBasic(SourceFileBasicInfo basicInfo, String operator) {
        LOGGER.info("begin to save file data source basic={}", (Object)basicInfo);
        Preconditions.checkNotNull((Object)basicInfo, (String)"file data source basic is empty");
        String bid = basicInfo.getBusinessIdentifier();
        String dsid = basicInfo.getDataStreamIdentifier();
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        this.checkBizIsTempStatus(bid);
        SourceFileBasicEntity exist = this.fileBasicMapper.selectByIdentifier(bid, dsid);
        if (exist != null) {
            LOGGER.error("file data source basic already exists, please check");
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DUPLICATE);
        }
        SourceFileBasicEntity entity = (SourceFileBasicEntity)CommonBeanUtils.copyProperties((Object)basicInfo, SourceFileBasicEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        entity.setCreateTime(new Date());
        this.fileBasicMapper.insertSelective(entity);
        LOGGER.info("success to save file data source basic");
        return entity.getId();
    }

    @Override
    public SourceFileBasicInfo getBasicByIdentifier(String bid, String dsid) {
        LOGGER.info("begin to get file data source basic by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        SourceFileBasicEntity entity = this.fileBasicMapper.selectByIdentifier(bid, dsid);
        SourceFileBasicInfo basicInfo = new SourceFileBasicInfo();
        if (entity == null) {
            LOGGER.error("file data source basic not found by dataStreamIdentifier={}", (Object)dsid);
            return basicInfo;
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)basicInfo);
        LOGGER.info("success to get file data source basic");
        return basicInfo;
    }

    @Override
    public boolean updateBasic(SourceFileBasicInfo basicInfo, String operator) {
        LOGGER.info("begin to update file data source basic={}", (Object)basicInfo);
        Preconditions.checkNotNull((Object)basicInfo, (String)"file data source basic is empty");
        this.checkBizIsTempStatus(basicInfo.getBusinessIdentifier());
        if (basicInfo.getId() == null) {
            this.saveBasic(basicInfo, operator);
        } else {
            SourceFileBasicEntity basicEntity = this.fileBasicMapper.selectByPrimaryKey(basicInfo.getId());
            if (basicEntity == null) {
                LOGGER.error("file data source basic not found by id={}, update failed", (Object)basicInfo.getId());
                throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_NOT_FOUND);
            }
            BeanUtils.copyProperties((Object)basicInfo, (Object)basicEntity);
            basicEntity.setModifier(operator);
            this.fileBasicMapper.updateByPrimaryKeySelective(basicEntity);
        }
        LOGGER.info("success to update file data source basic");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteBasic(Integer id, String operator) {
        LOGGER.info("begin to delete file data source basic, id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"file data source basic's id is null");
        SourceFileBasicEntity entity = this.fileBasicMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("file data source basic not found by id={}, delete failed", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_NOT_FOUND);
        }
        String bid = entity.getBusinessIdentifier();
        String dsid = entity.getDataStreamIdentifier();
        this.checkBizIsTempStatus(bid);
        List detailEntities = this.fileDetailMapper.selectByIdentifier(bid, dsid);
        if (CollectionUtils.isNotEmpty((Collection)detailEntities)) {
            LOGGER.error("the data source basic have [{}] details, delete failed", (Object)detailEntities.size());
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_BASIC_DELETE_HAS_DETAIL);
        }
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(operator);
        int resultCount = this.fileBasicMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete file data source basic");
        return resultCount >= 0;
    }

    @Override
    public Integer saveDetail(SourceFileDetailInfo detailInfo, String operator) {
        LOGGER.info("begin to save file data source detail={}", (Object)detailInfo);
        Preconditions.checkNotNull((Object)detailInfo, (String)"file data source detail is empty");
        Preconditions.checkNotNull((Object)detailInfo.getBusinessIdentifier(), (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)detailInfo.getDataStreamIdentifier(), (String)"dataStreamIdentifier is empty");
        this.checkBizIsTempStatus(detailInfo.getBusinessIdentifier());
        int id = this.saveDetailOpt(detailInfo, operator);
        LOGGER.info("success to save file data source detail");
        return id;
    }

    @Override
    public SourceFileDetailInfo getDetailById(Integer id) {
        LOGGER.info("begin to get file data source detail by id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"file data source detail's id is null");
        SourceFileDetailEntity entity = this.fileDetailMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("file data source detail not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
        }
        SourceFileDetailInfo detailInfo = (SourceFileDetailInfo)CommonBeanUtils.copyProperties((Object)entity, SourceFileDetailInfo::new);
        LOGGER.info("success to get file data source detail");
        return detailInfo;
    }

    @Override
    public List<SourceFileDetailInfo> listDetailByIdentifier(String bid, String dsid) {
        LOGGER.info("begin list file data source detail by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        List entities = this.fileDetailMapper.selectByIdentifier(bid, dsid);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            LOGGER.error("file data source detail not found");
            return Collections.emptyList();
        }
        List infoList = CommonBeanUtils.copyListProperties((List)entities, SourceFileDetailInfo::new);
        LOGGER.info("success to list file data source detail");
        return infoList;
    }

    @Override
    public PageInfo<SourceFileDetailListVO> listByCondition(SourceFileDetailPageRequest request) {
        LOGGER.info("begin to list file data source detail page by {}", (Object)request);
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page page = (Page)this.fileDetailMapper.selectByCondition(request);
        List detailList = CommonBeanUtils.copyListProperties((List)page, SourceFileDetailListVO::new);
        PageInfo pageInfo = new PageInfo(detailList);
        pageInfo.setTotal(page.getTotal());
        LOGGER.info("success to list file data source detail");
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean updateDetail(SourceFileDetailInfo detailInfo, String operator) {
        LOGGER.info("begin to update file data source detail={}", (Object)detailInfo);
        Preconditions.checkNotNull((Object)detailInfo, (String)"file data source detail is empty");
        Preconditions.checkNotNull((Object)detailInfo.getBusinessIdentifier(), (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)detailInfo.getDataStreamIdentifier(), (String)"dataStreamIdentifier is empty");
        this.checkBizIsTempStatus(detailInfo.getBusinessIdentifier());
        if (detailInfo.getId() != null) {
            SourceFileDetailEntity entity = this.fileDetailMapper.selectByPrimaryKey(detailInfo.getId());
            if (entity == null) {
                LOGGER.error("file data source detail not found by id=" + detailInfo.getIp());
                throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
            }
            BeanUtils.copyProperties((Object)detailInfo, (Object)entity);
            entity.setStatus(EntityStatus.BIZ_CONFIG_ING.getCode());
            entity.setModifier(operator);
            this.fileDetailMapper.updateByPrimaryKeySelective(entity);
        } else {
            this.saveDetailOpt(detailInfo, operator);
        }
        LOGGER.info("success to update file data source detail");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteDetail(Integer id, String operator) {
        LOGGER.info("begin to delete file data source detail, id={}", (Object)id);
        Preconditions.checkNotNull((Object)id, (String)"file data source detail's id is null");
        SourceFileDetailEntity entity = this.fileDetailMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("file data source detail not found by id={}", (Object)id);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DETAIL_NOT_FOUND);
        }
        this.checkBizIsTempStatus(entity.getBusinessIdentifier());
        entity.setIsDeleted(Integer.valueOf(1));
        entity.setModifier(operator);
        int resultCount = this.fileDetailMapper.updateByPrimaryKey(entity);
        LOGGER.info("success to delete file data source detail");
        return resultCount >= 0;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean deleteAllByIdentifier(String bid, String dsid) {
        LOGGER.info("begin delete all file basic and detail by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        this.checkBizIsTempStatus(bid);
        this.fileBasicMapper.deleteByIdentifier(bid, dsid);
        this.fileDetailMapper.deleteByIdentifier(bid, dsid);
        LOGGER.info("success delete all file basic and detail");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean logicDeleteAllByIdentifier(String bid, String dsid, String operator) {
        LOGGER.info("begin logic delete all file basic and detail by bid={}, dsid={}", (Object)bid, (Object)dsid);
        Preconditions.checkNotNull((Object)bid, (String)"businessIdentifier is empty");
        Preconditions.checkNotNull((Object)dsid, (String)"dataStreamIdentifier is empty");
        this.checkBizIsTempStatus(bid);
        this.fileBasicMapper.logicDeleteByIdentifier(bid, dsid, operator);
        this.fileDetailMapper.logicDeleteByIdentifier(bid, dsid, operator);
        LOGGER.info("success logic delete all file basic and detail");
        return true;
    }

    @Transactional(rollbackFor={Throwable.class})
    int saveDetailOpt(SourceFileDetailInfo detailInfo, String operator) {
        String username;
        String ip;
        String dsid;
        String bid = detailInfo.getBusinessIdentifier();
        Integer count = this.fileDetailMapper.selectDetailExist(bid, dsid = detailInfo.getDataStreamIdentifier(), ip = detailInfo.getIp(), username = detailInfo.getUsername());
        if (count > 0) {
            LOGGER.error("file data source already exists: bid=" + bid + ", dsid=" + dsid + ", ip=" + ip + ", username=" + username);
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_DUPLICATE);
        }
        SourceFileDetailEntity detailEntity = (SourceFileDetailEntity)CommonBeanUtils.copyProperties((Object)detailInfo, SourceFileDetailEntity::new);
        detailEntity.setStatus(EntityStatus.DATA_RESOURCE_NEW.getCode());
        detailEntity.setCreator(operator);
        detailEntity.setModifier(operator);
        detailEntity.setCreateTime(new Date());
        this.fileDetailMapper.insertSelective(detailEntity);
        return detailEntity.getId();
    }

    private void checkBizIsTempStatus(String bid) {
        BusinessEntity businessEntity = this.businessMapper.selectByIdentifier(bid);
        Preconditions.checkNotNull((Object)businessEntity, (String)"businessIdentifier is invalid");
        if (EntityStatus.BIZ_TEMP_STATUS.contains((Object)businessEntity.getStatus())) {
            LOGGER.error("business status was not allowed to add/update/delete data source info");
            throw new BusinessException(BizErrorCodeEnum.DATA_SOURCE_OPT_NOT_ALLOWED);
        }
    }
}

