/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.repository;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.inlong.commons.pojo.dataproxy.CacheClusterObject;
import org.apache.inlong.commons.pojo.dataproxy.CacheClusterSetObject;
import org.apache.inlong.commons.pojo.dataproxy.CacheTopicObject;
import org.apache.inlong.commons.pojo.dataproxy.DataProxyCluster;
import org.apache.inlong.commons.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.commons.pojo.dataproxy.IRepository;
import org.apache.inlong.commons.pojo.dataproxy.InLongIdObject;
import org.apache.inlong.commons.pojo.dataproxy.ProxyChannel;
import org.apache.inlong.commons.pojo.dataproxy.ProxyClusterObject;
import org.apache.inlong.commons.pojo.dataproxy.ProxySink;
import org.apache.inlong.commons.pojo.dataproxy.ProxySource;
import org.apache.inlong.commons.pojo.dataproxy.RepositoryTimerTask;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyClusterSet;
import org.apache.inlong.manager.dao.entity.CacheCluster;
import org.apache.inlong.manager.dao.entity.CacheClusterExt;
import org.apache.inlong.manager.dao.entity.CacheTopic;
import org.apache.inlong.manager.dao.entity.ClusterSet;
import org.apache.inlong.manager.dao.entity.FlumeChannel;
import org.apache.inlong.manager.dao.entity.FlumeChannelExt;
import org.apache.inlong.manager.dao.entity.FlumeSink;
import org.apache.inlong.manager.dao.entity.FlumeSinkExt;
import org.apache.inlong.manager.dao.entity.FlumeSource;
import org.apache.inlong.manager.dao.entity.FlumeSourceExt;
import org.apache.inlong.manager.dao.entity.InLongId;
import org.apache.inlong.manager.dao.entity.ProxyCluster;
import org.apache.inlong.manager.dao.entity.ProxyClusterToCacheCluster;
import org.apache.inlong.manager.dao.mapper.ClusterSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="dataProxyConfigRepository")
public class DataProxyConfigRepository
implements IRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProxyConfigRepository.class);
    public static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    @Autowired
    private ClusterSetMapper clusterSetMapper;
    private Map<String, DataProxyClusterSet> clusterSets = new HashMap<String, DataProxyClusterSet>();
    private final Map<String, ProxyClusterObject> proxyClusterMap = new HashMap<String, ProxyClusterObject>();
    private final Map<String, CacheClusterObject> cacheClusterMap = new HashMap<String, CacheClusterObject>();
    private long reloadInterval;
    private Gson gson = new Gson();

    @PostConstruct
    public void initialize() {
        LOGGER.info("create repository for {}" + DataProxyConfigRepository.class.getSimpleName());
        try {
            this.reloadInterval = 60000L;
            this.reload();
            this.setReloadTimer();
        }
        catch (Throwable t) {
            LOGGER.error("Initialize DataProxyConfigRepository error", t);
        }
    }

    public void reload() {
        LOGGER.info("start to reload config.");
        List setList = this.clusterSetMapper.selectClusterSet();
        if (setList.size() == 0) {
            return;
        }
        HashMap<String, DataProxyClusterSet> newClusterSets = new HashMap<String, DataProxyClusterSet>();
        for (ClusterSet set : setList) {
            String setName = set.getSetName();
            DataProxyClusterSet setObj = new DataProxyClusterSet();
            setObj.setSetName(setName);
            setObj.getCacheClusterSet().setSetName(setName);
            setObj.getCacheClusterSet().setType(set.getMiddlewareType());
            newClusterSets.put(setName, setObj);
        }
        this.proxyClusterMap.clear();
        this.cacheClusterMap.clear();
        this.reloadCacheCluster(newClusterSets);
        this.reloadCacheClusterExt(newClusterSets);
        this.reloadCacheTopic(newClusterSets);
        this.reloadProxyCluster(newClusterSets);
        this.reloadFlumeChannel(newClusterSets);
        this.reloadFlumeChannelExt(newClusterSets);
        this.reloadFlumeSource(newClusterSets);
        this.reloadFlumeSourceExt(newClusterSets);
        this.reloadFlumeSink(newClusterSets);
        this.reloadFlumeSinkExt(newClusterSets);
        this.reloadInlongId(newClusterSets);
        this.reloadProxy2Cache(newClusterSets);
        this.generateClusterJson(newClusterSets);
        this.clusterSets = newClusterSets;
        LOGGER.info("end to reload config.");
    }

    private void setReloadTimer() {
        Timer reloadTimer = new Timer(true);
        RepositoryTimerTask task = new RepositoryTimerTask((IRepository)this);
        reloadTimer.scheduleAtFixedRate((TimerTask)task, this.reloadInterval, this.reloadInterval);
    }

    public Map<String, DataProxyClusterSet> getClusterSets() {
        return this.clusterSets;
    }

    private void reloadCacheCluster(Map<String, DataProxyClusterSet> newClusterSets) {
        for (CacheCluster cacheCluster : this.clusterSetMapper.selectCacheCluster()) {
            CacheClusterObject obj = new CacheClusterObject();
            obj.setName(cacheCluster.getClusterName());
            obj.setZone(cacheCluster.getZone());
            this.cacheClusterMap.put(obj.getName(), obj);
            String setName = cacheCluster.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            setObj.getCacheClusterSet().getCacheClusters().add(obj);
        }
    }

    private DataProxyClusterSet getOrCreateDataProxyClusterSet(Map<String, DataProxyClusterSet> clusterSets, String setName) {
        DataProxyClusterSet setObj = clusterSets.get(setName);
        if (setObj == null) {
            setObj = new DataProxyClusterSet();
            setObj.setSetName(setName);
            clusterSets.put(setName, setObj);
        }
        return setObj;
    }

    private void reloadCacheClusterExt(Map<String, DataProxyClusterSet> newClusterSets) {
        for (CacheClusterExt ext : this.clusterSetMapper.selectCacheClusterExt()) {
            String clusterName = ext.getClusterName();
            CacheClusterObject cacheClusterObject = this.cacheClusterMap.get(clusterName);
            if (cacheClusterObject == null) continue;
            cacheClusterObject.getParams().put(ext.getKeyName(), ext.getKeyValue());
        }
    }

    private void reloadCacheTopic(Map<String, DataProxyClusterSet> newClusterSets) {
        for (CacheTopic cacheTopic : this.clusterSetMapper.selectCacheTopic()) {
            CacheTopicObject obj = new CacheTopicObject();
            obj.setTopic(cacheTopic.getTopicName());
            obj.setPartitionNum(cacheTopic.getPartitionNum());
            String setName = cacheTopic.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            setObj.getCacheClusterSet().getTopics().add(obj);
        }
    }

    private void reloadProxyCluster(Map<String, DataProxyClusterSet> newClusterSets) {
        for (ProxyCluster proxyCluster : this.clusterSetMapper.selectProxyCluster()) {
            String setName = proxyCluster.getSetName();
            ProxyClusterObject obj = new ProxyClusterObject();
            obj.setName(proxyCluster.getClusterName());
            obj.setSetName(setName);
            obj.setZone(proxyCluster.getZone());
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            setObj.getProxyClusterList().add(obj);
            this.proxyClusterMap.put(obj.getName(), obj);
        }
    }

    private void reloadFlumeChannel(Map<String, DataProxyClusterSet> newClusterSets) {
        for (FlumeChannel flumeChannel : this.clusterSetMapper.selectFlumeChannel()) {
            ProxyChannel obj = new ProxyChannel();
            obj.setName(flumeChannel.getChannelName());
            obj.setType(flumeChannel.getType());
            String setName = flumeChannel.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            setObj.getProxyChannelMap().put(obj.getName(), obj);
        }
    }

    private void reloadFlumeChannelExt(Map<String, DataProxyClusterSet> newClusterSets) {
        for (FlumeChannelExt ext : this.clusterSetMapper.selectFlumeChannelExt()) {
            String setName = ext.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            ProxyChannel obj = (ProxyChannel)setObj.getProxyChannelMap().get(ext.getParentName());
            if (obj == null) continue;
            obj.getParams().put(ext.getKeyName(), ext.getKeyValue());
        }
    }

    private void reloadFlumeSource(Map<String, DataProxyClusterSet> newClusterSets) {
        for (FlumeSource flumeSource : this.clusterSetMapper.selectFlumeSource()) {
            ProxySource obj = new ProxySource();
            obj.setName(flumeSource.getSourceName());
            obj.setSelectorType(flumeSource.getSelectorType());
            obj.setType(flumeSource.getType());
            String channels = flumeSource.getChannels();
            obj.getChannels().addAll(Arrays.asList(channels.split("\\s+")));
            String setName = flumeSource.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            setObj.getProxySourceMap().put(obj.getName(), obj);
        }
    }

    private void reloadFlumeSourceExt(Map<String, DataProxyClusterSet> newClusterSets) {
        for (FlumeSourceExt ext : this.clusterSetMapper.selectFlumeSourceExt()) {
            String setName = ext.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            ProxySource obj = (ProxySource)setObj.getProxySourceMap().get(ext.getParentName());
            if (obj == null) continue;
            obj.getParams().put(ext.getKeyName(), ext.getKeyValue());
        }
    }

    private void reloadFlumeSink(Map<String, DataProxyClusterSet> newClusterSets) {
        for (FlumeSink flumeSink : this.clusterSetMapper.selectFlumeSink()) {
            ProxySink obj = new ProxySink();
            obj.setName(flumeSink.getSinkName());
            obj.setType(flumeSink.getType());
            obj.setChannel(flumeSink.getChannel());
            String setName = flumeSink.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            setObj.getProxySinkMap().put(obj.getName(), obj);
        }
    }

    private void reloadFlumeSinkExt(Map<String, DataProxyClusterSet> newClusterSets) {
        for (FlumeSinkExt ext : this.clusterSetMapper.selectFlumeSinkExt()) {
            String setName = ext.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            ProxySink obj = (ProxySink)setObj.getProxySinkMap().get(ext.getParentName());
            if (obj == null) continue;
            obj.getParams().put(ext.getKeyName(), ext.getKeyValue());
        }
    }

    private void reloadInlongId(Map<String, DataProxyClusterSet> newClusterSets) {
        for (InLongId inlongId : this.clusterSetMapper.selectInlongId()) {
            InLongIdObject obj = new InLongIdObject();
            obj.setInlongId(inlongId.getInlongId());
            obj.setTopic(inlongId.getTopic());
            if (inlongId.getParams() != null) {
                Map params = MAP_SPLITTER.split((CharSequence)inlongId.getParams());
                obj.getParams().putAll(params);
            }
            String setName = inlongId.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            setObj.getInlongIds().add(obj);
        }
    }

    private void reloadProxy2Cache(Map<String, DataProxyClusterSet> newClusterSets) {
        for (ProxyClusterToCacheCluster proxy2Cache : this.clusterSetMapper.selectProxyClusterToCacheCluster()) {
            CacheClusterObject cacheObj;
            String proxyClusterName = proxy2Cache.getProxyClusterName();
            String cacheClusterName = proxy2Cache.getCacheClusterName();
            ProxyClusterObject proxyObj = this.proxyClusterMap.get(proxyClusterName);
            if (proxyObj == null || (cacheObj = this.cacheClusterMap.get(cacheClusterName)) == null) continue;
            String setName = proxyObj.getSetName();
            DataProxyClusterSet setObj = this.getOrCreateDataProxyClusterSet(newClusterSets, setName);
            setObj.addProxy2Cache(proxyClusterName, cacheClusterName);
        }
    }

    private void generateClusterJson(Map<String, DataProxyClusterSet> newClusterSets) {
        for (Map.Entry<String, DataProxyClusterSet> entry : newClusterSets.entrySet()) {
            for (ProxyClusterObject proxyObj : entry.getValue().getProxyClusterList()) {
                DataProxyCluster clusterObj = new DataProxyCluster();
                clusterObj.setProxyCluster(proxyObj);
                CacheClusterSetObject allCacheCluster = entry.getValue().getCacheClusterSet();
                CacheClusterSetObject proxyCacheClusterSet = clusterObj.getCacheClusterSet();
                proxyCacheClusterSet.setSetName(allCacheCluster.getSetName());
                proxyCacheClusterSet.setType(allCacheCluster.getType());
                proxyCacheClusterSet.setTopics(allCacheCluster.getTopics());
                Set cacheClusterNameSet = (Set)entry.getValue().getProxy2Cache().get(proxyObj.getName());
                if (cacheClusterNameSet != null) {
                    for (String cacheClusterName : cacheClusterNameSet) {
                        CacheClusterObject cacheObj = this.cacheClusterMap.get(cacheClusterName);
                        if (cacheObj == null) continue;
                        proxyCacheClusterSet.getCacheClusters().add(cacheObj);
                    }
                }
                String jsonDataProxyCluster = this.gson.toJson((Object)clusterObj);
                String md5 = DigestUtils.md5Hex((String)jsonDataProxyCluster);
                DataProxyConfigResponse response = new DataProxyConfigResponse();
                response.setResult(Boolean.valueOf(true));
                response.setErrCode(Integer.valueOf(0));
                response.setMd5(md5);
                response.setData(clusterObj);
                String jsonResponse = this.gson.toJson((Object)clusterObj);
                entry.getValue().getProxyConfigJson().put(proxyObj.getName(), jsonResponse);
                entry.getValue().getMd5Map().put(proxyObj.getName(), md5);
                entry.getValue().setDefaultConfigJson(jsonResponse);
            }
        }
    }

    public DataProxyClusterSet getDataProxyClusterSet(String setName) {
        DataProxyClusterSet setObj = this.clusterSets.get(setName);
        return setObj;
    }
}

