/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.thirdpart.mq;

import java.util.Collections;
import org.apache.inlong.manager.common.beans.TryBean;
import org.apache.inlong.manager.common.pojo.business.BusinessInfo;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeConsumeGroupRequest;
import org.apache.inlong.manager.common.pojo.tubemq.QueryTubeTopicRequest;
import org.apache.inlong.manager.dao.mapper.ClusterInfoMapper;
import org.apache.inlong.manager.service.core.BusinessService;
import org.apache.inlong.manager.service.thirdpart.mq.TubeMqOptService;
import org.apache.inlong.manager.service.workflow.newbusiness.CreateResourceWorkflowForm;
import org.apache.inlong.manager.workflow.core.event.ListenerResult;
import org.apache.inlong.manager.workflow.core.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.core.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.exception.WorkflowListenerException;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CreateTubeConsumeGroupTaskEventListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(CreateTubeConsumeGroupTaskEventListener.class);
    @Autowired
    BusinessService businessService;
    @Autowired
    ClusterInfoMapper clusterInfoMapper;
    @Autowired
    TubeMqOptService tubeMqOptService;
    @Value(value="${cluster.tube.clusterId}")
    Integer clusterId;
    @Autowired
    TryBean tryBean;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        CreateResourceWorkflowForm form = (CreateResourceWorkflowForm)context.getProcessForm();
        String bid = form.getBusinessId();
        log.info("try to create consumer group for bid {}", (Object)bid);
        BusinessInfo businessInfo = this.businessService.get(bid);
        String topicName = businessInfo.getMqResourceObj();
        QueryTubeTopicRequest queryTubeTopicRequest = QueryTubeTopicRequest.builder().topicName(topicName).clusterId(this.clusterId).user(businessInfo.getCreator()).build();
        boolean topicExist = this.tubeMqOptService.queryTopicIsExist(queryTubeTopicRequest);
        Integer tryNumber = this.tryBean.getMaxAttempts();
        Long delay = this.tryBean.getDelay();
        while (!topicExist && (tryNumber = Integer.valueOf(tryNumber - 1)) > 0) {
            log.info("check whether the tube topic exists, try count={}", (Object)tryNumber);
            try {
                Thread.sleep(delay);
                delay = delay * (long)this.tryBean.getMultiplier().intValue();
                topicExist = this.tubeMqOptService.queryTopicIsExist(queryTubeTopicRequest);
            }
            catch (InterruptedException e) {
                log.error("check the tube topic exists error", (Throwable)e);
            }
        }
        AddTubeConsumeGroupRequest addTubeConsumeGroupRequest = new AddTubeConsumeGroupRequest();
        addTubeConsumeGroupRequest.setClusterId(this.clusterId.intValue());
        addTubeConsumeGroupRequest.setCreateUser(businessInfo.getCreator());
        AddTubeConsumeGroupRequest.GroupNameJsonSetBean groupNameJsonSetBean = new AddTubeConsumeGroupRequest.GroupNameJsonSetBean();
        groupNameJsonSetBean.setTopicName(topicName);
        String consumeGroupName = "sort_" + topicName + "_consumer_group";
        groupNameJsonSetBean.setGroupName(consumeGroupName);
        addTubeConsumeGroupRequest.setGroupNameJsonSet(Collections.singletonList(groupNameJsonSetBean));
        try {
            this.tubeMqOptService.createNewConsumerGroup(addTubeConsumeGroupRequest);
        }
        catch (Exception e) {
            log.error("create tube consume group for bid={} error {}", new Object[]{bid, e.getMessage(), e});
        }
        log.info("finish to create consumer group for {}", (Object)bid);
        return ListenerResult.success();
    }

    public boolean async() {
        return true;
    }
}

