/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import io.swagger.annotations.ApiModelProperty;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.workflow.model.instance.EventLog;
import org.apache.inlong.manager.workflow.model.instance.TaskInstance;

public class WorkflowTaskExecuteLog {
    @ApiModelProperty(value="Process ID")
    private Integer processInstId;
    @ApiModelProperty(value="Process name")
    private String processDisplayName;
    @ApiModelProperty(value="Process status: same task status, such as processing: PROCESSING, completed: COMPLETED, rejected: REJECTED, cancelled: CANCELED, terminated: TERMINATED")
    private String state;
    @ApiModelProperty(value="Start time")
    private Date startTime;
    @ApiModelProperty(value="End time")
    private Date endTime;
    @ApiModelProperty(value="Task execution log")
    private List<TaskExecutorLog> taskExecutorLogs;

    public static WorkflowTaskExecuteLogBuilder builder() {
        return new WorkflowTaskExecuteLogBuilder();
    }

    public Integer getProcessInstId() {
        return this.processInstId;
    }

    public String getProcessDisplayName() {
        return this.processDisplayName;
    }

    public String getState() {
        return this.state;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public List<TaskExecutorLog> getTaskExecutorLogs() {
        return this.taskExecutorLogs;
    }

    public void setProcessInstId(Integer processInstId) {
        this.processInstId = processInstId;
    }

    public void setProcessDisplayName(String processDisplayName) {
        this.processDisplayName = processDisplayName;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setTaskExecutorLogs(List<TaskExecutorLog> taskExecutorLogs) {
        this.taskExecutorLogs = taskExecutorLogs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowTaskExecuteLog)) {
            return false;
        }
        WorkflowTaskExecuteLog other = (WorkflowTaskExecuteLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$processInstId = this.getProcessInstId();
        Integer other$processInstId = other.getProcessInstId();
        if (this$processInstId == null ? other$processInstId != null : !((Object)this$processInstId).equals(other$processInstId)) {
            return false;
        }
        String this$processDisplayName = this.getProcessDisplayName();
        String other$processDisplayName = other.getProcessDisplayName();
        if (this$processDisplayName == null ? other$processDisplayName != null : !this$processDisplayName.equals(other$processDisplayName)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<TaskExecutorLog> this$taskExecutorLogs = this.getTaskExecutorLogs();
        List<TaskExecutorLog> other$taskExecutorLogs = other.getTaskExecutorLogs();
        return !(this$taskExecutorLogs == null ? other$taskExecutorLogs != null : !((Object)this$taskExecutorLogs).equals(other$taskExecutorLogs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkflowTaskExecuteLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $processInstId = this.getProcessInstId();
        result = result * 59 + ($processInstId == null ? 43 : ((Object)$processInstId).hashCode());
        String $processDisplayName = this.getProcessDisplayName();
        result = result * 59 + ($processDisplayName == null ? 43 : $processDisplayName.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<TaskExecutorLog> $taskExecutorLogs = this.getTaskExecutorLogs();
        result = result * 59 + ($taskExecutorLogs == null ? 43 : ((Object)$taskExecutorLogs).hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowTaskExecuteLog(processInstId=" + this.getProcessInstId() + ", processDisplayName=" + this.getProcessDisplayName() + ", state=" + this.getState() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", taskExecutorLogs=" + this.getTaskExecutorLogs() + ")";
    }

    public WorkflowTaskExecuteLog() {
    }

    public WorkflowTaskExecuteLog(Integer processInstId, String processDisplayName, String state, Date startTime, Date endTime, List<TaskExecutorLog> taskExecutorLogs) {
        this.processInstId = processInstId;
        this.processDisplayName = processDisplayName;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.taskExecutorLogs = taskExecutorLogs;
    }

    public static class WorkflowTaskExecuteLogBuilder {
        private Integer processInstId;
        private String processDisplayName;
        private String state;
        private Date startTime;
        private Date endTime;
        private List<TaskExecutorLog> taskExecutorLogs;

        WorkflowTaskExecuteLogBuilder() {
        }

        public WorkflowTaskExecuteLogBuilder processInstId(Integer processInstId) {
            this.processInstId = processInstId;
            return this;
        }

        public WorkflowTaskExecuteLogBuilder processDisplayName(String processDisplayName) {
            this.processDisplayName = processDisplayName;
            return this;
        }

        public WorkflowTaskExecuteLogBuilder state(String state) {
            this.state = state;
            return this;
        }

        public WorkflowTaskExecuteLogBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public WorkflowTaskExecuteLogBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public WorkflowTaskExecuteLogBuilder taskExecutorLogs(List<TaskExecutorLog> taskExecutorLogs) {
            this.taskExecutorLogs = taskExecutorLogs;
            return this;
        }

        public WorkflowTaskExecuteLog build() {
            return new WorkflowTaskExecuteLog(this.processInstId, this.processDisplayName, this.state, this.startTime, this.endTime, this.taskExecutorLogs);
        }

        public String toString() {
            return "WorkflowTaskExecuteLog.WorkflowTaskExecuteLogBuilder(processInstId=" + this.processInstId + ", processDisplayName=" + this.processDisplayName + ", state=" + this.state + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", taskExecutorLogs=" + this.taskExecutorLogs + ")";
        }
    }

    static class ListenerExecutorLog {
        @ApiModelProperty(value="id")
        private Integer id;
        @ApiModelProperty(value="Event type")
        private String eventType;
        @ApiModelProperty(value="Event")
        private String event;
        @ApiModelProperty(value="Listener name")
        private String listener;
        @ApiModelProperty(value="Status")
        private Integer state;
        @ApiModelProperty(value="Is it synchronized")
        private Boolean async;
        @ApiModelProperty(value="Execute IP")
        private String ip;
        @ApiModelProperty(value="Start time")
        private Date startTime;
        @ApiModelProperty(value="End time")
        private Date endTime;
        @ApiModelProperty(value="Execution result information")
        private String remark;
        @ApiModelProperty(value="Exception")
        private String exception;
        @ApiModelProperty(value="Description")
        private String description;

        public static ListenerExecutorLog fromEventLog(EventLog eventLog) {
            ListenerExecutorLog executorLog = ListenerExecutorLog.builder().id(eventLog.getId()).eventType(eventLog.getEventType()).event(eventLog.getEvent()).listener(eventLog.getListener()).state(eventLog.getState()).async(eventLog.getAsync()).ip(eventLog.getIp()).startTime(eventLog.getStartTime()).endTime(eventLog.getEndTime()).remark(eventLog.getRemark()).exception(eventLog.getException()).build();
            executorLog.buildDescription();
            return executorLog;
        }

        private void buildDescription() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String sb = sdf.format(this.startTime) + " ~ " + sdf.format(this.endTime) + " [" + this.listener + "] " + "event: [" + this.event + "], executed [" + (this.state == 1 ? "success" : "failed") + "], " + "remark: [" + this.remark + "], exception: [" + this.exception + "]";
            this.setDescription(sb);
        }

        public static ListenerExecutorLogBuilder builder() {
            return new ListenerExecutorLogBuilder();
        }

        public Integer getId() {
            return this.id;
        }

        public String getEventType() {
            return this.eventType;
        }

        public String getEvent() {
            return this.event;
        }

        public String getListener() {
            return this.listener;
        }

        public Integer getState() {
            return this.state;
        }

        public Boolean getAsync() {
            return this.async;
        }

        public String getIp() {
            return this.ip;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public String getRemark() {
            return this.remark;
        }

        public String getException() {
            return this.exception;
        }

        public String getDescription() {
            return this.description;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public void setEvent(String event) {
            this.event = event;
        }

        public void setListener(String listener) {
            this.listener = listener;
        }

        public void setState(Integer state) {
            this.state = state;
        }

        public void setAsync(Boolean async) {
            this.async = async;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public void setException(String exception) {
            this.exception = exception;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListenerExecutorLog)) {
                return false;
            }
            ListenerExecutorLog other = (ListenerExecutorLog)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Integer this$state = this.getState();
            Integer other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            Boolean this$async = this.getAsync();
            Boolean other$async = other.getAsync();
            if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
                return false;
            }
            String this$eventType = this.getEventType();
            String other$eventType = other.getEventType();
            if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
                return false;
            }
            String this$event = this.getEvent();
            String other$event = other.getEvent();
            if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
                return false;
            }
            String this$listener = this.getListener();
            String other$listener = other.getListener();
            if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            Date this$startTime = this.getStartTime();
            Date other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            String this$remark = this.getRemark();
            String other$remark = other.getRemark();
            if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
                return false;
            }
            String this$exception = this.getException();
            String other$exception = other.getException();
            if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ListenerExecutorLog;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Integer $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            Boolean $async = this.getAsync();
            result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
            String $eventType = this.getEventType();
            result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
            String $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            String $listener = this.getListener();
            result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            Date $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            String $remark = this.getRemark();
            result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
            String $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "WorkflowTaskExecuteLog.ListenerExecutorLog(id=" + this.getId() + ", eventType=" + this.getEventType() + ", event=" + this.getEvent() + ", listener=" + this.getListener() + ", state=" + this.getState() + ", async=" + this.getAsync() + ", ip=" + this.getIp() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", remark=" + this.getRemark() + ", exception=" + this.getException() + ", description=" + this.getDescription() + ")";
        }

        public ListenerExecutorLog() {
        }

        public ListenerExecutorLog(Integer id, String eventType, String event, String listener, Integer state, Boolean async, String ip, Date startTime, Date endTime, String remark, String exception, String description) {
            this.id = id;
            this.eventType = eventType;
            this.event = event;
            this.listener = listener;
            this.state = state;
            this.async = async;
            this.ip = ip;
            this.startTime = startTime;
            this.endTime = endTime;
            this.remark = remark;
            this.exception = exception;
            this.description = description;
        }

        public static class ListenerExecutorLogBuilder {
            private Integer id;
            private String eventType;
            private String event;
            private String listener;
            private Integer state;
            private Boolean async;
            private String ip;
            private Date startTime;
            private Date endTime;
            private String remark;
            private String exception;
            private String description;

            ListenerExecutorLogBuilder() {
            }

            public ListenerExecutorLogBuilder id(Integer id) {
                this.id = id;
                return this;
            }

            public ListenerExecutorLogBuilder eventType(String eventType) {
                this.eventType = eventType;
                return this;
            }

            public ListenerExecutorLogBuilder event(String event) {
                this.event = event;
                return this;
            }

            public ListenerExecutorLogBuilder listener(String listener) {
                this.listener = listener;
                return this;
            }

            public ListenerExecutorLogBuilder state(Integer state) {
                this.state = state;
                return this;
            }

            public ListenerExecutorLogBuilder async(Boolean async) {
                this.async = async;
                return this;
            }

            public ListenerExecutorLogBuilder ip(String ip) {
                this.ip = ip;
                return this;
            }

            public ListenerExecutorLogBuilder startTime(Date startTime) {
                this.startTime = startTime;
                return this;
            }

            public ListenerExecutorLogBuilder endTime(Date endTime) {
                this.endTime = endTime;
                return this;
            }

            public ListenerExecutorLogBuilder remark(String remark) {
                this.remark = remark;
                return this;
            }

            public ListenerExecutorLogBuilder exception(String exception) {
                this.exception = exception;
                return this;
            }

            public ListenerExecutorLogBuilder description(String description) {
                this.description = description;
                return this;
            }

            public ListenerExecutorLog build() {
                return new ListenerExecutorLog(this.id, this.eventType, this.event, this.listener, this.state, this.async, this.ip, this.startTime, this.endTime, this.remark, this.exception, this.description);
            }

            public String toString() {
                return "WorkflowTaskExecuteLog.ListenerExecutorLog.ListenerExecutorLogBuilder(id=" + this.id + ", eventType=" + this.eventType + ", event=" + this.event + ", listener=" + this.listener + ", state=" + this.state + ", async=" + this.async + ", ip=" + this.ip + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", remark=" + this.remark + ", exception=" + this.exception + ", description=" + this.description + ")";
            }
        }
    }

    static class TaskExecutorLog {
        @ApiModelProperty(value="Task type")
        private String taskType;
        @ApiModelProperty(value="Task ID")
        private Integer taskInstId;
        @ApiModelProperty(value="Task name")
        private String taskDisplayName;
        @ApiModelProperty(value="Execution status: same task status, such as complete: COMPLETE; failure: FAILED; processing: PENDING")
        private String state;
        @ApiModelProperty(value="Start time")
        private Date startTime;
        @ApiModelProperty(value="End time")
        private Date endTime;
        @ApiModelProperty(value="Listener execution log")
        private List<ListenerExecutorLog> listenerExecutorLogs;

        public static TaskExecutorLog buildFromTaskInst(TaskInstance taskInstance) {
            return TaskExecutorLog.builder().taskType(taskInstance.getType()).taskInstId(taskInstance.getId()).taskDisplayName(taskInstance.getDisplayName()).state(taskInstance.getState()).startTime(taskInstance.getStartTime()).endTime(taskInstance.getEndTime()).build();
        }

        public static TaskExecutorLogBuilder builder() {
            return new TaskExecutorLogBuilder();
        }

        public String getTaskType() {
            return this.taskType;
        }

        public Integer getTaskInstId() {
            return this.taskInstId;
        }

        public String getTaskDisplayName() {
            return this.taskDisplayName;
        }

        public String getState() {
            return this.state;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public List<ListenerExecutorLog> getListenerExecutorLogs() {
            return this.listenerExecutorLogs;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public void setTaskInstId(Integer taskInstId) {
            this.taskInstId = taskInstId;
        }

        public void setTaskDisplayName(String taskDisplayName) {
            this.taskDisplayName = taskDisplayName;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public void setListenerExecutorLogs(List<ListenerExecutorLog> listenerExecutorLogs) {
            this.listenerExecutorLogs = listenerExecutorLogs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorLog)) {
                return false;
            }
            TaskExecutorLog other = (TaskExecutorLog)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$taskInstId = this.getTaskInstId();
            Integer other$taskInstId = other.getTaskInstId();
            if (this$taskInstId == null ? other$taskInstId != null : !((Object)this$taskInstId).equals(other$taskInstId)) {
                return false;
            }
            String this$taskType = this.getTaskType();
            String other$taskType = other.getTaskType();
            if (this$taskType == null ? other$taskType != null : !this$taskType.equals(other$taskType)) {
                return false;
            }
            String this$taskDisplayName = this.getTaskDisplayName();
            String other$taskDisplayName = other.getTaskDisplayName();
            if (this$taskDisplayName == null ? other$taskDisplayName != null : !this$taskDisplayName.equals(other$taskDisplayName)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            Date this$startTime = this.getStartTime();
            Date other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
                return false;
            }
            List<ListenerExecutorLog> this$listenerExecutorLogs = this.getListenerExecutorLogs();
            List<ListenerExecutorLog> other$listenerExecutorLogs = other.getListenerExecutorLogs();
            return !(this$listenerExecutorLogs == null ? other$listenerExecutorLogs != null : !((Object)this$listenerExecutorLogs).equals(other$listenerExecutorLogs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskExecutorLog;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $taskInstId = this.getTaskInstId();
            result = result * 59 + ($taskInstId == null ? 43 : ((Object)$taskInstId).hashCode());
            String $taskType = this.getTaskType();
            result = result * 59 + ($taskType == null ? 43 : $taskType.hashCode());
            String $taskDisplayName = this.getTaskDisplayName();
            result = result * 59 + ($taskDisplayName == null ? 43 : $taskDisplayName.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            Date $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            List<ListenerExecutorLog> $listenerExecutorLogs = this.getListenerExecutorLogs();
            result = result * 59 + ($listenerExecutorLogs == null ? 43 : ((Object)$listenerExecutorLogs).hashCode());
            return result;
        }

        public String toString() {
            return "WorkflowTaskExecuteLog.TaskExecutorLog(taskType=" + this.getTaskType() + ", taskInstId=" + this.getTaskInstId() + ", taskDisplayName=" + this.getTaskDisplayName() + ", state=" + this.getState() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", listenerExecutorLogs=" + this.getListenerExecutorLogs() + ")";
        }

        public TaskExecutorLog() {
        }

        public TaskExecutorLog(String taskType, Integer taskInstId, String taskDisplayName, String state, Date startTime, Date endTime, List<ListenerExecutorLog> listenerExecutorLogs) {
            this.taskType = taskType;
            this.taskInstId = taskInstId;
            this.taskDisplayName = taskDisplayName;
            this.state = state;
            this.startTime = startTime;
            this.endTime = endTime;
            this.listenerExecutorLogs = listenerExecutorLogs;
        }

        public static class TaskExecutorLogBuilder {
            private String taskType;
            private Integer taskInstId;
            private String taskDisplayName;
            private String state;
            private Date startTime;
            private Date endTime;
            private List<ListenerExecutorLog> listenerExecutorLogs;

            TaskExecutorLogBuilder() {
            }

            public TaskExecutorLogBuilder taskType(String taskType) {
                this.taskType = taskType;
                return this;
            }

            public TaskExecutorLogBuilder taskInstId(Integer taskInstId) {
                this.taskInstId = taskInstId;
                return this;
            }

            public TaskExecutorLogBuilder taskDisplayName(String taskDisplayName) {
                this.taskDisplayName = taskDisplayName;
                return this;
            }

            public TaskExecutorLogBuilder state(String state) {
                this.state = state;
                return this;
            }

            public TaskExecutorLogBuilder startTime(Date startTime) {
                this.startTime = startTime;
                return this;
            }

            public TaskExecutorLogBuilder endTime(Date endTime) {
                this.endTime = endTime;
                return this;
            }

            public TaskExecutorLogBuilder listenerExecutorLogs(List<ListenerExecutorLog> listenerExecutorLogs) {
                this.listenerExecutorLogs = listenerExecutorLogs;
                return this;
            }

            public TaskExecutorLog build() {
                return new TaskExecutorLog(this.taskType, this.taskInstId, this.taskDisplayName, this.state, this.startTime, this.endTime, this.listenerExecutorLogs);
            }

            public String toString() {
                return "WorkflowTaskExecuteLog.TaskExecutorLog.TaskExecutorLogBuilder(taskType=" + this.taskType + ", taskInstId=" + this.taskInstId + ", taskDisplayName=" + this.taskDisplayName + ", state=" + this.state + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", listenerExecutorLogs=" + this.listenerExecutorLogs + ")";
            }
        }
    }
}

